/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.util.ArrayList;
import java.util.List;
import org.bndly.common.html.Attribute;
import org.bndly.common.html.Content;
import org.bndly.common.html.ContentContainer;

public abstract class AbstractTag
implements Content {
    private final ContentContainer parent;
    private String name;
    private List<Attribute> attributes;

    public AbstractTag(ContentContainer parent) {
        this.parent = parent;
    }

    @Override
    public final ContentContainer getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final List<Attribute> getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public final void setAttribute(String name, String value) {
        Attribute a = new Attribute();
        a.setName(name);
        a.setValue(value);
        List<Attribute> atts = this.getAttributes();
        if (atts == null) {
            atts = new ArrayList<Attribute>();
            this.setAttributes(atts);
        }
        atts.add(a);
    }

    public final Attribute getAttribute(String name) {
        List<Attribute> atts = this.getAttributes();
        if (atts == null) {
            return null;
        }
        for (Attribute attribute : atts) {
            if (!name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }
}

