/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.util.HashSet;
import java.util.Set;
import org.bndly.common.html.ParserConfig;

public class DefaultParserConfig
implements ParserConfig {
    private static final Set<String> SELF_CLOSING_TAGS = new HashSet<String>();
    public static final String ALLOWED_ATTRIBUTE_NAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_";

    @Override
    public boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c);
    }

    @Override
    public boolean isSelfClosingTag(String tagName) {
        return SELF_CLOSING_TAGS.contains(tagName);
    }

    @Override
    public boolean isAllowedAttributeNameCharacter(char c) {
        return ALLOWED_ATTRIBUTE_NAME_CHARS.indexOf(c) >= 0;
    }

    @Override
    public boolean isAutomaticLowerCaseEnabled(String tagName) {
        return false;
    }

    @Override
    public boolean isCharacterWithRequiredHtmlEntity(char c) {
        return this.isCharacterWithRequiredHtmlEntityInAttribute(c);
    }

    @Override
    public boolean isCharacterWithRequiredHtmlEntityInAttribute(char c) {
        return '>' == c || '<' == c || '&' == c || '\"' == c || '\'' == c;
    }

    @Override
    public boolean isCharacterWithRequiredHtmlEntityInText(char c) {
        return '>' == c || '<' == c || '&' == c;
    }

    @Override
    public boolean isUnquotedAttributeValueTolerated() {
        return false;
    }

    @Override
    public boolean isUnbalancedTagTolerated() {
        return false;
    }

    @Override
    public boolean isIncompleteEntityTolerated() {
        return false;
    }

    @Override
    public boolean isCommentParsingEnabled() {
        return false;
    }

    static {
        SELF_CLOSING_TAGS.add("br");
        SELF_CLOSING_TAGS.add("img");
        SELF_CLOSING_TAGS.add("hr");
    }
}

