/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HTML5EntityMap {
    public static final HTML5EntityMap INSTANCE = new HTML5EntityMap();
    private final List<Entry> entries = new ArrayList<Entry>();
    private final Map<Character, Entry> entriesByChar = new LinkedHashMap<Character, Entry>();
    private final Map<String, Entry> entriesByEntity = new LinkedHashMap<String, Entry>();

    private HTML5EntityMap() {
    }

    public boolean hasEntity(char c) {
        return this.entriesByChar.containsKey(Character.valueOf(c));
    }

    public String getEntityName(char c) {
        Entry get = this.entriesByChar.get(Character.valueOf(c));
        if (get == null) {
            return null;
        }
        return get.getDefaultEntityName();
    }

    public String getEntity(char c) {
        Entry get = this.entriesByChar.get(Character.valueOf(c));
        if (get == null) {
            return null;
        }
        return get.entities[0];
    }

    /*
     * Opcode count of 34768 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void init() {
        this.entries.add(new Entry('\t', "&Tab;", "&#x00009;", "&#9;"));
        this.entries.add(new Entry('\n', "&NewLine;", "&#x0000A;", "&#10;"));
        this.entries.add(new Entry('!', "&excl;", "&#x00021;", "&#33;"));
        this.entries.add(new Entry('\"', "&quot; &QUOT;", "&#x00022;", "&#34;"));
        this.entries.add(new Entry('#', "&num;", "&#x00023;", "&#35;"));
        this.entries.add(new Entry('$', "&dollar;", "&#x00024;", "&#36;"));
        this.entries.add(new Entry('%', "&percnt;", "&#x00025;", "&#37;"));
        this.entries.add(new Entry('&', "&amp;", "&AMP;", "&#x00026;", "&#38;"));
        this.entries.add(new Entry('\'', "&apos;", "&#x00027;", "&#39;"));
        this.entries.add(new Entry('(', "&lpar;", "&#x00028;", "&#40;"));
        this.entries.add(new Entry(')', "&rpar;", "&#x00029;", "&#41;"));
        this.entries.add(new Entry('*', "&ast;", "&midast;", "&#x0002A;", "&#42;"));
        this.entries.add(new Entry('+', "&plus;", "&#x0002B;", "&#43;"));
        this.entries.add(new Entry(',', "&comma;", "&#x0002C;", "&#44;"));
        this.entries.add(new Entry('.', "&period;", "&#x0002E;", "&#46;"));
        this.entries.add(new Entry('/', "&sol;", "&#x0002F;", "&#47;"));
        this.entries.add(new Entry(':', "&colon;", "&#x0003A;", "&#58;"));
        this.entries.add(new Entry(';', "&semi;", "&#x0003B;", "&#59;"));
        this.entries.add(new Entry('<', "&lt;", "&LT;", "&#x0003C;", "&#60;"));
        this.entries.add(new Entry('=', "&equals;", "&#x0003D;", "&#61;"));
        this.entries.add(new Entry('>', "&gt;", "&GT;", "&#x0003E;", "&#62;"));
        this.entries.add(new Entry('?', "&quest;", "&#x0003F;", "&#63;"));
        this.entries.add(new Entry('@', "&commat;", "&#x00040;", "&#64;"));
        this.entries.add(new Entry('[', "&lsqb;", "&lbrack;", "&#x0005B;", "&#91;"));
        this.entries.add(new Entry('\\', "&bsol;", "&#x0005C;", "&#92;"));
        this.entries.add(new Entry(']', "&rsqb;", "&rbrack;", "&#x0005D;", "&#93;"));
        this.entries.add(new Entry('^', "&Hat;", "&#x0005E;", "&#94;"));
        this.entries.add(new Entry('_', "&lowbar;", "&#x0005F;", "&#95;"));
        this.entries.add(new Entry('`', "&grave;", "&DiacriticalGrave;", "&#x00060;", "&#96;"));
        this.entries.add(new Entry('{', "&lcub;", "&lbrace;", "&#x0007B;", "&#123;"));
        this.entries.add(new Entry('|', "&verbar;", "&vert;", "&VerticalLine;", "&#x0007C;", "&#124;"));
        this.entries.add(new Entry('}', "&rcub;", "&rbrace;", "&#x0007D;", "&#125;"));
        this.entries.add(new Entry(' ', "&nbsp;", "&NonBreakingSpace;", "&#x000A0;", "&#160;"));
        this.entries.add(new Entry('\u00a1', "&iexcl;", "&#x000A1;", "&#161;"));
        this.entries.add(new Entry('\u00a2', "&cent;", "&#x000A2;", "&#162;"));
        this.entries.add(new Entry('\u00a3', "&pound;", "&#x000A3;", "&#163;"));
        this.entries.add(new Entry('\u00a4', "&curren;", "&#x000A4;", "&#164;"));
        this.entries.add(new Entry('\u00a5', "&yen;", "&#x000A5;", "&#165;"));
        this.entries.add(new Entry('\u00a6', "&brvbar;", "&#x000A6;", "&#166;"));
        this.entries.add(new Entry('\u00a7', "&sect;", "&#x000A7;", "&#167;"));
        this.entries.add(new Entry('\u00a8', "&Dot;", "&die;", "&DoubleDot;", "&uml;", "&#x000A8;", "&#168;"));
        this.entries.add(new Entry('\u00a9', "&copy;", "&COPY;", "&#x000A9;", "&#169;"));
        this.entries.add(new Entry('\u00aa', "&ordf;", "&#x000AA;", "&#170;"));
        this.entries.add(new Entry('\u00ab', "&laquo;", "&#x000AB;", "&#171;"));
        this.entries.add(new Entry('\u00ac', "&not;", "&#x000AC;", "&#172;"));
        this.entries.add(new Entry('\u00ad', "&shy;", "&#x000AD;", "&#173;"));
        this.entries.add(new Entry('\u00ae', "&reg;", "&circledR;", "&REG;", "&#x000AE;", "&#174;"));
        this.entries.add(new Entry('\u00af', "&macr;", "&OverBar;", "&strns;", "&#x000AF;", "&#175;"));
        this.entries.add(new Entry('\u00b0', "&deg;", "&#x000B0;", "&#176;"));
        this.entries.add(new Entry('\u00b1', "&plusmn;", "&pm;", "&PlusMinus;", "&#x000B1;", "&#177;"));
        this.entries.add(new Entry('\u00b2', "&sup2;", "&#x000B2;", "&#178;"));
        this.entries.add(new Entry('\u00b3', "&sup3;", "&#x000B3;", "&#179;"));
        this.entries.add(new Entry('\u00b4', "&acute;", "&DiacriticalAcute;", "&#x000B4;", "&#180;"));
        this.entries.add(new Entry('\u00b5', "&micro;", "&#x000B5;", "&#181;"));
        this.entries.add(new Entry('\u00b6', "&para;", "&#x000B6;", "&#182;"));
        this.entries.add(new Entry('\u00b7', "&middot;", "&centerdot;", "&CenterDot;", "&#x000B7;", "&#183;"));
        this.entries.add(new Entry('\u00b8', "&cedil;", "&Cedilla;", "&#x000B8;", "&#184;"));
        this.entries.add(new Entry('\u00b9', "&sup1;", "&#x000B9;", "&#185;"));
        this.entries.add(new Entry('\u00ba', "&ordm;", "&#x000BA;", "&#186;"));
        this.entries.add(new Entry('\u00bb', "&raquo;", "&#x000BB;", "&#187;"));
        this.entries.add(new Entry('\u00bc', "&frac14;", "&#x000BC;", "&#188;"));
        this.entries.add(new Entry('\u00bd', "&frac12;", "&half;", "&#x000BD;", "&#189;"));
        this.entries.add(new Entry('\u00be', "&frac34;", "&#x000BE;", "&#190;"));
        this.entries.add(new Entry('\u00bf', "&iquest;", "&#x000BF;", "&#191;"));
        this.entries.add(new Entry('\u00c0', "&Agrave;", "&#x000C0;", "&#192;"));
        this.entries.add(new Entry('\u00c1', "&Aacute;", "&#x000C1;", "&#193;"));
        this.entries.add(new Entry('\u00c2', "&Acirc;", "&#x000C2;", "&#194;"));
        this.entries.add(new Entry('\u00c3', "&Atilde;", "&#x000C3;", "&#195;"));
        this.entries.add(new Entry('\u00c4', "&Auml;", "&#x000C4;", "&#196;"));
        this.entries.add(new Entry('\u00c5', "&Aring;", "&#x000C5;", "&#197;"));
        this.entries.add(new Entry('\u00c6', "&AElig;", "&#x000C6;", "&#198;"));
        this.entries.add(new Entry('\u00c7', "&Ccedil;", "&#x000C7;", "&#199;"));
        this.entries.add(new Entry('\u00c8', "&Egrave;", "&#x000C8;", "&#200;"));
        this.entries.add(new Entry('\u00c9', "&Eacute;", "&#x000C9;", "&#201;"));
        this.entries.add(new Entry('\u00ca', "&Ecirc;", "&#x000CA;", "&#202;"));
        this.entries.add(new Entry('\u00cb', "&Euml;", "&#x000CB;", "&#203;"));
        this.entries.add(new Entry('\u00cc', "&Igrave;", "&#x000CC;", "&#204;"));
        this.entries.add(new Entry('\u00cd', "&Iacute;", "&#x000CD;", "&#205;"));
        this.entries.add(new Entry('\u00ce', "&Icirc;", "&#x000CE;", "&#206;"));
        this.entries.add(new Entry('\u00cf', "&Iuml;", "&#x000CF;", "&#207;"));
        this.entries.add(new Entry('\u00d0', "&ETH;", "&#x000D0;", "&#208;"));
        this.entries.add(new Entry('\u00d1', "&Ntilde;", "&#x000D1;", "&#209;"));
        this.entries.add(new Entry('\u00d2', "&Ograve;", "&#x000D2;", "&#210;"));
        this.entries.add(new Entry('\u00d3', "&Oacute;", "&#x000D3;", "&#211;"));
        this.entries.add(new Entry('\u00d4', "&Ocirc;", "&#x000D4;", "&#212;"));
        this.entries.add(new Entry('\u00d5', "&Otilde;", "&#x000D5;", "&#213;"));
        this.entries.add(new Entry('\u00d6', "&Ouml;", "&#x000D6;", "&#214;"));
        this.entries.add(new Entry('\u00d7', "&times;", "&#x000D7;", "&#215;"));
        this.entries.add(new Entry('\u00d8', "&Oslash;", "&#x000D8;", "&#216;"));
        this.entries.add(new Entry('\u00d9', "&Ugrave;", "&#x000D9;", "&#217;"));
        this.entries.add(new Entry('\u00da', "&Uacute;", "&#x000DA;", "&#218;"));
        this.entries.add(new Entry('\u00db', "&Ucirc;", "&#x000DB;", "&#219;"));
        this.entries.add(new Entry('\u00dc', "&Uuml;", "&#x000DC;", "&#220;"));
        this.entries.add(new Entry('\u00dd', "&Yacute;", "&#x000DD;", "&#221;"));
        this.entries.add(new Entry('\u00de', "&THORN;", "&#x000DE;", "&#222;"));
        this.entries.add(new Entry('\u00df', "&szlig;", "&#x000DF;", "&#223;"));
        this.entries.add(new Entry('\u00e0', "&agrave;", "&#x000E0;", "&#224;"));
        this.entries.add(new Entry('\u00e1', "&aacute;", "&#x000E1;", "&#225;"));
        this.entries.add(new Entry('\u00e2', "&acirc;", "&#x000E2;", "&#226;"));
        this.entries.add(new Entry('\u00e3', "&atilde;", "&#x000E3;", "&#227;"));
        this.entries.add(new Entry('\u00e4', "&auml;", "&#x000E4;", "&#228;"));
        this.entries.add(new Entry('\u00e5', "&aring;", "&#x000E5;", "&#229;"));
        this.entries.add(new Entry('\u00e6', "&aelig;", "&#x000E6;", "&#230;"));
        this.entries.add(new Entry('\u00e7', "&ccedil;", "&#x000E7;", "&#231;"));
        this.entries.add(new Entry('\u00e8', "&egrave;", "&#x000E8;", "&#232;"));
        this.entries.add(new Entry('\u00e9', "&eacute;", "&#x000E9;", "&#233;"));
        this.entries.add(new Entry('\u00ea', "&ecirc;", "&#x000EA;", "&#234;"));
        this.entries.add(new Entry('\u00eb', "&euml;", "&#x000EB;", "&#235;"));
        this.entries.add(new Entry('\u00ec', "&igrave;", "&#x000EC;", "&#236;"));
        this.entries.add(new Entry('\u00ed', "&iacute;", "&#x000ED;", "&#237;"));
        this.entries.add(new Entry('\u00ee', "&icirc;", "&#x000EE;", "&#238;"));
        this.entries.add(new Entry('\u00ef', "&iuml;", "&#x000EF;", "&#239;"));
        this.entries.add(new Entry('\u00f0', "&eth;", "&#x000F0;", "&#240;"));
        this.entries.add(new Entry('\u00f1', "&ntilde;", "&#x000F1;", "&#241;"));
        this.entries.add(new Entry('\u00f2', "&ograve;", "&#x000F2;", "&#242;"));
        this.entries.add(new Entry('\u00f3', "&oacute;", "&#x000F3;", "&#243;"));
        this.entries.add(new Entry('\u00f4', "&ocirc;", "&#x000F4;", "&#244;"));
        this.entries.add(new Entry('\u00f5', "&otilde;", "&#x000F5;", "&#245;"));
        this.entries.add(new Entry('\u00f6', "&ouml;", "&#x000F6;", "&#246;"));
        this.entries.add(new Entry('\u00f7', "&divide;", "&div;", "&#x000F7;", "&#247;"));
        this.entries.add(new Entry('\u00f8', "&oslash;", "&#x000F8;", "&#248;"));
        this.entries.add(new Entry('\u00f9', "&ugrave;", "&#x000F9;", "&#249;"));
        this.entries.add(new Entry('\u00fa', "&uacute;", "&#x000FA;", "&#250;"));
        this.entries.add(new Entry('\u00fb', "&ucirc;", "&#x000FB;", "&#251;"));
        this.entries.add(new Entry('\u00fc', "&uuml;", "&#x000FC;", "&#252;"));
        this.entries.add(new Entry('\u00fd', "&yacute;", "&#x000FD;", "&#253;"));
        this.entries.add(new Entry('\u00fe', "&thorn;", "&#x000FE;", "&#254;"));
        this.entries.add(new Entry('\u00ff', "&yuml;", "&#x000FF;", "&#255;"));
        this.entries.add(new Entry('\u0100', "&Amacr;", "&#x00100;", "&#256;"));
        this.entries.add(new Entry('\u0101', "&amacr;", "&#x00101;", "&#257;"));
        this.entries.add(new Entry('\u0102', "&Abreve;", "&#x00102;", "&#258;"));
        this.entries.add(new Entry('\u0103', "&abreve;", "&#x00103;", "&#259;"));
        this.entries.add(new Entry('\u0104', "&Aogon;", "&#x00104;", "&#260;"));
        this.entries.add(new Entry('\u0105', "&aogon;", "&#x00105;", "&#261;"));
        this.entries.add(new Entry('\u0106', "&Cacute;", "&#x00106;", "&#262;"));
        this.entries.add(new Entry('\u0107', "&cacute;", "&#x00107;", "&#263;"));
        this.entries.add(new Entry('\u0108', "&Ccirc;", "&#x00108;", "&#264;"));
        this.entries.add(new Entry('\u0109', "&ccirc;", "&#x00109;", "&#265;"));
        this.entries.add(new Entry('\u010a', "&Cdot;", "&#x0010A;", "&#266;"));
        this.entries.add(new Entry('\u010b', "&cdot;", "&#x0010B;", "&#267;"));
        this.entries.add(new Entry('\u010c', "&Ccaron;", "&#x0010C;", "&#268;"));
        this.entries.add(new Entry('\u010d', "&ccaron;", "&#x0010D;", "&#269;"));
        this.entries.add(new Entry('\u010e', "&Dcaron;", "&#x0010E;", "&#270;"));
        this.entries.add(new Entry('\u010f', "&dcaron;", "&#x0010F;", "&#271;"));
        this.entries.add(new Entry('\u0110', "&Dstrok;", "&#x00110;", "&#272;"));
        this.entries.add(new Entry('\u0111', "&dstrok;", "&#x00111;", "&#273;"));
        this.entries.add(new Entry('\u0112', "&Emacr;", "&#x00112;", "&#274;"));
        this.entries.add(new Entry('\u0113', "&emacr;", "&#x00113;", "&#275;"));
        this.entries.add(new Entry('\u0116', "&Edot;", "&#x00116;", "&#278;"));
        this.entries.add(new Entry('\u0117', "&edot;", "&#x00117;", "&#279;"));
        this.entries.add(new Entry('\u0118', "&Eogon;", "&#x00118;", "&#280;"));
        this.entries.add(new Entry('\u0119', "&eogon;", "&#x00119;", "&#281;"));
        this.entries.add(new Entry('\u011a', "&Ecaron;", "&#x0011A;", "&#282;"));
        this.entries.add(new Entry('\u011b', "&ecaron;", "&#x0011B;", "&#283;"));
        this.entries.add(new Entry('\u011c', "&Gcirc;", "&#x0011C;", "&#284;"));
        this.entries.add(new Entry('\u011d', "&gcirc;", "&#x0011D;", "&#285;"));
        this.entries.add(new Entry('\u011e', "&Gbreve;", "&#x0011E;", "&#286;"));
        this.entries.add(new Entry('\u011f', "&gbreve;", "&#x0011F;", "&#287;"));
        this.entries.add(new Entry('\u0120', "&Gdot;", "&#x00120;", "&#288;"));
        this.entries.add(new Entry('\u0121', "&gdot;", "&#x00121;", "&#289;"));
        this.entries.add(new Entry('\u0122', "&Gcedil;", "&#x00122;", "&#290;"));
        this.entries.add(new Entry('\u0124', "&Hcirc;", "&#x00124;", "&#292;"));
        this.entries.add(new Entry('\u0125', "&hcirc;", "&#x00125;", "&#293;"));
        this.entries.add(new Entry('\u0126', "&Hstrok;", "&#x00126;", "&#294;"));
        this.entries.add(new Entry('\u0127', "&hstrok;", "&#x00127;", "&#295;"));
        this.entries.add(new Entry('\u0128', "&Itilde;", "&#x00128;", "&#296;"));
        this.entries.add(new Entry('\u0129', "&itilde;", "&#x00129;", "&#297;"));
        this.entries.add(new Entry('\u012a', "&Imacr;", "&#x0012A;", "&#298;"));
        this.entries.add(new Entry('\u012b', "&imacr;", "&#x0012B;", "&#299;"));
        this.entries.add(new Entry('\u012e', "&Iogon;", "&#x0012E;", "&#302;"));
        this.entries.add(new Entry('\u012f', "&iogon;", "&#x0012F;", "&#303;"));
        this.entries.add(new Entry('\u0130', "&Idot;", "&#x00130;", "&#304;"));
        this.entries.add(new Entry('\u0131', "&imath;", "&inodot;", "&#x00131;", "&#305;"));
        this.entries.add(new Entry('\u0132', "&IJlig;", "&#x00132;", "&#306;"));
        this.entries.add(new Entry('\u0133', "&ijlig;", "&#x00133;", "&#307;"));
        this.entries.add(new Entry('\u0134', "&Jcirc;", "&#x00134;", "&#308;"));
        this.entries.add(new Entry('\u0135', "&jcirc;", "&#x00135;", "&#309;"));
        this.entries.add(new Entry('\u0136', "&Kcedil;", "&#x00136;", "&#310;"));
        this.entries.add(new Entry('\u0137', "&kcedil;", "&#x00137;", "&#311;"));
        this.entries.add(new Entry('\u0138', "&kgreen;", "&#x00138;", "&#312;"));
        this.entries.add(new Entry('\u0139', "&Lacute;", "&#x00139;", "&#313;"));
        this.entries.add(new Entry('\u013a', "&lacute;", "&#x0013A;", "&#314;"));
        this.entries.add(new Entry('\u013b', "&Lcedil;", "&#x0013B;", "&#315;"));
        this.entries.add(new Entry('\u013c', "&lcedil;", "&#x0013C;", "&#316;"));
        this.entries.add(new Entry('\u013d', "&Lcaron;", "&#x0013D;", "&#317;"));
        this.entries.add(new Entry('\u013e', "&lcaron;", "&#x0013E;", "&#318;"));
        this.entries.add(new Entry('\u013f', "&Lmidot;", "&#x0013F;", "&#319;"));
        this.entries.add(new Entry('\u0140', "&lmidot;", "&#x00140;", "&#320;"));
        this.entries.add(new Entry('\u0141', "&Lstrok;", "&#x00141;", "&#321;"));
        this.entries.add(new Entry('\u0142', "&lstrok;", "&#x00142;", "&#322;"));
        this.entries.add(new Entry('\u0143', "&Nacute;", "&#x00143;", "&#323;"));
        this.entries.add(new Entry('\u0144', "&nacute;", "&#x00144;", "&#324;"));
        this.entries.add(new Entry('\u0145', "&Ncedil;", "&#x00145;", "&#325;"));
        this.entries.add(new Entry('\u0146', "&ncedil;", "&#x00146;", "&#326;"));
        this.entries.add(new Entry('\u0147', "&Ncaron;", "&#x00147;", "&#327;"));
        this.entries.add(new Entry('\u0148', "&ncaron;", "&#x00148;", "&#328;"));
        this.entries.add(new Entry('\u0149', "&napos;", "&#x00149;", "&#329;"));
        this.entries.add(new Entry('\u014a', "&ENG;", "&#x0014A;", "&#330;"));
        this.entries.add(new Entry('\u014b', "&eng;", "&#x0014B;", "&#331;"));
        this.entries.add(new Entry('\u014c', "&Omacr;", "&#x0014C;", "&#332;"));
        this.entries.add(new Entry('\u014d', "&omacr;", "&#x0014D;", "&#333;"));
        this.entries.add(new Entry('\u0150', "&Odblac;", "&#x00150;", "&#336;"));
        this.entries.add(new Entry('\u0151', "&odblac;", "&#x00151;", "&#337;"));
        this.entries.add(new Entry('\u0152', "&OElig;", "&#x00152;", "&#338;"));
        this.entries.add(new Entry('\u0153', "&oelig;", "&#x00153;", "&#339;"));
        this.entries.add(new Entry('\u0154', "&Racute;", "&#x00154;", "&#340;"));
        this.entries.add(new Entry('\u0155', "&racute;", "&#x00155;", "&#341;"));
        this.entries.add(new Entry('\u0156', "&Rcedil;", "&#x00156;", "&#342;"));
        this.entries.add(new Entry('\u0157', "&rcedil;", "&#x00157;", "&#343;"));
        this.entries.add(new Entry('\u0158', "&Rcaron;", "&#x00158;", "&#344;"));
        this.entries.add(new Entry('\u0159', "&rcaron;", "&#x00159;", "&#345;"));
        this.entries.add(new Entry('\u015a', "&Sacute;", "&#x0015A;", "&#346;"));
        this.entries.add(new Entry('\u015b', "&sacute;", "&#x0015B;", "&#347;"));
        this.entries.add(new Entry('\u015c', "&Scirc;", "&#x0015C;", "&#348;"));
        this.entries.add(new Entry('\u015d', "&scirc;", "&#x0015D;", "&#349;"));
        this.entries.add(new Entry('\u015e', "&Scedil;", "&#x0015E;", "&#350;"));
        this.entries.add(new Entry('\u015f', "&scedil;", "&#x0015F;", "&#351;"));
        this.entries.add(new Entry('\u0160', "&Scaron;", "&#x00160;", "&#352;"));
        this.entries.add(new Entry('\u0161', "&scaron;", "&#x00161;", "&#353;"));
        this.entries.add(new Entry('\u0162', "&Tcedil;", "&#x00162;", "&#354;"));
        this.entries.add(new Entry('\u0163', "&tcedil;", "&#x00163;", "&#355;"));
        this.entries.add(new Entry('\u0164', "&Tcaron;", "&#x00164;", "&#356;"));
        this.entries.add(new Entry('\u0165', "&tcaron;", "&#x00165;", "&#357;"));
        this.entries.add(new Entry('\u0166', "&Tstrok;", "&#x00166;", "&#358;"));
        this.entries.add(new Entry('\u0167', "&tstrok;", "&#x00167;", "&#359;"));
        this.entries.add(new Entry('\u0168', "&Utilde;", "&#x00168;", "&#360;"));
        this.entries.add(new Entry('\u0169', "&utilde;", "&#x00169;", "&#361;"));
        this.entries.add(new Entry('\u016a', "&Umacr;", "&#x0016A;", "&#362;"));
        this.entries.add(new Entry('\u016b', "&umacr;", "&#x0016B;", "&#363;"));
        this.entries.add(new Entry('\u016c', "&Ubreve;", "&#x0016C;", "&#364;"));
        this.entries.add(new Entry('\u016d', "&ubreve;", "&#x0016D;", "&#365;"));
        this.entries.add(new Entry('\u016e', "&Uring;", "&#x0016E;", "&#366;"));
        this.entries.add(new Entry('\u016f', "&uring;", "&#x0016F;", "&#367;"));
        this.entries.add(new Entry('\u0170', "&Udblac;", "&#x00170;", "&#368;"));
        this.entries.add(new Entry('\u0171', "&udblac;", "&#x00171;", "&#369;"));
        this.entries.add(new Entry('\u0172', "&Uogon;", "&#x00172;", "&#370;"));
        this.entries.add(new Entry('\u0173', "&uogon;", "&#x00173;", "&#371;"));
        this.entries.add(new Entry('\u0174', "&Wcirc;", "&#x00174;", "&#372;"));
        this.entries.add(new Entry('\u0175', "&wcirc;", "&#x00175;", "&#373;"));
        this.entries.add(new Entry('\u0176', "&Ycirc;", "&#x00176;", "&#374;"));
        this.entries.add(new Entry('\u0177', "&ycirc;", "&#x00177;", "&#375;"));
        this.entries.add(new Entry('\u0178', "&Yuml;", "&#x00178;", "&#376;"));
        this.entries.add(new Entry('\u0179', "&Zacute;", "&#x00179;", "&#377;"));
        this.entries.add(new Entry('\u017a', "&zacute;", "&#x0017A;", "&#378;"));
        this.entries.add(new Entry('\u017b', "&Zdot;", "&#x0017B;", "&#379;"));
        this.entries.add(new Entry('\u017c', "&zdot;", "&#x0017C;", "&#380;"));
        this.entries.add(new Entry('\u017d', "&Zcaron;", "&#x0017D;", "&#381;"));
        this.entries.add(new Entry('\u017e', "&zcaron;", "&#x0017E;", "&#382;"));
        this.entries.add(new Entry('\u0192', "&fnof;", "&#x00192;", "&#402;"));
        this.entries.add(new Entry('\u01b5', "&imped;", "&#x001B5;", "&#437;"));
        this.entries.add(new Entry('\u01f5', "&gacute;", "&#x001F5;", "&#501;"));
        this.entries.add(new Entry('\u0237', "&jmath;", "&#x00237;", "&#567;"));
        this.entries.add(new Entry('\u02c6', "&circ;", "&#x002C6;", "&#710;"));
        this.entries.add(new Entry('\u02c7', "&caron;", "&Hacek;", "&#x002C7;", "&#711;"));
        this.entries.add(new Entry('\u02d8', "&breve;", "&Breve;", "&#x002D8;", "&#728;"));
        this.entries.add(new Entry('\u02d9', "&dot;", "&DiacriticalDot;", "&#x002D9;", "&#729;"));
        this.entries.add(new Entry('\u02da', "&ring;", "&#x002DA;", "&#730;"));
        this.entries.add(new Entry('\u02db', "&ogon;", "&#x002DB;", "&#731;"));
        this.entries.add(new Entry('\u02dc', "&tilde;", "&DiacriticalTilde;", "&#x002DC;", "&#732;"));
        this.entries.add(new Entry('\u02dd', "&dblac;", "&DiacriticalDoubleAcute;", "&#x002DD;", "&#733;"));
        this.entries.add(new Entry('\u0311', "&DownBreve;", "&#x00311;", "&#785;"));
        this.entries.add(new Entry('\u0332', "&UnderBar;", "&#x00332;", "&#818;"));
        this.entries.add(new Entry('\u0391', "&Alpha;", "&#x00391;", "&#913;"));
        this.entries.add(new Entry('\u0392', "&Beta;", "&#x00392;", "&#914;"));
        this.entries.add(new Entry('\u0393', "&Gamma;", "&#x00393;", "&#915;"));
        this.entries.add(new Entry('\u0394', "&Delta;", "&#x00394;", "&#916;"));
        this.entries.add(new Entry('\u0395', "&Epsilon;", "&#x00395;", "&#917;"));
        this.entries.add(new Entry('\u0396', "&Zeta;", "&#x00396;", "&#918;"));
        this.entries.add(new Entry('\u0397', "&Eta;", "&#x00397;", "&#919;"));
        this.entries.add(new Entry('\u0398', "&Theta;", "&#x00398;", "&#920;"));
        this.entries.add(new Entry('\u0399', "&Iota;", "&#x00399;", "&#921;"));
        this.entries.add(new Entry('\u039a', "&Kappa;", "&#x0039A;", "&#922;"));
        this.entries.add(new Entry('\u039b', "&Lambda;", "&#x0039B;", "&#923;"));
        this.entries.add(new Entry('\u039c', "&Mu;", "&#x0039C;", "&#924;"));
        this.entries.add(new Entry('\u039d', "&Nu;", "&#x0039D;", "&#925;"));
        this.entries.add(new Entry('\u039e', "&Xi;", "&#x0039E;", "&#926;"));
        this.entries.add(new Entry('\u039f', "&Omicron;", "&#x0039F;", "&#927;"));
        this.entries.add(new Entry('\u03a0', "&Pi;", "&#x003A0;", "&#928;"));
        this.entries.add(new Entry('\u03a1', "&Rho;", "&#x003A1;", "&#929;"));
        this.entries.add(new Entry('\u03a3', "&Sigma;", "&#x003A3;", "&#931;"));
        this.entries.add(new Entry('\u03a4', "&Tau;", "&#x003A4;", "&#932;"));
        this.entries.add(new Entry('\u03a5', "&Upsilon;", "&#x003A5;", "&#933;"));
        this.entries.add(new Entry('\u03a6', "&Phi;", "&#x003A6;", "&#934;"));
        this.entries.add(new Entry('\u03a7', "&Chi;", "&#x003A7;", "&#935;"));
        this.entries.add(new Entry('\u03a8', "&Psi;", "&#x003A8;", "&#936;"));
        this.entries.add(new Entry('\u03a9', "&Omega;", "&#x003A9;", "&#937;"));
        this.entries.add(new Entry('\u03b1', "&alpha;", "&#x003B1;", "&#945;"));
        this.entries.add(new Entry('\u03b2', "&beta;", "&#x003B2;", "&#946;"));
        this.entries.add(new Entry('\u03b3', "&gamma;", "&#x003B3;", "&#947;"));
        this.entries.add(new Entry('\u03b4', "&delta;", "&#x003B4;", "&#948;"));
        this.entries.add(new Entry('\u03b5', "&epsiv;", "&varepsilon;", "&epsilon;", "&#x003B5;", "&#949;"));
        this.entries.add(new Entry('\u03b6', "&zeta;", "&#x003B6;", "&#950;"));
        this.entries.add(new Entry('\u03b7', "&eta;", "&#x003B7;", "&#951;"));
        this.entries.add(new Entry('\u03b8', "&theta;", "&#x003B8;", "&#952;"));
        this.entries.add(new Entry('\u03b9', "&iota;", "&#x003B9;", "&#953;"));
        this.entries.add(new Entry('\u03ba', "&kappa;", "&#x003BA;", "&#954;"));
        this.entries.add(new Entry('\u03bb', "&lambda;", "&#x003BB;", "&#955;"));
        this.entries.add(new Entry('\u03bc', "&mu;", "&#x003BC;", "&#956;"));
        this.entries.add(new Entry('\u03bd', "&nu;", "&#x003BD;", "&#957;"));
        this.entries.add(new Entry('\u03be', "&xi;", "&#x003BE;", "&#958;"));
        this.entries.add(new Entry('\u03bf', "&omicron;", "&#x003BF;", "&#959;"));
        this.entries.add(new Entry('\u03c0', "&pi;", "&#x003C0;", "&#960;"));
        this.entries.add(new Entry('\u03c1', "&rho;", "&#x003C1;", "&#961;"));
        this.entries.add(new Entry('\u03c2', "&sigmav;", "&varsigma;", "&sigmaf;", "&#x003C2;", "&#962;"));
        this.entries.add(new Entry('\u03c3', "&sigma;", "&#x003C3;", "&#963;"));
        this.entries.add(new Entry('\u03c4', "&tau;", "&#x003C4;", "&#964;"));
        this.entries.add(new Entry('\u03c5', "&upsi;", "&upsilon;", "&#x003C5;", "&#965;"));
        this.entries.add(new Entry('\u03c6', "&phi;", "&phiv;", "&varphi;", "&#x003C6;", "&#966;"));
        this.entries.add(new Entry('\u03c7', "&chi;", "&#x003C7;", "&#967;"));
        this.entries.add(new Entry('\u03c8', "&psi;", "&#x003C8;", "&#968;"));
        this.entries.add(new Entry('\u03c9', "&omega;", "&#x003C9;", "&#969;"));
        this.entries.add(new Entry('\u03d1', "&thetav;", "&vartheta;", "&thetasym;", "&#x003D1;", "&#977;"));
        this.entries.add(new Entry('\u03d2', "&Upsi;", "&upsih;", "&#x003D2;", "&#978;"));
        this.entries.add(new Entry('\u03d5', "&straightphi;", "&#x003D5;", "&#981;"));
        this.entries.add(new Entry('\u03d6', "&piv;", "&varpi;", "&#x003D6;", "&#982;"));
        this.entries.add(new Entry('\u03dc', "&Gammad;", "&#x003DC;", "&#988;"));
        this.entries.add(new Entry('\u03dd', "&gammad;", "&digamma;", "&#x003DD;", "&#989;"));
        this.entries.add(new Entry('\u03f0', "&kappav;", "&varkappa;", "&#x003F0;", "&#1008;"));
        this.entries.add(new Entry('\u03f1', "&rhov;", "&varrho;", "&#x003F1;", "&#1009;"));
        this.entries.add(new Entry('\u03f5', "&epsi;", "&straightepsilon;", "&#x003F5;", "&#1013;"));
        this.entries.add(new Entry('\u03f6', "&bepsi;", "&backepsilon;", "&#x003F6;", "&#1014;"));
        this.entries.add(new Entry('\u0401', "&IOcy;", "&#x00401;", "&#1025;"));
        this.entries.add(new Entry('\u0402', "&DJcy;", "&#x00402;", "&#1026;"));
        this.entries.add(new Entry('\u0403', "&GJcy;", "&#x00403;", "&#1027;"));
        this.entries.add(new Entry('\u0404', "&Jukcy;", "&#x00404;", "&#1028;"));
        this.entries.add(new Entry('\u0405', "&DScy;", "&#x00405;", "&#1029;"));
        this.entries.add(new Entry('\u0406', "&Iukcy;", "&#x00406;", "&#1030;"));
        this.entries.add(new Entry('\u0407', "&YIcy;", "&#x00407;", "&#1031;"));
        this.entries.add(new Entry('\u0408', "&Jsercy;", "&#x00408;", "&#1032;"));
        this.entries.add(new Entry('\u0409', "&LJcy;", "&#x00409;", "&#1033;"));
        this.entries.add(new Entry('\u040a', "&NJcy;", "&#x0040A;", "&#1034;"));
        this.entries.add(new Entry('\u040b', "&TSHcy;", "&#x0040B;", "&#1035;"));
        this.entries.add(new Entry('\u040c', "&KJcy;", "&#x0040C;", "&#1036;"));
        this.entries.add(new Entry('\u040e', "&Ubrcy;", "&#x0040E;", "&#1038;"));
        this.entries.add(new Entry('\u040f', "&DZcy;", "&#x0040F;", "&#1039;"));
        this.entries.add(new Entry('\u0410', "&Acy;", "&#x00410;", "&#1040;"));
        this.entries.add(new Entry('\u0411', "&Bcy;", "&#x00411;", "&#1041;"));
        this.entries.add(new Entry('\u0412', "&Vcy;", "&#x00412;", "&#1042;"));
        this.entries.add(new Entry('\u0413', "&Gcy;", "&#x00413;", "&#1043;"));
        this.entries.add(new Entry('\u0414', "&Dcy;", "&#x00414;", "&#1044;"));
        this.entries.add(new Entry('\u0415', "&IEcy;", "&#x00415;", "&#1045;"));
        this.entries.add(new Entry('\u0416', "&ZHcy;", "&#x00416;", "&#1046;"));
        this.entries.add(new Entry('\u0417', "&Zcy;", "&#x00417;", "&#1047;"));
        this.entries.add(new Entry('\u0418', "&Icy;", "&#x00418;", "&#1048;"));
        this.entries.add(new Entry('\u0419', "&Jcy;", "&#x00419;", "&#1049;"));
        this.entries.add(new Entry('\u041a', "&Kcy;", "&#x0041A;", "&#1050;"));
        this.entries.add(new Entry('\u041b', "&Lcy;", "&#x0041B;", "&#1051;"));
        this.entries.add(new Entry('\u041c', "&Mcy;", "&#x0041C;", "&#1052;"));
        this.entries.add(new Entry('\u041d', "&Ncy;", "&#x0041D;", "&#1053;"));
        this.entries.add(new Entry('\u041e', "&Ocy;", "&#x0041E;", "&#1054;"));
        this.entries.add(new Entry('\u041f', "&Pcy;", "&#x0041F;", "&#1055;"));
        this.entries.add(new Entry('\u0420', "&Rcy;", "&#x00420;", "&#1056;"));
        this.entries.add(new Entry('\u0421', "&Scy;", "&#x00421;", "&#1057;"));
        this.entries.add(new Entry('\u0422', "&Tcy;", "&#x00422;", "&#1058;"));
        this.entries.add(new Entry('\u0423', "&Ucy;", "&#x00423;", "&#1059;"));
        this.entries.add(new Entry('\u0424', "&Fcy;", "&#x00424;", "&#1060;"));
        this.entries.add(new Entry('\u0425', "&KHcy;", "&#x00425;", "&#1061;"));
        this.entries.add(new Entry('\u0426', "&TScy;", "&#x00426;", "&#1062;"));
        this.entries.add(new Entry('\u0427', "&CHcy;", "&#x00427;", "&#1063;"));
        this.entries.add(new Entry('\u0428', "&SHcy;", "&#x00428;", "&#1064;"));
        this.entries.add(new Entry('\u0429', "&SHCHcy;", "&#x00429;", "&#1065;"));
        this.entries.add(new Entry('\u042a', "&HARDcy;", "&#x0042A;", "&#1066;"));
        this.entries.add(new Entry('\u042b', "&Ycy;", "&#x0042B;", "&#1067;"));
        this.entries.add(new Entry('\u042c', "&SOFTcy;", "&#x0042C;", "&#1068;"));
        this.entries.add(new Entry('\u042d', "&Ecy;", "&#x0042D;", "&#1069;"));
        this.entries.add(new Entry('\u042e', "&YUcy;", "&#x0042E;", "&#1070;"));
        this.entries.add(new Entry('\u042f', "&YAcy;", "&#x0042F;", "&#1071;"));
        this.entries.add(new Entry('\u0430', "&acy;", "&#x00430;", "&#1072;"));
        this.entries.add(new Entry('\u0431', "&bcy;", "&#x00431;", "&#1073;"));
        this.entries.add(new Entry('\u0432', "&vcy;", "&#x00432;", "&#1074;"));
        this.entries.add(new Entry('\u0433', "&gcy;", "&#x00433;", "&#1075;"));
        this.entries.add(new Entry('\u0434', "&dcy;", "&#x00434;", "&#1076;"));
        this.entries.add(new Entry('\u0435', "&iecy;", "&#x00435;", "&#1077;"));
        this.entries.add(new Entry('\u0436', "&zhcy;", "&#x00436;", "&#1078;"));
        this.entries.add(new Entry('\u0437', "&zcy;", "&#x00437;", "&#1079;"));
        this.entries.add(new Entry('\u0438', "&icy;", "&#x00438;", "&#1080;"));
        this.entries.add(new Entry('\u0439', "&jcy;", "&#x00439;", "&#1081;"));
        this.entries.add(new Entry('\u043a', "&kcy;", "&#x0043A;", "&#1082;"));
        this.entries.add(new Entry('\u043b', "&lcy;", "&#x0043B;", "&#1083;"));
        this.entries.add(new Entry('\u043c', "&mcy;", "&#x0043C;", "&#1084;"));
        this.entries.add(new Entry('\u043d', "&ncy;", "&#x0043D;", "&#1085;"));
        this.entries.add(new Entry('\u043e', "&ocy;", "&#x0043E;", "&#1086;"));
        this.entries.add(new Entry('\u043f', "&pcy;", "&#x0043F;", "&#1087;"));
        this.entries.add(new Entry('\u0440', "&rcy;", "&#x00440;", "&#1088;"));
        this.entries.add(new Entry('\u0441', "&scy;", "&#x00441;", "&#1089;"));
        this.entries.add(new Entry('\u0442', "&tcy;", "&#x00442;", "&#1090;"));
        this.entries.add(new Entry('\u0443', "&ucy;", "&#x00443;", "&#1091;"));
        this.entries.add(new Entry('\u0444', "&fcy;", "&#x00444;", "&#1092;"));
        this.entries.add(new Entry('\u0445', "&khcy;", "&#x00445;", "&#1093;"));
        this.entries.add(new Entry('\u0446', "&tscy;", "&#x00446;", "&#1094;"));
        this.entries.add(new Entry('\u0447', "&chcy;", "&#x00447;", "&#1095;"));
        this.entries.add(new Entry('\u0448', "&shcy;", "&#x00448;", "&#1096;"));
        this.entries.add(new Entry('\u0449', "&shchcy;", "&#x00449;", "&#1097;"));
        this.entries.add(new Entry('\u044a', "&hardcy;", "&#x0044A;", "&#1098;"));
        this.entries.add(new Entry('\u044b', "&ycy;", "&#x0044B;", "&#1099;"));
        this.entries.add(new Entry('\u044c', "&softcy;", "&#x0044C;", "&#1100;"));
        this.entries.add(new Entry('\u044d', "&ecy;", "&#x0044D;", "&#1101;"));
        this.entries.add(new Entry('\u044e', "&yucy;", "&#x0044E;", "&#1102;"));
        this.entries.add(new Entry('\u044f', "&yacy;", "&#x0044F;", "&#1103;"));
        this.entries.add(new Entry('\u0451', "&iocy;", "&#x00451;", "&#1105;"));
        this.entries.add(new Entry('\u0452', "&djcy;", "&#x00452;", "&#1106;"));
        this.entries.add(new Entry('\u0453', "&gjcy;", "&#x00453;", "&#1107;"));
        this.entries.add(new Entry('\u0454', "&jukcy;", "&#x00454;", "&#1108;"));
        this.entries.add(new Entry('\u0455', "&dscy;", "&#x00455;", "&#1109;"));
        this.entries.add(new Entry('\u0456', "&iukcy;", "&#x00456;", "&#1110;"));
        this.entries.add(new Entry('\u0457', "&yicy;", "&#x00457;", "&#1111;"));
        this.entries.add(new Entry('\u0458', "&jsercy;", "&#x00458;", "&#1112;"));
        this.entries.add(new Entry('\u0459', "&ljcy;", "&#x00459;", "&#1113;"));
        this.entries.add(new Entry('\u045a', "&njcy;", "&#x0045A;", "&#1114;"));
        this.entries.add(new Entry('\u045b', "&tshcy;", "&#x0045B;", "&#1115;"));
        this.entries.add(new Entry('\u045c', "&kjcy;", "&#x0045C;", "&#1116;"));
        this.entries.add(new Entry('\u045e', "&ubrcy;", "&#x0045E;", "&#1118;"));
        this.entries.add(new Entry('\u045f', "&dzcy;", "&#x0045F;", "&#1119;"));
        this.entries.add(new Entry('\u2002', "&ensp;", "&#x02002;", "&#8194;"));
        this.entries.add(new Entry('\u2003', "&emsp;", "&#x02003;", "&#8195;"));
        this.entries.add(new Entry('\u2004', "&emsp13;", "&#x02004;", "&#8196;"));
        this.entries.add(new Entry('\u2005', "&emsp14;", "&#x02005;", "&#8197;"));
        this.entries.add(new Entry('\u2007', "&numsp;", "&#x02007;", "&#8199;"));
        this.entries.add(new Entry('\u2008', "&puncsp;", "&#x02008;", "&#8200;"));
        this.entries.add(new Entry('\u2009', "&thinsp;", "&ThinSpace;", "&#x02009;", "&#8201;"));
        this.entries.add(new Entry('\u200a', "&hairsp;", "&VeryThinSpace;", "&#x0200A;", "&#8202;"));
        this.entries.add(new Entry('\u200b', "&ZeroWidthSpace;", "&NegativeVeryThinSpace;", "&NegativeThinSpace;", "&NegativeMediumSpace;", "&NegativeThickSpace;", "&#x0200B;", "&#8203;"));
        this.entries.add(new Entry('\u200c', "&zwnj;", "&#x0200C;", "&#8204;"));
        this.entries.add(new Entry('\u200d', "&zwj;", "&#x0200D;", "&#8205;"));
        this.entries.add(new Entry('\u200e', "&lrm;", "&#x0200E;", "&#8206;"));
        this.entries.add(new Entry('\u200f', "&rlm;", "&#x0200F;", "&#8207;"));
        this.entries.add(new Entry('\u2010', "&hyphen;", "&dash;", "&#x02010;", "&#8208;"));
        this.entries.add(new Entry('\u2013', "&ndash;", "&#x02013;", "&#8211;"));
        this.entries.add(new Entry('\u2014', "&mdash;", "&#x02014;", "&#8212;"));
        this.entries.add(new Entry('\u2015', "&horbar;", "&#x02015;", "&#8213;"));
        this.entries.add(new Entry('\u2016', "&Verbar;", "&Vert;", "&#x02016;", "&#8214;"));
        this.entries.add(new Entry('\u2018', "&lsquo;", "&OpenCurlyQuote;", "&#x02018;", "&#8216;"));
        this.entries.add(new Entry('\u2019', "&rsquo;", "&rsquor;", "&CloseCurlyQuote;", "&#x02019;", "&#8217;"));
        this.entries.add(new Entry('\u201a', "&lsquor;", "&sbquo;", "&#x0201A;", "&#8218;"));
        this.entries.add(new Entry('\u201c', "&ldquo;", "&OpenCurlyDoubleQuote;", "&#x0201C;", "&#8220;"));
        this.entries.add(new Entry('\u201d', "&rdquo;", "&rdquor;", "&CloseCurlyDoubleQuote;", "&#x0201D;", "&#8221;"));
        this.entries.add(new Entry('\u201e', "&ldquor;", "&bdquo;", "&#x0201E;", "&#8222;"));
        this.entries.add(new Entry('\u2020', "&dagger;", "&#x02020;", "&#8224;"));
        this.entries.add(new Entry('\u2021', "&Dagger;", "&ddagger;", "&#x02021;", "&#8225;"));
        this.entries.add(new Entry('\u2022', "&bull;", "&bullet;", "&#x02022;", "&#8226;"));
        this.entries.add(new Entry('\u2025', "&nldr;", "&#x02025;", "&#8229;"));
        this.entries.add(new Entry('\u2026', "&hellip;", "&mldr;", "&#x02026;", "&#8230;"));
        this.entries.add(new Entry('\u2030', "&permil;", "&#x02030;", "&#8240;"));
        this.entries.add(new Entry('\u2031', "&pertenk;", "&#x02031;", "&#8241;"));
        this.entries.add(new Entry('\u2032', "&prime;", "&#x02032;", "&#8242;"));
        this.entries.add(new Entry('\u2033', "&Prime;", "&#x02033;", "&#8243;"));
        this.entries.add(new Entry('\u2034', "&tprime;", "&#x02034;", "&#8244;"));
        this.entries.add(new Entry('\u2035', "&bprime;", "&backprime;", "&#x02035;", "&#8245;"));
        this.entries.add(new Entry('\u2039', "&lsaquo;", "&#x02039;", "&#8249;"));
        this.entries.add(new Entry('\u203a', "&rsaquo;", "&#x0203A;", "&#8250;"));
        this.entries.add(new Entry('\u203e', "&oline;", "&#x0203E;", "&#8254;"));
        this.entries.add(new Entry('\u2041', "&caret;", "&#x02041;", "&#8257;"));
        this.entries.add(new Entry('\u2043', "&hybull;", "&#x02043;", "&#8259;"));
        this.entries.add(new Entry('\u2044', "&frasl;", "&#x02044;", "&#8260;"));
        this.entries.add(new Entry('\u204f', "&bsemi;", "&#x0204F;", "&#8271;"));
        this.entries.add(new Entry('\u2057', "&qprime;", "&#x02057;", "&#8279;"));
        this.entries.add(new Entry('\u205f', "&MediumSpace;", "&#x0205F;", "&#8287;"));
        this.entries.add(new Entry('\u2060', "&NoBreak;", "&#x02060;", "&#8288;"));
        this.entries.add(new Entry('\u2061', "&ApplyFunction;", "&af;", "&#x02061;", "&#8289;"));
        this.entries.add(new Entry('\u2062', "&InvisibleTimes;", "&it;", "&#x02062;", "&#8290;"));
        this.entries.add(new Entry('\u2063', "&InvisibleComma;", "&ic;", "&#x02063;", "&#8291;"));
        this.entries.add(new Entry('\u20ac', "&euro;", "&#x020AC;", "&#8364;"));
        this.entries.add(new Entry('\u20db', "&tdot;", "&TripleDot;", "&#x020DB;", "&#8411;"));
        this.entries.add(new Entry('\u20dc', "&DotDot;", "&#x020DC;", "&#8412;"));
        this.entries.add(new Entry('\u2102', "&Copf;", "&complexes;", "&#x02102;", "&#8450;"));
        this.entries.add(new Entry('\u2105', "&incare;", "&#x02105;", "&#8453;"));
        this.entries.add(new Entry('\u210a', "&gscr;", "&#x0210A;", "&#8458;"));
        this.entries.add(new Entry('\u210b', "&hamilt;", "&HilbertSpace;", "&Hscr;", "&#x0210B;", "&#8459;"));
        this.entries.add(new Entry('\u210c', "&Hfr;", "&Poincareplane;", "&#x0210C;", "&#8460;"));
        this.entries.add(new Entry('\u210d', "&quaternions;", "&Hopf;", "&#x0210D;", "&#8461;"));
        this.entries.add(new Entry('\u210e', "&planckh;", "&#x0210E;", "&#8462;"));
        this.entries.add(new Entry('\u210f', "&planck;", "&hbar;", "&plankv;", "&hslash;", "&#x0210F;", "&#8463;"));
        this.entries.add(new Entry('\u2110', "&Iscr;", "&imagline;", "&#x02110;", "&#8464;"));
        this.entries.add(new Entry('\u2111', "&image;", "&Im;", "&imagpart;", "&Ifr;", "&#x02111;", "&#8465;"));
        this.entries.add(new Entry('\u2112', "&Lscr;", "&lagran;", "&Laplacetrf;", "&#x02112;", "&#8466;"));
        this.entries.add(new Entry('\u2113', "&ell;", "&#x02113;", "&#8467;"));
        this.entries.add(new Entry('\u2115', "&Nopf;", "&naturals;", "&#x02115;", "&#8469;"));
        this.entries.add(new Entry('\u2116', "&numero;", "&#x02116;", "&#8470;"));
        this.entries.add(new Entry('\u2117', "&copysr;", "&#x02117;", "&#8471;"));
        this.entries.add(new Entry('\u2118', "&weierp;", "&wp;", "&#x02118;", "&#8472;"));
        this.entries.add(new Entry('\u2119', "&Popf;", "&primes;", "&#x02119;", "&#8473;"));
        this.entries.add(new Entry('\u211a', "&rationals;", "&Qopf;", "&#x0211A;", "&#8474;"));
        this.entries.add(new Entry('\u211b', "&Rscr;", "&realine;", "&#x0211B;", "&#8475;"));
        this.entries.add(new Entry('\u211c', "&real;", "&Re;", "&realpart;", "&Rfr;", "&#x0211C;", "&#8476;"));
        this.entries.add(new Entry('\u211d', "&reals;", "&Ropf;", "&#x0211D;", "&#8477;"));
        this.entries.add(new Entry('\u211e', "&rx;", "&#x0211E;", "&#8478;"));
        this.entries.add(new Entry('\u2122', "&trade;", "&TRADE;", "&#x02122;", "&#8482;"));
        this.entries.add(new Entry('\u2124', "&integers;", "&Zopf;", "&#x02124;", "&#8484;"));
        this.entries.add(new Entry('\u03a9', "&ohm;", "&#x02126;", "&#8486;"));
        this.entries.add(new Entry('\u2127', "&mho;", "&#x02127;", "&#8487;"));
        this.entries.add(new Entry('\u2128', "&Zfr;", "&zeetrf;", "&#x02128;", "&#8488;"));
        this.entries.add(new Entry('\u2129', "&iiota;", "&#x02129;", "&#8489;"));
        this.entries.add(new Entry('\u00c5', "&angst;", "&#x0212B;", "&#8491;"));
        this.entries.add(new Entry('\u212c', "&bernou;", "&Bernoullis;", "&Bscr;", "&#x0212C;", "&#8492;"));
        this.entries.add(new Entry('\u212d', "&Cfr;", "&Cayleys;", "&#x0212D;", "&#8493;"));
        this.entries.add(new Entry('\u212f', "&escr;", "&#x0212F;", "&#8495;"));
        this.entries.add(new Entry('\u2130', "&Escr;", "&expectation;", "&#x02130;", "&#8496;"));
        this.entries.add(new Entry('\u2131', "&Fscr;", "&Fouriertrf;", "&#x02131;", "&#8497;"));
        this.entries.add(new Entry('\u2133', "&phmmat;", "&Mellintrf;", "&Mscr;", "&#x02133;", "&#8499;"));
        this.entries.add(new Entry('\u2134', "&order;", "&orderof;", "&oscr;", "&#x02134;", "&#8500;"));
        this.entries.add(new Entry('\u2135', "&alefsym;", "&aleph;", "&#x02135;", "&#8501;"));
        this.entries.add(new Entry('\u2136', "&beth;", "&#x02136;", "&#8502;"));
        this.entries.add(new Entry('\u2137', "&gimel;", "&#x02137;", "&#8503;"));
        this.entries.add(new Entry('\u2138', "&daleth;", "&#x02138;", "&#8504;"));
        this.entries.add(new Entry('\u2145', "&CapitalDifferentialD;", "&DD;", "&#x02145;", "&#8517;"));
        this.entries.add(new Entry('\u2146', "&DifferentialD;", "&dd;", "&#x02146;", "&#8518;"));
        this.entries.add(new Entry('\u2147', "&ExponentialE;", "&exponentiale;", "&ee;", "&#x02147;", "&#8519;"));
        this.entries.add(new Entry('\u2148', "&ImaginaryI;", "&ii;", "&#x02148;", "&#8520;"));
        this.entries.add(new Entry('\u2153', "&frac13;", "&#x02153;", "&#8531;"));
        this.entries.add(new Entry('\u2154', "&frac23;", "&#x02154;", "&#8532;"));
        this.entries.add(new Entry('\u2155', "&frac15;", "&#x02155;", "&#8533;"));
        this.entries.add(new Entry('\u2156', "&frac25;", "&#x02156;", "&#8534;"));
        this.entries.add(new Entry('\u2157', "&frac35;", "&#x02157;", "&#8535;"));
        this.entries.add(new Entry('\u2158', "&frac45;", "&#x02158;", "&#8536;"));
        this.entries.add(new Entry('\u2159', "&frac16;", "&#x02159;", "&#8537;"));
        this.entries.add(new Entry('\u215a', "&frac56;", "&#x0215A;", "&#8538;"));
        this.entries.add(new Entry('\u215b', "&frac18;", "&#x0215B;", "&#8539;"));
        this.entries.add(new Entry('\u215c', "&frac38;", "&#x0215C;", "&#8540;"));
        this.entries.add(new Entry('\u215d', "&frac58;", "&#x0215D;", "&#8541;"));
        this.entries.add(new Entry('\u215e', "&frac78;", "&#x0215E;", "&#8542;"));
        this.entries.add(new Entry('\u2190', "&larr;", "&leftarrow;", "&LeftArrow;", "&slarr;", "&ShortLeftArrow;", "&#x02190;", "&#8592;"));
        this.entries.add(new Entry('\u2191', "&uarr;", "&uparrow;", "&UpArrow;", "&ShortUpArrow;", "&#x02191;", "&#8593;"));
        this.entries.add(new Entry('\u2192', "&rarr;", "&rightarrow;", "&RightArrow;", "&srarr;", "&ShortRightArrow;", "&#x02192;", "&#8594;"));
        this.entries.add(new Entry('\u2193', "&darr;", "&downarrow;", "&DownArrow;", "&ShortDownArrow;", "&#x02193;", "&#8595;"));
        this.entries.add(new Entry('\u2194', "&harr;", "&leftrightarrow;", "&LeftRightArrow;", "&#x02194;", "&#8596;"));
        this.entries.add(new Entry('\u2195', "&varr;", "&updownarrow;", "&UpDownArrow;", "&#x02195;", "&#8597;"));
        this.entries.add(new Entry('\u2196', "&nwarr;", "&UpperLeftArrow;", "&nwarrow;", "&#x02196;", "&#8598;"));
        this.entries.add(new Entry('\u2197', "&nearr;", "&UpperRightArrow;", "&nearrow;", "&#x02197;", "&#8599;"));
        this.entries.add(new Entry('\u2198', "&searr;", "&searrow;", "&LowerRightArrow;", "&#x02198;", "&#8600;"));
        this.entries.add(new Entry('\u2199', "&swarr;", "&swarrow;", "&LowerLeftArrow;", "&#x02199;", "&#8601;"));
        this.entries.add(new Entry('\u219a', "&nlarr;", "&nleftarrow;", "&#x0219A;", "&#8602;"));
        this.entries.add(new Entry('\u219b', "&nrarr;", "&nrightarrow;", "&#x0219B;", "&#8603;"));
        this.entries.add(new Entry('\u219d', "&rarrw;", "&rightsquigarrow;", "&#x0219D;", "&#8605;"));
        this.entries.add(new Entry('\u219e', "&Larr;", "&twoheadleftarrow;", "&#x0219E;", "&#8606;"));
        this.entries.add(new Entry('\u219f', "&Uarr;", "&#x0219F;", "&#8607;"));
        this.entries.add(new Entry('\u21a0', "&Rarr;", "&twoheadrightarrow;", "&#x021A0;", "&#8608;"));
        this.entries.add(new Entry('\u21a1', "&Darr;", "&#x021A1;", "&#8609;"));
        this.entries.add(new Entry('\u21a2', "&larrtl;", "&leftarrowtail;", "&#x021A2;", "&#8610;"));
        this.entries.add(new Entry('\u21a3', "&rarrtl;", "&rightarrowtail;", "&#x021A3;", "&#8611;"));
        this.entries.add(new Entry('\u21a4', "&LeftTeeArrow;", "&mapstoleft;", "&#x021A4;", "&#8612;"));
        this.entries.add(new Entry('\u21a5', "&UpTeeArrow;", "&mapstoup;", "&#x021A5;", "&#8613;"));
        this.entries.add(new Entry('\u21a6', "&map;", "&RightTeeArrow;", "&mapsto;", "&#x021A6;", "&#8614;"));
        this.entries.add(new Entry('\u21a7', "&DownTeeArrow;", "&mapstodown;", "&#x021A7;", "&#8615;"));
        this.entries.add(new Entry('\u21a9', "&larrhk;", "&hookleftarrow;", "&#x021A9;", "&#8617;"));
        this.entries.add(new Entry('\u21aa', "&rarrhk;", "&hookrightarrow;", "&#x021AA;", "&#8618;"));
        this.entries.add(new Entry('\u21ab', "&larrlp;", "&looparrowleft;", "&#x021AB;", "&#8619;"));
        this.entries.add(new Entry('\u21ac', "&rarrlp;", "&looparrowright;", "&#x021AC;", "&#8620;"));
        this.entries.add(new Entry('\u21ad', "&harrw;", "&leftrightsquigarrow;", "&#x021AD;", "&#8621;"));
        this.entries.add(new Entry('\u21ae', "&nharr;", "&nleftrightarrow;", "&#x021AE;", "&#8622;"));
        this.entries.add(new Entry('\u21b0', "&lsh;", "&Lsh;", "&#x021B0;", "&#8624;"));
        this.entries.add(new Entry('\u21b1', "&rsh;", "&Rsh;", "&#x021B1;", "&#8625;"));
        this.entries.add(new Entry('\u21b2', "&ldsh;", "&#x021B2;", "&#8626;"));
        this.entries.add(new Entry('\u21b3', "&rdsh;", "&#x021B3;", "&#8627;"));
        this.entries.add(new Entry('\u21b5', "&crarr;", "&#x021B5;", "&#8629;"));
        this.entries.add(new Entry('\u21b6', "&cularr;", "&curvearrowleft;", "&#x021B6;", "&#8630;"));
        this.entries.add(new Entry('\u21b7', "&curarr;", "&curvearrowright;", "&#x021B7;", "&#8631;"));
        this.entries.add(new Entry('\u21ba', "&olarr;", "&circlearrowleft;", "&#x021BA;", "&#8634;"));
        this.entries.add(new Entry('\u21bb', "&orarr;", "&circlearrowright;", "&#x021BB;", "&#8635;"));
        this.entries.add(new Entry('\u21bc', "&lharu;", "&LeftVector;", "&leftharpoonup;", "&#x021BC;", "&#8636;"));
        this.entries.add(new Entry('\u21bd', "&lhard;", "&leftharpoondown;", "&DownLeftVector;", "&#x021BD;", "&#8637;"));
        this.entries.add(new Entry('\u21be', "&uharr;", "&upharpoonright;", "&RightUpVector;", "&#x021BE;", "&#8638;"));
        this.entries.add(new Entry('\u21bf', "&uharl;", "&upharpoonleft;", "&LeftUpVector;", "&#x021BF;", "&#8639;"));
        this.entries.add(new Entry('\u21c0', "&rharu;", "&RightVector;", "&rightharpoonup;", "&#x021C0;", "&#8640;"));
        this.entries.add(new Entry('\u21c1', "&rhard;", "&rightharpoondown;", "&DownRightVector;", "&#x021C1;", "&#8641;"));
        this.entries.add(new Entry('\u21c2', "&dharr;", "&RightDownVector;", "&downharpoonright;", "&#x021C2;", "&#8642;"));
        this.entries.add(new Entry('\u21c3', "&dharl;", "&LeftDownVector;", "&downharpoonleft;", "&#x021C3;", "&#8643;"));
        this.entries.add(new Entry('\u21c4', "&rlarr;", "&rightleftarrows;", "&RightArrowLeftArrow;", "&#x021C4;", "&#8644;"));
        this.entries.add(new Entry('\u21c5', "&udarr;", "&UpArrowDownArrow;", "&#x021C5;", "&#8645;"));
        this.entries.add(new Entry('\u21c6', "&lrarr;", "&leftrightarrows;", "&LeftArrowRightArrow;", "&#x021C6;", "&#8646;"));
        this.entries.add(new Entry('\u21c7', "&llarr;", "&leftleftarrows;", "&#x021C7;", "&#8647;"));
        this.entries.add(new Entry('\u21c8', "&uuarr;", "&upuparrows;", "&#x021C8;", "&#8648;"));
        this.entries.add(new Entry('\u21c9', "&rrarr;", "&rightrightarrows;", "&#x021C9;", "&#8649;"));
        this.entries.add(new Entry('\u21ca', "&ddarr;", "&downdownarrows;", "&#x021CA;", "&#8650;"));
        this.entries.add(new Entry('\u21cb', "&lrhar;", "&ReverseEquilibrium;", "&leftrightharpoons;", "&#x021CB;", "&#8651;"));
        this.entries.add(new Entry('\u21cc', "&rlhar;", "&rightleftharpoons;", "&Equilibrium;", "&#x021CC;", "&#8652;"));
        this.entries.add(new Entry('\u21cd', "&nlArr;", "&nLeftarrow;", "&#x021CD;", "&#8653;"));
        this.entries.add(new Entry('\u21ce', "&nhArr;", "&nLeftrightarrow;", "&#x021CE;", "&#8654;"));
        this.entries.add(new Entry('\u21cf', "&nrArr;", "&nRightarrow;", "&#x021CF;", "&#8655;"));
        this.entries.add(new Entry('\u21d0', "&lArr;", "&Leftarrow;", "&DoubleLeftArrow;", "&#x021D0;", "&#8656;"));
        this.entries.add(new Entry('\u21d1', "&uArr;", "&Uparrow;", "&DoubleUpArrow;", "&#x021D1;", "&#8657;"));
        this.entries.add(new Entry('\u21d2', "&rArr;", "&Rightarrow;", "&Implies;", "&DoubleRightArrow;", "&#x021D2;", "&#8658;"));
        this.entries.add(new Entry('\u21d3', "&dArr;", "&Downarrow;", "&DoubleDownArrow;", "&#x021D3;", "&#8659;"));
        this.entries.add(new Entry('\u21d4', "&hArr;", "&Leftrightarrow;", "&DoubleLeftRightArrow;", "&iff;", "&#x021D4;", "&#8660;"));
        this.entries.add(new Entry('\u21d5', "&vArr;", "&Updownarrow;", "&DoubleUpDownArrow;", "&#x021D5;", "&#8661;"));
        this.entries.add(new Entry('\u21d6', "&nwArr;", "&#x021D6;", "&#8662;"));
        this.entries.add(new Entry('\u21d7', "&neArr;", "&#x021D7;", "&#8663;"));
        this.entries.add(new Entry('\u21d8', "&seArr;", "&#x021D8;", "&#8664;"));
        this.entries.add(new Entry('\u21d9', "&swArr;", "&#x021D9;", "&#8665;"));
        this.entries.add(new Entry('\u21da', "&lAarr;", "&Lleftarrow;", "&#x021DA;", "&#8666;"));
        this.entries.add(new Entry('\u21db', "&rAarr;", "&Rrightarrow;", "&#x021DB;", "&#8667;"));
        this.entries.add(new Entry('\u21dd', "&zigrarr;", "&#x021DD;", "&#8669;"));
        this.entries.add(new Entry('\u21e4', "&larrb;", "&LeftArrowBar;", "&#x021E4;", "&#8676;"));
        this.entries.add(new Entry('\u21e5', "&rarrb;", "&RightArrowBar;", "&#x021E5;", "&#8677;"));
        this.entries.add(new Entry('\u21f5', "&duarr;", "&DownArrowUpArrow;", "&#x021F5;", "&#8693;"));
        this.entries.add(new Entry('\u21fd', "&loarr;", "&#x021FD;", "&#8701;"));
        this.entries.add(new Entry('\u21fe', "&roarr;", "&#x021FE;", "&#8702;"));
        this.entries.add(new Entry('\u21ff', "&hoarr;", "&#x021FF;", "&#8703;"));
        this.entries.add(new Entry('\u2200', "&forall;", "&ForAll;", "&#x02200;", "&#8704;"));
        this.entries.add(new Entry('\u2201', "&comp;", "&complement;", "&#x02201;", "&#8705;"));
        this.entries.add(new Entry('\u2202', "&part;", "&PartialD;", "&#x02202;", "&#8706;"));
        this.entries.add(new Entry('\u2203', "&exist;", "&Exists;", "&#x02203;", "&#8707;"));
        this.entries.add(new Entry('\u2204', "&nexist;", "&NotExists;", "&nexists;", "&#x02204;", "&#8708;"));
        this.entries.add(new Entry('\u2205', "&empty;", "&emptyset;", "&emptyv;", "&varnothing;", "&#x02205;", "&#8709;"));
        this.entries.add(new Entry('\u2207', "&nabla;", "&Del;", "&#x02207;", "&#8711;"));
        this.entries.add(new Entry('\u2208', "&isin;", "&isinv;", "&Element;", "&in;", "&#x02208;", "&#8712;"));
        this.entries.add(new Entry('\u2209', "&notin;", "&NotElement;", "&notinva;", "&#x02209;", "&#8713;"));
        this.entries.add(new Entry('\u220b', "&niv;", "&ReverseElement;", "&ni;", "&SuchThat;", "&#x0220B;", "&#8715;"));
        this.entries.add(new Entry('\u220c', "&notni;", "&notniva;", "&NotReverseElement;", "&#x0220C;", "&#8716;"));
        this.entries.add(new Entry('\u220f', "&prod;", "&Product;", "&#x0220F;", "&#8719;"));
        this.entries.add(new Entry('\u2210', "&coprod;", "&Coproduct;", "&#x02210;", "&#8720;"));
        this.entries.add(new Entry('\u2211', "&sum;", "&Sum;", "&#x02211;", "&#8721;"));
        this.entries.add(new Entry('\u2212', "&minus;", "&#x02212;", "&#8722;"));
        this.entries.add(new Entry('\u2213', "&mnplus;", "&mp;", "&MinusPlus;", "&#x02213;", "&#8723;"));
        this.entries.add(new Entry('\u2214', "&plusdo;", "&dotplus;", "&#x02214;", "&#8724;"));
        this.entries.add(new Entry('\u2216', "&setmn;", "&setminus;", "&Backslash;", "&ssetmn;", "&smallsetminus;", "&#x02216;", "&#8726;"));
        this.entries.add(new Entry('\u2217', "&lowast;", "&#x02217;", "&#8727;"));
        this.entries.add(new Entry('\u2218', "&compfn;", "&SmallCircle;", "&#x02218;", "&#8728;"));
        this.entries.add(new Entry('\u221a', "&radic;", "&Sqrt;", "&#x0221A;", "&#8730;"));
        this.entries.add(new Entry('\u221d', "&prop;", "&propto;", "&Proportional;", "&vprop;", "&varpropto;", "&#x0221D;", "&#8733;"));
        this.entries.add(new Entry('\u221e', "&infin;", "&#x0221E;", "&#8734;"));
        this.entries.add(new Entry('\u221f', "&angrt;", "&#x0221F;", "&#8735;"));
        this.entries.add(new Entry('\u2220', "&ang;", "&angle;", "&#x02220;", "&#8736;"));
        this.entries.add(new Entry('\u2221', "&angmsd;", "&measuredangle;", "&#x02221;", "&#8737;"));
        this.entries.add(new Entry('\u2222', "&angsph;", "&#x02222;", "&#8738;"));
        this.entries.add(new Entry('\u2223', "&mid;", "&VerticalBar;", "&smid;", "&shortmid;", "&#x02223;", "&#8739;"));
        this.entries.add(new Entry('\u2224', "&nmid;", "&NotVerticalBar;", "&nsmid;", "&nshortmid;", "&#x02224;", "&#8740;"));
        this.entries.add(new Entry('\u2225', "&par;", "&parallel;", "&DoubleVerticalBar;", "&spar;", "&shortparallel;", "&#x02225;", "&#8741;"));
        this.entries.add(new Entry('\u2226', "&npar;", "&nparallel;", "&NotDoubleVerticalBar;", "&nspar;", "&nshortparallel;", "&#x02226;", "&#8742;"));
        this.entries.add(new Entry('\u2227', "&and;", "&wedge;", "&#x02227;", "&#8743;"));
        this.entries.add(new Entry('\u2228', "&or;", "&vee;", "&#x02228;", "&#8744;"));
        this.entries.add(new Entry('\u2229', "&cap;", "&#x02229;", "&#8745;"));
        this.entries.add(new Entry('\u222a', "&cup;", "&#x0222A;", "&#8746;"));
        this.entries.add(new Entry('\u222b', "&int;", "&Integral;", "&#x0222B;", "&#8747;"));
        this.entries.add(new Entry('\u222c', "&Int;", "&#x0222C;", "&#8748;"));
        this.entries.add(new Entry('\u222d', "&tint;", "&iiint;", "&#x0222D;", "&#8749;"));
        this.entries.add(new Entry('\u222e', "&conint;", "&oint;", "&ContourIntegral;", "&#x0222E;", "&#8750;"));
        this.entries.add(new Entry('\u222f', "&Conint;", "&DoubleContourIntegral;", "&#x0222F;", "&#8751;"));
        this.entries.add(new Entry('\u2230', "&Cconint;", "&#x02230;", "&#8752;"));
        this.entries.add(new Entry('\u2231', "&cwint;", "&#x02231;", "&#8753;"));
        this.entries.add(new Entry('\u2232', "&cwconint;", "&ClockwiseContourIntegral;", "&#x02232;", "&#8754;"));
        this.entries.add(new Entry('\u2233', "&awconint;", "&CounterClockwiseContourIntegral;", "&#x02233;", "&#8755;"));
        this.entries.add(new Entry('\u2234', "&there4;", "&therefore;", "&Therefore;", "&#x02234;", "&#8756;"));
        this.entries.add(new Entry('\u2235', "&becaus;", "&because;", "&Because;", "&#x02235;", "&#8757;"));
        this.entries.add(new Entry('\u2236', "&ratio;", "&#x02236;", "&#8758;"));
        this.entries.add(new Entry('\u2237', "&Colon;", "&Proportion;", "&#x02237;", "&#8759;"));
        this.entries.add(new Entry('\u2238', "&minusd;", "&dotminus;", "&#x02238;", "&#8760;"));
        this.entries.add(new Entry('\u223a', "&mDDot;", "&#x0223A;", "&#8762;"));
        this.entries.add(new Entry('\u223b', "&homtht;", "&#x0223B;", "&#8763;"));
        this.entries.add(new Entry('\u223c', "&sim;", "&Tilde;", "&thksim;", "&thicksim;", "&#x0223C;", "&#8764;"));
        this.entries.add(new Entry('\u223d', "&bsim;", "&backsim;", "&#x0223D;", "&#8765;"));
        this.entries.add(new Entry('\u223e', "&ac;", "&mstpos;", "&#x0223E;", "&#8766;"));
        this.entries.add(new Entry('\u223f', "&acd;", "&#x0223F;", "&#8767;"));
        this.entries.add(new Entry('\u2240', "&wreath;", "&VerticalTilde;", "&wr;", "&#x02240;", "&#8768;"));
        this.entries.add(new Entry('\u2241', "&nsim;", "&NotTilde;", "&#x02241;", "&#8769;"));
        this.entries.add(new Entry('\u2242', "&esim;", "&EqualTilde;", "&eqsim;", "&#x02242;", "&#8770;"));
        this.entries.add(new Entry('\u2243', "&sime;", "&TildeEqual;", "&simeq;", "&#x02243;", "&#8771;"));
        this.entries.add(new Entry('\u2244', "&nsime;", "&nsimeq;", "&NotTildeEqual;", "&#x02244;", "&#8772;"));
        this.entries.add(new Entry('\u2245', "&cong;", "&TildeFullEqual;", "&#x02245;", "&#8773;"));
        this.entries.add(new Entry('\u2246', "&simne;", "&#x02246;", "&#8774;"));
        this.entries.add(new Entry('\u2247', "&ncong;", "&NotTildeFullEqual;", "&#x02247;", "&#8775;"));
        this.entries.add(new Entry('\u2248', "&asymp;", "&ap;", "&TildeTilde;", "&approx;", "&thkap;", "&thickapprox;", "&#x02248;", "&#8776;"));
        this.entries.add(new Entry('\u2249', "&nap;", "&NotTildeTilde;", "&napprox;", "&#x02249;", "&#8777;"));
        this.entries.add(new Entry('\u224a', "&ape;", "&approxeq;", "&#x0224A;", "&#8778;"));
        this.entries.add(new Entry('\u224b', "&apid;", "&#x0224B;", "&#8779;"));
        this.entries.add(new Entry('\u224c', "&bcong;", "&backcong;", "&#x0224C;", "&#8780;"));
        this.entries.add(new Entry('\u224d', "&asympeq;", "&CupCap;", "&#x0224D;", "&#8781;"));
        this.entries.add(new Entry('\u224e', "&bump;", "&HumpDownHump;", "&Bumpeq;", "&#x0224E;", "&#8782;"));
        this.entries.add(new Entry('\u224f', "&bumpe;", "&HumpEqual;", "&bumpeq;", "&#x0224F;", "&#8783;"));
        this.entries.add(new Entry('\u2250', "&esdot;", "&DotEqual;", "&doteq;", "&#x02250;", "&#8784;"));
        this.entries.add(new Entry('\u2251', "&eDot;", "&doteqdot;", "&#x02251;", "&#8785;"));
        this.entries.add(new Entry('\u2252', "&efDot;", "&fallingdotseq;", "&#x02252;", "&#8786;"));
        this.entries.add(new Entry('\u2253', "&erDot;", "&risingdotseq;", "&#x02253;", "&#8787;"));
        this.entries.add(new Entry('\u2254', "&colone;", "&coloneq;", "&Assign;", "&#x02254;", "&#8788;"));
        this.entries.add(new Entry('\u2255', "&ecolon;", "&eqcolon;", "&#x02255;", "&#8789;"));
        this.entries.add(new Entry('\u2256', "&ecir;", "&eqcirc;", "&#x02256;", "&#8790;"));
        this.entries.add(new Entry('\u2257', "&cire;", "&circeq;", "&#x02257;", "&#8791;"));
        this.entries.add(new Entry('\u2259', "&wedgeq;", "&#x02259;", "&#8793;"));
        this.entries.add(new Entry('\u225a', "&veeeq;", "&#x0225A;", "&#8794;"));
        this.entries.add(new Entry('\u225c', "&trie;", "&triangleq;", "&#x0225C;", "&#8796;"));
        this.entries.add(new Entry('\u225f', "&equest;", "&questeq;", "&#x0225F;", "&#8799;"));
        this.entries.add(new Entry('\u2260', "&ne;", "&NotEqual;", "&#x02260;", "&#8800;"));
        this.entries.add(new Entry('\u2261', "&equiv;", "&Congruent;", "&#x02261;", "&#8801;"));
        this.entries.add(new Entry('\u2262', "&nequiv;", "&NotCongruent;", "&#x02262;", "&#8802;"));
        this.entries.add(new Entry('\u2264', "&le;", "&leq;", "&#x02264;", "&#8804;"));
        this.entries.add(new Entry('\u2265', "&ge;", "&GreaterEqual;", "&geq;", "&#x02265;", "&#8805;"));
        this.entries.add(new Entry('\u2266', "&lE;", "&LessFullEqual;", "&leqq;", "&#x02266;", "&#8806;"));
        this.entries.add(new Entry('\u2267', "&gE;", "&GreaterFullEqual;", "&geqq;", "&#x02267;", "&#8807;"));
        this.entries.add(new Entry('\u2268', "&lnE;", "&lneqq;", "&#x02268;", "&#8808;"));
        this.entries.add(new Entry('\u2269', "&gnE;", "&gneqq;", "&#x02269;", "&#8809;"));
        this.entries.add(new Entry('\u226a', "&Lt;", "&NestedLessLess;", "&ll;", "&#x0226A;", "&#8810;"));
        this.entries.add(new Entry('\u226b', "&Gt;", "&NestedGreaterGreater;", "&gg;", "&#x0226B;", "&#8811;"));
        this.entries.add(new Entry('\u226c', "&twixt;", "&between;", "&#x0226C;", "&#8812;"));
        this.entries.add(new Entry('\u226d', "&NotCupCap;", "&#x0226D;", "&#8813;"));
        this.entries.add(new Entry('\u226e', "&nlt;", "&NotLess;", "&nless;", "&#x0226E;", "&#8814;"));
        this.entries.add(new Entry('\u226f', "&ngt;", "&NotGreater;", "&ngtr;", "&#x0226F;", "&#8815;"));
        this.entries.add(new Entry('\u2270', "&nle;", "&NotLessEqual;", "&nleq;", "&#x02270;", "&#8816;"));
        this.entries.add(new Entry('\u2271', "&nge;", "&NotGreaterEqual;", "&ngeq;", "&#x02271;", "&#8817;"));
        this.entries.add(new Entry('\u2272', "&lsim;", "&LessTilde;", "&lesssim;", "&#x02272;", "&#8818;"));
        this.entries.add(new Entry('\u2273', "&gsim;", "&gtrsim;", "&GreaterTilde;", "&#x02273;", "&#8819;"));
        this.entries.add(new Entry('\u2274', "&nlsim;", "&NotLessTilde;", "&#x02274;", "&#8820;"));
        this.entries.add(new Entry('\u2275', "&ngsim;", "&NotGreaterTilde;", "&#x02275;", "&#8821;"));
        this.entries.add(new Entry('\u2276', "&lg;", "&lessgtr;", "&LessGreater;", "&#x02276;", "&#8822;"));
        this.entries.add(new Entry('\u2277', "&gl;", "&gtrless;", "&GreaterLess;", "&#x02277;", "&#8823;"));
        this.entries.add(new Entry('\u2278', "&ntlg;", "&NotLessGreater;", "&#x02278;", "&#8824;"));
        this.entries.add(new Entry('\u2279', "&ntgl;", "&NotGreaterLess;", "&#x02279;", "&#8825;"));
        this.entries.add(new Entry('\u227a', "&pr;", "&Precedes;", "&prec;", "&#x0227A;", "&#8826;"));
        this.entries.add(new Entry('\u227b', "&sc;", "&Succeeds;", "&succ;", "&#x0227B;", "&#8827;"));
        this.entries.add(new Entry('\u227c', "&prcue;", "&PrecedesSlantEqual;", "&preccurlyeq;", "&#x0227C;", "&#8828;"));
        this.entries.add(new Entry('\u227d', "&sccue;", "&SucceedsSlantEqual;", "&succcurlyeq;", "&#x0227D;", "&#8829;"));
        this.entries.add(new Entry('\u227e', "&prsim;", "&precsim;", "&PrecedesTilde;", "&#x0227E;", "&#8830;"));
        this.entries.add(new Entry('\u227f', "&scsim;", "&succsim;", "&SucceedsTilde;", "&#x0227F;", "&#8831;"));
        this.entries.add(new Entry('\u2280', "&npr;", "&nprec;", "&NotPrecedes;", "&#x02280;", "&#8832;"));
        this.entries.add(new Entry('\u2281', "&nsc;", "&nsucc;", "&NotSucceeds;", "&#x02281;", "&#8833;"));
        this.entries.add(new Entry('\u2282', "&sub;", "&subset;", "&#x02282;", "&#8834;"));
        this.entries.add(new Entry('\u2283', "&sup;", "&supset;", "&Superset;", "&#x02283;", "&#8835;"));
        this.entries.add(new Entry('\u2284', "&nsub;", "&#x02284;", "&#8836;"));
        this.entries.add(new Entry('\u2285', "&nsup;", "&#x02285;", "&#8837;"));
        this.entries.add(new Entry('\u2286', "&sube;", "&SubsetEqual;", "&subseteq;", "&#x02286;", "&#8838;"));
        this.entries.add(new Entry('\u2287', "&supe;", "&supseteq;", "&SupersetEqual;", "&#x02287;", "&#8839;"));
        this.entries.add(new Entry('\u2288', "&nsube;", "&nsubseteq;", "&NotSubsetEqual;", "&#x02288;", "&#8840;"));
        this.entries.add(new Entry('\u2289', "&nsupe;", "&nsupseteq;", "&NotSupersetEqual;", "&#x02289;", "&#8841;"));
        this.entries.add(new Entry('\u228a', "&subne;", "&subsetneq;", "&#x0228A;", "&#8842;"));
        this.entries.add(new Entry('\u228b', "&supne;", "&supsetneq;", "&#x0228B;", "&#8843;"));
        this.entries.add(new Entry('\u228d', "&cupdot;", "&#x0228D;", "&#8845;"));
        this.entries.add(new Entry('\u228e', "&uplus;", "&UnionPlus;", "&#x0228E;", "&#8846;"));
        this.entries.add(new Entry('\u228f', "&sqsub;", "&SquareSubset;", "&sqsubset;", "&#x0228F;", "&#8847;"));
        this.entries.add(new Entry('\u2290', "&sqsup;", "&SquareSuperset;", "&sqsupset;", "&#x02290;", "&#8848;"));
        this.entries.add(new Entry('\u2291', "&sqsube;", "&SquareSubsetEqual;", "&sqsubseteq;", "&#x02291;", "&#8849;"));
        this.entries.add(new Entry('\u2292', "&sqsupe;", "&SquareSupersetEqual;", "&sqsupseteq;", "&#x02292;", "&#8850;"));
        this.entries.add(new Entry('\u2293', "&sqcap;", "&SquareIntersection;", "&#x02293;", "&#8851;"));
        this.entries.add(new Entry('\u2294', "&sqcup;", "&SquareUnion;", "&#x02294;", "&#8852;"));
        this.entries.add(new Entry('\u2295', "&oplus;", "&CirclePlus;", "&#x02295;", "&#8853;"));
        this.entries.add(new Entry('\u2296', "&ominus;", "&CircleMinus;", "&#x02296;", "&#8854;"));
        this.entries.add(new Entry('\u2297', "&otimes;", "&CircleTimes;", "&#x02297;", "&#8855;"));
        this.entries.add(new Entry('\u2298', "&osol;", "&#x02298;", "&#8856;"));
        this.entries.add(new Entry('\u2299', "&odot;", "&CircleDot;", "&#x02299;", "&#8857;"));
        this.entries.add(new Entry('\u229a', "&ocir;", "&circledcirc;", "&#x0229A;", "&#8858;"));
        this.entries.add(new Entry('\u229b', "&oast;", "&circledast;", "&#x0229B;", "&#8859;"));
        this.entries.add(new Entry('\u229d', "&odash;", "&circleddash;", "&#x0229D;", "&#8861;"));
        this.entries.add(new Entry('\u229e', "&plusb;", "&boxplus;", "&#x0229E;", "&#8862;"));
        this.entries.add(new Entry('\u229f', "&minusb;", "&boxminus;", "&#x0229F;", "&#8863;"));
        this.entries.add(new Entry('\u22a0', "&timesb;", "&boxtimes;", "&#x022A0;", "&#8864;"));
        this.entries.add(new Entry('\u22a1', "&sdotb;", "&dotsquare;", "&#x022A1;", "&#8865;"));
        this.entries.add(new Entry('\u22a2', "&vdash;", "&RightTee;", "&#x022A2;", "&#8866;"));
        this.entries.add(new Entry('\u22a3', "&dashv;", "&LeftTee;", "&#x022A3;", "&#8867;"));
        this.entries.add(new Entry('\u22a4', "&top;", "&DownTee;", "&#x022A4;", "&#8868;"));
        this.entries.add(new Entry('\u22a5', "&bottom;", "&bot;", "&perp;", "&UpTee;", "&#x022A5;", "&#8869;"));
        this.entries.add(new Entry('\u22a7', "&models;", "&#x022A7;", "&#8871;"));
        this.entries.add(new Entry('\u22a8', "&vDash;", "&DoubleRightTee;", "&#x022A8;", "&#8872;"));
        this.entries.add(new Entry('\u22a9', "&Vdash;", "&#x022A9;", "&#8873;"));
        this.entries.add(new Entry('\u22aa', "&Vvdash;", "&#x022AA;", "&#8874;"));
        this.entries.add(new Entry('\u22ab', "&VDash;", "&#x022AB;", "&#8875;"));
        this.entries.add(new Entry('\u22ac', "&nvdash;", "&#x022AC;", "&#8876;"));
        this.entries.add(new Entry('\u22ad', "&nvDash;", "&#x022AD;", "&#8877;"));
        this.entries.add(new Entry('\u22ae', "&nVdash;", "&#x022AE;", "&#8878;"));
        this.entries.add(new Entry('\u22af', "&nVDash;", "&#x022AF;", "&#8879;"));
        this.entries.add(new Entry('\u22b0', "&prurel;", "&#x022B0;", "&#8880;"));
        this.entries.add(new Entry('\u22b2', "&vltri;", "&vartriangleleft;", "&LeftTriangle;", "&#x022B2;", "&#8882;"));
        this.entries.add(new Entry('\u22b3', "&vrtri;", "&vartriangleright;", "&RightTriangle;", "&#x022B3;", "&#8883;"));
        this.entries.add(new Entry('\u22b4', "&ltrie;", "&trianglelefteq;", "&LeftTriangleEqual;", "&#x022B4;", "&#8884;"));
        this.entries.add(new Entry('\u22b5', "&rtrie;", "&trianglerighteq;", "&RightTriangleEqual;", "&#x022B5;", "&#8885;"));
        this.entries.add(new Entry('\u22b6', "&origof;", "&#x022B6;", "&#8886;"));
        this.entries.add(new Entry('\u22b7', "&imof;", "&#x022B7;", "&#8887;"));
        this.entries.add(new Entry('\u22b8', "&mumap;", "&multimap;", "&#x022B8;", "&#8888;"));
        this.entries.add(new Entry('\u22b9', "&hercon;", "&#x022B9;", "&#8889;"));
        this.entries.add(new Entry('\u22ba', "&intcal;", "&intercal;", "&#x022BA;", "&#8890;"));
        this.entries.add(new Entry('\u22bb', "&veebar;", "&#x022BB;", "&#8891;"));
        this.entries.add(new Entry('\u22bd', "&barvee;", "&#x022BD;", "&#8893;"));
        this.entries.add(new Entry('\u22be', "&angrtvb;", "&#x022BE;", "&#8894;"));
        this.entries.add(new Entry('\u22bf', "&lrtri;", "&#x022BF;", "&#8895;"));
        this.entries.add(new Entry('\u22c0', "&xwedge;", "&Wedge;", "&bigwedge;", "&#x022C0;", "&#8896;"));
        this.entries.add(new Entry('\u22c1', "&xvee;", "&Vee;", "&bigvee;", "&#x022C1;", "&#8897;"));
        this.entries.add(new Entry('\u22c2', "&xcap;", "&Intersection;", "&bigcap;", "&#x022C2;", "&#8898;"));
        this.entries.add(new Entry('\u22c3', "&xcup;", "&Union;", "&bigcup;", "&#x022C3;", "&#8899;"));
        this.entries.add(new Entry('\u22c4', "&diam;", "&diamond;", "&Diamond;", "&#x022C4;", "&#8900;"));
        this.entries.add(new Entry('\u22c5', "&sdot;", "&#x022C5;", "&#8901;"));
        this.entries.add(new Entry('\u22c6', "&sstarf;", "&Star;", "&#x022C6;", "&#8902;"));
        this.entries.add(new Entry('\u22c7', "&divonx;", "&divideontimes;", "&#x022C7;", "&#8903;"));
        this.entries.add(new Entry('\u22c8', "&bowtie;", "&#x022C8;", "&#8904;"));
        this.entries.add(new Entry('\u22c9', "&ltimes;", "&#x022C9;", "&#8905;"));
        this.entries.add(new Entry('\u22ca', "&rtimes;", "&#x022CA;", "&#8906;"));
        this.entries.add(new Entry('\u22cb', "&lthree;", "&leftthreetimes;", "&#x022CB;", "&#8907;"));
        this.entries.add(new Entry('\u22cc', "&rthree;", "&rightthreetimes;", "&#x022CC;", "&#8908;"));
        this.entries.add(new Entry('\u22cd', "&bsime;", "&backsimeq;", "&#x022CD;", "&#8909;"));
        this.entries.add(new Entry('\u22ce', "&cuvee;", "&curlyvee;", "&#x022CE;", "&#8910;"));
        this.entries.add(new Entry('\u22cf', "&cuwed;", "&curlywedge;", "&#x022CF;", "&#8911;"));
        this.entries.add(new Entry('\u22d0', "&Sub;", "&Subset;", "&#x022D0;", "&#8912;"));
        this.entries.add(new Entry('\u22d1', "&Sup;", "&Supset;", "&#x022D1;", "&#8913;"));
        this.entries.add(new Entry('\u22d2', "&Cap;", "&#x022D2;", "&#8914;"));
        this.entries.add(new Entry('\u22d3', "&Cup;", "&#x022D3;", "&#8915;"));
        this.entries.add(new Entry('\u22d4', "&fork;", "&pitchfork;", "&#x022D4;", "&#8916;"));
        this.entries.add(new Entry('\u22d5', "&epar;", "&#x022D5;", "&#8917;"));
        this.entries.add(new Entry('\u22d6', "&ltdot;", "&lessdot;", "&#x022D6;", "&#8918;"));
        this.entries.add(new Entry('\u22d7', "&gtdot;", "&gtrdot;", "&#x022D7;", "&#8919;"));
        this.entries.add(new Entry('\u22d8', "&Ll;", "&#x022D8;", "&#8920;"));
        this.entries.add(new Entry('\u22d9', "&Gg;", "&ggg;", "&#x022D9;", "&#8921;"));
        this.entries.add(new Entry('\u22da', "&leg;", "&LessEqualGreater;", "&lesseqgtr;", "&#x022DA;", "&#8922;"));
        this.entries.add(new Entry('\u22db', "&gel;", "&gtreqless;", "&GreaterEqualLess;", "&#x022DB;", "&#8923;"));
        this.entries.add(new Entry('\u22de', "&cuepr;", "&curlyeqprec;", "&#x022DE;", "&#8926;"));
        this.entries.add(new Entry('\u22df', "&cuesc;", "&curlyeqsucc;", "&#x022DF;", "&#8927;"));
        this.entries.add(new Entry('\u22e0', "&nprcue;", "&NotPrecedesSlantEqual;", "&#x022E0;", "&#8928;"));
        this.entries.add(new Entry('\u22e1', "&nsccue;", "&NotSucceedsSlantEqual;", "&#x022E1;", "&#8929;"));
        this.entries.add(new Entry('\u22e2', "&nsqsube;", "&NotSquareSubsetEqual;", "&#x022E2;", "&#8930;"));
        this.entries.add(new Entry('\u22e3', "&nsqsupe;", "&NotSquareSupersetEqual;", "&#x022E3;", "&#8931;"));
        this.entries.add(new Entry('\u22e6', "&lnsim;", "&#x022E6;", "&#8934;"));
        this.entries.add(new Entry('\u22e7', "&gnsim;", "&#x022E7;", "&#8935;"));
        this.entries.add(new Entry('\u22e8', "&prnsim;", "&precnsim;", "&#x022E8;", "&#8936;"));
        this.entries.add(new Entry('\u22e9', "&scnsim;", "&succnsim;", "&#x022E9;", "&#8937;"));
        this.entries.add(new Entry('\u22ea', "&nltri;", "&ntriangleleft;", "&NotLeftTriangle;", "&#x022EA;", "&#8938;"));
        this.entries.add(new Entry('\u22eb', "&nrtri;", "&ntriangleright;", "&NotRightTriangle;", "&#x022EB;", "&#8939;"));
        this.entries.add(new Entry('\u22ec', "&nltrie;", "&ntrianglelefteq;", "&NotLeftTriangleEqual;", "&#x022EC;", "&#8940;"));
        this.entries.add(new Entry('\u22ed', "&nrtrie;", "&ntrianglerighteq;", "&NotRightTriangleEqual;", "&#x022ED;", "&#8941;"));
        this.entries.add(new Entry('\u22ee', "&vellip;", "&#x022EE;", "&#8942;"));
        this.entries.add(new Entry('\u22ef', "&ctdot;", "&#x022EF;", "&#8943;"));
        this.entries.add(new Entry('\u22f0', "&utdot;", "&#x022F0;", "&#8944;"));
        this.entries.add(new Entry('\u22f1', "&dtdot;", "&#x022F1;", "&#8945;"));
        this.entries.add(new Entry('\u22f2', "&disin;", "&#x022F2;", "&#8946;"));
        this.entries.add(new Entry('\u22f3', "&isinsv;", "&#x022F3;", "&#8947;"));
        this.entries.add(new Entry('\u22f4', "&isins;", "&#x022F4;", "&#8948;"));
        this.entries.add(new Entry('\u22f5', "&isindot;", "&#x022F5;", "&#8949;"));
        this.entries.add(new Entry('\u22f6', "&notinvc;", "&#x022F6;", "&#8950;"));
        this.entries.add(new Entry('\u22f7', "&notinvb;", "&#x022F7;", "&#8951;"));
        this.entries.add(new Entry('\u22f9', "&isinE;", "&#x022F9;", "&#8953;"));
        this.entries.add(new Entry('\u22fa', "&nisd;", "&#x022FA;", "&#8954;"));
        this.entries.add(new Entry('\u22fb', "&xnis;", "&#x022FB;", "&#8955;"));
        this.entries.add(new Entry('\u22fc', "&nis;", "&#x022FC;", "&#8956;"));
        this.entries.add(new Entry('\u22fd', "&notnivc;", "&#x022FD;", "&#8957;"));
        this.entries.add(new Entry('\u22fe', "&notnivb;", "&#x022FE;", "&#8958;"));
        this.entries.add(new Entry('\u2305', "&barwed;", "&barwedge;", "&#x02305;", "&#8965;"));
        this.entries.add(new Entry('\u2306', "&Barwed;", "&doublebarwedge;", "&#x02306;", "&#8966;"));
        this.entries.add(new Entry('\u2308', "&lceil;", "&LeftCeiling;", "&#x02308;", "&#8968;"));
        this.entries.add(new Entry('\u2309', "&rceil;", "&RightCeiling;", "&#x02309;", "&#8969;"));
        this.entries.add(new Entry('\u230a', "&lfloor;", "&LeftFloor;", "&#x0230A;", "&#8970;"));
        this.entries.add(new Entry('\u230b', "&rfloor;", "&RightFloor;", "&#x0230B;", "&#8971;"));
        this.entries.add(new Entry('\u230c', "&drcrop;", "&#x0230C;", "&#8972;"));
        this.entries.add(new Entry('\u230d', "&dlcrop;", "&#x0230D;", "&#8973;"));
        this.entries.add(new Entry('\u230e', "&urcrop;", "&#x0230E;", "&#8974;"));
        this.entries.add(new Entry('\u230f', "&ulcrop;", "&#x0230F;", "&#8975;"));
        this.entries.add(new Entry('\u2310', "&bnot;", "&#x02310;", "&#8976;"));
        this.entries.add(new Entry('\u2312', "&profline;", "&#x02312;", "&#8978;"));
        this.entries.add(new Entry('\u2313', "&profsurf;", "&#x02313;", "&#8979;"));
        this.entries.add(new Entry('\u2315', "&telrec;", "&#x02315;", "&#8981;"));
        this.entries.add(new Entry('\u2316', "&target;", "&#x02316;", "&#8982;"));
        this.entries.add(new Entry('\u231c', "&ulcorn;", "&ulcorner;", "&#x0231C;", "&#8988;"));
        this.entries.add(new Entry('\u231d', "&urcorn;", "&urcorner;", "&#x0231D;", "&#8989;"));
        this.entries.add(new Entry('\u231e', "&dlcorn;", "&llcorner;", "&#x0231E;", "&#8990;"));
        this.entries.add(new Entry('\u231f', "&drcorn;", "&lrcorner;", "&#x0231F;", "&#8991;"));
        this.entries.add(new Entry('\u2322', "&frown;", "&sfrown;", "&#x02322;", "&#8994;"));
        this.entries.add(new Entry('\u2323', "&smile;", "&ssmile;", "&#x02323;", "&#8995;"));
        this.entries.add(new Entry('\u232d', "&cylcty;", "&#x0232D;", "&#9005;"));
        this.entries.add(new Entry('\u232e', "&profalar;", "&#x0232E;", "&#9006;"));
        this.entries.add(new Entry('\u2336', "&topbot;", "&#x02336;", "&#9014;"));
        this.entries.add(new Entry('\u233d', "&ovbar;", "&#x0233D;", "&#9021;"));
        this.entries.add(new Entry('\u233f', "&solbar;", "&#x0233F;", "&#9023;"));
        this.entries.add(new Entry('\u237c', "&angzarr;", "&#x0237C;", "&#9084;"));
        this.entries.add(new Entry('\u23b0', "&lmoust;", "&lmoustache;", "&#x023B0;", "&#9136;"));
        this.entries.add(new Entry('\u23b1', "&rmoust;", "&rmoustache;", "&#x023B1;", "&#9137;"));
        this.entries.add(new Entry('\u23b4', "&tbrk;", "&OverBracket;", "&#x023B4;", "&#9140;"));
        this.entries.add(new Entry('\u23b5', "&bbrk;", "&UnderBracket;", "&#x023B5;", "&#9141;"));
        this.entries.add(new Entry('\u23b6', "&bbrktbrk;", "&#x023B6;", "&#9142;"));
        this.entries.add(new Entry('\u23dc', "&OverParenthesis;", "&#x023DC;", "&#9180;"));
        this.entries.add(new Entry('\u23dd', "&UnderParenthesis;", "&#x023DD;", "&#9181;"));
        this.entries.add(new Entry('\u23de', "&OverBrace;", "&#x023DE;", "&#9182;"));
        this.entries.add(new Entry('\u23df', "&UnderBrace;", "&#x023DF;", "&#9183;"));
        this.entries.add(new Entry('\u23e2', "&trpezium;", "&#x023E2;", "&#9186;"));
        this.entries.add(new Entry('\u23e7', "&elinters;", "&#x023E7;", "&#9191;"));
        this.entries.add(new Entry('\u2423', "&blank;", "&#x02423;", "&#9251;"));
        this.entries.add(new Entry('\u24c8', "&oS;", "&circledS;", "&#x024C8;", "&#9416;"));
        this.entries.add(new Entry('\u2500', "&boxh;", "&HorizontalLine;", "&#x02500;", "&#9472;"));
        this.entries.add(new Entry('\u2502', "&boxv;", "&#x02502;", "&#9474;"));
        this.entries.add(new Entry('\u250c', "&boxdr;", "&#x0250C;", "&#9484;"));
        this.entries.add(new Entry('\u2510', "&boxdl;", "&#x02510;", "&#9488;"));
        this.entries.add(new Entry('\u2514', "&boxur;", "&#x02514;", "&#9492;"));
        this.entries.add(new Entry('\u2518', "&boxul;", "&#x02518;", "&#9496;"));
        this.entries.add(new Entry('\u251c', "&boxvr;", "&#x0251C;", "&#9500;"));
        this.entries.add(new Entry('\u2524', "&boxvl;", "&#x02524;", "&#9508;"));
        this.entries.add(new Entry('\u252c', "&boxhd;", "&#x0252C;", "&#9516;"));
        this.entries.add(new Entry('\u2534', "&boxhu;", "&#x02534;", "&#9524;"));
        this.entries.add(new Entry('\u253c', "&boxvh;", "&#x0253C;", "&#9532;"));
        this.entries.add(new Entry('\u2550', "&boxH;", "&#x02550;", "&#9552;"));
        this.entries.add(new Entry('\u2551', "&boxV;", "&#x02551;", "&#9553;"));
        this.entries.add(new Entry('\u2552', "&boxdR;", "&#x02552;", "&#9554;"));
        this.entries.add(new Entry('\u2553', "&boxDr;", "&#x02553;", "&#9555;"));
        this.entries.add(new Entry('\u2554', "&boxDR;", "&#x02554;", "&#9556;"));
        this.entries.add(new Entry('\u2555', "&boxdL;", "&#x02555;", "&#9557;"));
        this.entries.add(new Entry('\u2556', "&boxDl;", "&#x02556;", "&#9558;"));
        this.entries.add(new Entry('\u2557', "&boxDL;", "&#x02557;", "&#9559;"));
        this.entries.add(new Entry('\u2558', "&boxuR;", "&#x02558;", "&#9560;"));
        this.entries.add(new Entry('\u2559', "&boxUr;", "&#x02559;", "&#9561;"));
        this.entries.add(new Entry('\u255a', "&boxUR;", "&#x0255A;", "&#9562;"));
        this.entries.add(new Entry('\u255b', "&boxuL;", "&#x0255B;", "&#9563;"));
        this.entries.add(new Entry('\u255c', "&boxUl;", "&#x0255C;", "&#9564;"));
        this.entries.add(new Entry('\u255d', "&boxUL;", "&#x0255D;", "&#9565;"));
        this.entries.add(new Entry('\u255e', "&boxvR;", "&#x0255E;", "&#9566;"));
        this.entries.add(new Entry('\u255f', "&boxVr;", "&#x0255F;", "&#9567;"));
        this.entries.add(new Entry('\u2560', "&boxVR;", "&#x02560;", "&#9568;"));
        this.entries.add(new Entry('\u2561', "&boxvL;", "&#x02561;", "&#9569;"));
        this.entries.add(new Entry('\u2562', "&boxVl;", "&#x02562;", "&#9570;"));
        this.entries.add(new Entry('\u2563', "&boxVL;", "&#x02563;", "&#9571;"));
        this.entries.add(new Entry('\u2564', "&boxHd;", "&#x02564;", "&#9572;"));
        this.entries.add(new Entry('\u2565', "&boxhD;", "&#x02565;", "&#9573;"));
        this.entries.add(new Entry('\u2566', "&boxHD;", "&#x02566;", "&#9574;"));
        this.entries.add(new Entry('\u2567', "&boxHu;", "&#x02567;", "&#9575;"));
        this.entries.add(new Entry('\u2568', "&boxhU;", "&#x02568;", "&#9576;"));
        this.entries.add(new Entry('\u2569', "&boxHU;", "&#x02569;", "&#9577;"));
        this.entries.add(new Entry('\u256a', "&boxvH;", "&#x0256A;", "&#9578;"));
        this.entries.add(new Entry('\u256b', "&boxVh;", "&#x0256B;", "&#9579;"));
        this.entries.add(new Entry('\u256c', "&boxVH;", "&#x0256C;", "&#9580;"));
        this.entries.add(new Entry('\u2580', "&uhblk;", "&#x02580;", "&#9600;"));
        this.entries.add(new Entry('\u2584', "&lhblk;", "&#x02584;", "&#9604;"));
        this.entries.add(new Entry('\u2588', "&block;", "&#x02588;", "&#9608;"));
        this.entries.add(new Entry('\u2591', "&blk14;", "&#x02591;", "&#9617;"));
        this.entries.add(new Entry('\u2592', "&blk12;", "&#x02592;", "&#9618;"));
        this.entries.add(new Entry('\u2593', "&blk34;", "&#x02593;", "&#9619;"));
        this.entries.add(new Entry('\u25a1', "&squ;", "&square;", "&Square;", "&#x025A1;", "&#9633;"));
        this.entries.add(new Entry('\u25aa', "&squf;", "&squarf;", "&blacksquare;", "&FilledVerySmallSquare;", "&#x025AA;", "&#9642;"));
        this.entries.add(new Entry('\u25ab', "&EmptyVerySmallSquare;", "&#x025AB;", "&#9643;"));
        this.entries.add(new Entry('\u25ad', "&rect;", "&#x025AD;", "&#9645;"));
        this.entries.add(new Entry('\u25ae', "&marker;", "&#x025AE;", "&#9646;"));
        this.entries.add(new Entry('\u25b1', "&fltns;", "&#x025B1;", "&#9649;"));
        this.entries.add(new Entry('\u25b3', "&xutri;", "&bigtriangleup;", "&#x025B3;", "&#9651;"));
        this.entries.add(new Entry('\u25b4', "&utrif;", "&blacktriangle;", "&#x025B4;", "&#9652;"));
        this.entries.add(new Entry('\u25b5', "&utri;", "&triangle;", "&#x025B5;", "&#9653;"));
        this.entries.add(new Entry('\u25b8', "&rtrif;", "&blacktriangleright;", "&#x025B8;", "&#9656;"));
        this.entries.add(new Entry('\u25b9', "&rtri;", "&triangleright;", "&#x025B9;", "&#9657;"));
        this.entries.add(new Entry('\u25bd', "&xdtri;", "&bigtriangledown;", "&#x025BD;", "&#9661;"));
        this.entries.add(new Entry('\u25be', "&dtrif;", "&blacktriangledown;", "&#x025BE;", "&#9662;"));
        this.entries.add(new Entry('\u25bf', "&dtri;", "&triangledown;", "&#x025BF;", "&#9663;"));
        this.entries.add(new Entry('\u25c2', "&ltrif;", "&blacktriangleleft;", "&#x025C2;", "&#9666;"));
        this.entries.add(new Entry('\u25c3', "&ltri;", "&triangleleft;", "&#x025C3;", "&#9667;"));
        this.entries.add(new Entry('\u25ca', "&loz;", "&lozenge;", "&#x025CA;", "&#9674;"));
        this.entries.add(new Entry('\u25cb', "&cir;", "&#x025CB;", "&#9675;"));
        this.entries.add(new Entry('\u25ec', "&tridot;", "&#x025EC;", "&#9708;"));
        this.entries.add(new Entry('\u25ef', "&xcirc;", "&bigcirc;", "&#x025EF;", "&#9711;"));
        this.entries.add(new Entry('\u25f8', "&ultri;", "&#x025F8;", "&#9720;"));
        this.entries.add(new Entry('\u25f9', "&urtri;", "&#x025F9;", "&#9721;"));
        this.entries.add(new Entry('\u25fa', "&lltri;", "&#x025FA;", "&#9722;"));
        this.entries.add(new Entry('\u25fb', "&EmptySmallSquare;", "&#x025FB;", "&#9723;"));
        this.entries.add(new Entry('\u25fc', "&FilledSmallSquare;", "&#x025FC;", "&#9724;"));
        this.entries.add(new Entry('\u2605', "&starf;", "&bigstar;", "&#x02605;", "&#9733;"));
        this.entries.add(new Entry('\u2606', "&star;", "&#x02606;", "&#9734;"));
        this.entries.add(new Entry('\u260e', "&phone;", "&#x0260E;", "&#9742;"));
        this.entries.add(new Entry('\u2640', "&female;", "&#x02640;", "&#9792;"));
        this.entries.add(new Entry('\u2642', "&male;", "&#x02642;", "&#9794;"));
        this.entries.add(new Entry('\u2660', "&spades;", "&spadesuit;", "&#x02660;", "&#9824;"));
        this.entries.add(new Entry('\u2663', "&clubs;", "&clubsuit;", "&#x02663;", "&#9827;"));
        this.entries.add(new Entry('\u2665', "&hearts;", "&heartsuit;", "&#x02665;", "&#9829;"));
        this.entries.add(new Entry('\u2666', "&diams;", "&diamondsuit;", "&#x02666;", "&#9830;"));
        this.entries.add(new Entry('\u266a', "&sung;", "&#x0266A;", "&#9834;"));
        this.entries.add(new Entry('\u266d', "&flat;", "&#x0266D;", "&#9837;"));
        this.entries.add(new Entry('\u266e', "&natur;", "&natural;", "&#x0266E;", "&#9838;"));
        this.entries.add(new Entry('\u266f', "&sharp;", "&#x0266F;", "&#9839;"));
        this.entries.add(new Entry('\u2713', "&check;", "&checkmark;", "&#x02713;", "&#10003;"));
        this.entries.add(new Entry('\u2717', "&cross;", "&#x02717;", "&#10007;"));
        this.entries.add(new Entry('\u2720', "&malt;", "&maltese;", "&#x02720;", "&#10016;"));
        this.entries.add(new Entry('\u2736', "&sext;", "&#x02736;", "&#10038;"));
        this.entries.add(new Entry('\u2758', "&VerticalSeparator;", "&#x02758;", "&#10072;"));
        this.entries.add(new Entry('\u2772', "&lbbrk;", "&#x02772;", "&#10098;"));
        this.entries.add(new Entry('\u2773', "&rbbrk;", "&#x02773;", "&#10099;"));
        this.entries.add(new Entry('\u27e6', "&lobrk;", "&LeftDoubleBracket;", "&#x027E6;", "&#10214;"));
        this.entries.add(new Entry('\u27e7', "&robrk;", "&RightDoubleBracket;", "&#x027E7;", "&#10215;"));
        this.entries.add(new Entry('\u27e8', "&lang;", "&LeftAngleBracket;", "&langle;", "&#x027E8;", "&#10216;"));
        this.entries.add(new Entry('\u27e9', "&rang;", "&RightAngleBracket;", "&rangle;", "&#x027E9;", "&#10217;"));
        this.entries.add(new Entry('\u27ea', "&Lang;", "&#x027EA;", "&#10218;"));
        this.entries.add(new Entry('\u27eb', "&Rang;", "&#x027EB;", "&#10219;"));
        this.entries.add(new Entry('\u27ec', "&loang;", "&#x027EC;", "&#10220;"));
        this.entries.add(new Entry('\u27ed', "&roang;", "&#x027ED;", "&#10221;"));
        this.entries.add(new Entry('\u27f5', "&xlarr;", "&longleftarrow;", "&LongLeftArrow;", "&#x027F5;", "&#10229;"));
        this.entries.add(new Entry('\u27f6', "&xrarr;", "&longrightarrow;", "&LongRightArrow;", "&#x027F6;", "&#10230;"));
        this.entries.add(new Entry('\u27f7', "&xharr;", "&longleftrightarrow;", "&LongLeftRightArrow;", "&#x027F7;", "&#10231;"));
        this.entries.add(new Entry('\u27f8', "&xlArr;", "&Longleftarrow;", "&DoubleLongLeftArrow;", "&#x027F8;", "&#10232;"));
        this.entries.add(new Entry('\u27f9', "&xrArr;", "&Longrightarrow;", "&DoubleLongRightArrow;", "&#x027F9;", "&#10233;"));
        this.entries.add(new Entry('\u27fa', "&xhArr;", "&Longleftrightarrow;", "&DoubleLongLeftRightArrow;", "&#x027FA;", "&#10234;"));
        this.entries.add(new Entry('\u27fc', "&xmap;", "&longmapsto;", "&#x027FC;", "&#10236;"));
        this.entries.add(new Entry('\u27ff', "&dzigrarr;", "&#x027FF;", "&#10239;"));
        this.entries.add(new Entry('\u2902', "&nvlArr;", "&#x02902;", "&#10498;"));
        this.entries.add(new Entry('\u2903', "&nvrArr;", "&#x02903;", "&#10499;"));
        this.entries.add(new Entry('\u2904', "&nvHarr;", "&#x02904;", "&#10500;"));
        this.entries.add(new Entry('\u2905', "&Map;", "&#x02905;", "&#10501;"));
        this.entries.add(new Entry('\u290c', "&lbarr;", "&#x0290C;", "&#10508;"));
        this.entries.add(new Entry('\u290d', "&rbarr;", "&bkarow;", "&#x0290D;", "&#10509;"));
        this.entries.add(new Entry('\u290e', "&lBarr;", "&#x0290E;", "&#10510;"));
        this.entries.add(new Entry('\u290f', "&rBarr;", "&dbkarow;", "&#x0290F;", "&#10511;"));
        this.entries.add(new Entry('\u2910', "&RBarr;", "&drbkarow;", "&#x02910;", "&#10512;"));
        this.entries.add(new Entry('\u2911', "&DDotrahd;", "&#x02911;", "&#10513;"));
        this.entries.add(new Entry('\u2912', "&UpArrowBar;", "&#x02912;", "&#10514;"));
        this.entries.add(new Entry('\u2913', "&DownArrowBar;", "&#x02913;", "&#10515;"));
        this.entries.add(new Entry('\u2916', "&Rarrtl;", "&#x02916;", "&#10518;"));
        this.entries.add(new Entry('\u2919', "&latail;", "&#x02919;", "&#10521;"));
        this.entries.add(new Entry('\u291a', "&ratail;", "&#x0291A;", "&#10522;"));
        this.entries.add(new Entry('\u291b', "&lAtail;", "&#x0291B;", "&#10523;"));
        this.entries.add(new Entry('\u291c', "&rAtail;", "&#x0291C;", "&#10524;"));
        this.entries.add(new Entry('\u291d', "&larrfs;", "&#x0291D;", "&#10525;"));
        this.entries.add(new Entry('\u291e', "&rarrfs;", "&#x0291E;", "&#10526;"));
        this.entries.add(new Entry('\u291f', "&larrbfs;", "&#x0291F;", "&#10527;"));
        this.entries.add(new Entry('\u2920', "&rarrbfs;", "&#x02920;", "&#10528;"));
        this.entries.add(new Entry('\u2923', "&nwarhk;", "&#x02923;", "&#10531;"));
        this.entries.add(new Entry('\u2924', "&nearhk;", "&#x02924;", "&#10532;"));
        this.entries.add(new Entry('\u2925', "&searhk;", "&hksearow;", "&#x02925;", "&#10533;"));
        this.entries.add(new Entry('\u2926', "&swarhk;", "&hkswarow;", "&#x02926;", "&#10534;"));
        this.entries.add(new Entry('\u2927', "&nwnear;", "&#x02927;", "&#10535;"));
        this.entries.add(new Entry('\u2928', "&nesear;", "&toea;", "&#x02928;", "&#10536;"));
        this.entries.add(new Entry('\u2929', "&seswar;", "&tosa;", "&#x02929;", "&#10537;"));
        this.entries.add(new Entry('\u292a', "&swnwar;", "&#x0292A;", "&#10538;"));
        this.entries.add(new Entry('\u2933', "&rarrc;", "&#x02933;", "&#10547;"));
        this.entries.add(new Entry('\u2935', "&cudarrr;", "&#x02935;", "&#10549;"));
        this.entries.add(new Entry('\u2936', "&ldca;", "&#x02936;", "&#10550;"));
        this.entries.add(new Entry('\u2937', "&rdca;", "&#x02937;", "&#10551;"));
        this.entries.add(new Entry('\u2938', "&cudarrl;", "&#x02938;", "&#10552;"));
        this.entries.add(new Entry('\u2939', "&larrpl;", "&#x02939;", "&#10553;"));
        this.entries.add(new Entry('\u293c', "&curarrm;", "&#x0293C;", "&#10556;"));
        this.entries.add(new Entry('\u293d', "&cularrp;", "&#x0293D;", "&#10557;"));
        this.entries.add(new Entry('\u2945', "&rarrpl;", "&#x02945;", "&#10565;"));
        this.entries.add(new Entry('\u2948', "&harrcir;", "&#x02948;", "&#10568;"));
        this.entries.add(new Entry('\u2949', "&Uarrocir;", "&#x02949;", "&#10569;"));
        this.entries.add(new Entry('\u294a', "&lurdshar;", "&#x0294A;", "&#10570;"));
        this.entries.add(new Entry('\u294b', "&ldrushar;", "&#x0294B;", "&#10571;"));
        this.entries.add(new Entry('\u294e', "&LeftRightVector;", "&#x0294E;", "&#10574;"));
        this.entries.add(new Entry('\u294f', "&RightUpDownVector;", "&#x0294F;", "&#10575;"));
        this.entries.add(new Entry('\u2950', "&DownLeftRightVector;", "&#x02950;", "&#10576;"));
        this.entries.add(new Entry('\u2951', "&LeftUpDownVector;", "&#x02951;", "&#10577;"));
        this.entries.add(new Entry('\u2952', "&LeftVectorBar;", "&#x02952;", "&#10578;"));
        this.entries.add(new Entry('\u2953', "&RightVectorBar;", "&#x02953;", "&#10579;"));
        this.entries.add(new Entry('\u2954', "&RightUpVectorBar;", "&#x02954;", "&#10580;"));
        this.entries.add(new Entry('\u2955', "&RightDownVectorBar;", "&#x02955;", "&#10581;"));
        this.entries.add(new Entry('\u2956', "&DownLeftVectorBar;", "&#x02956;", "&#10582;"));
        this.entries.add(new Entry('\u2957', "&DownRightVectorBar;", "&#x02957;", "&#10583;"));
        this.entries.add(new Entry('\u2958', "&LeftUpVectorBar;", "&#x02958;", "&#10584;"));
        this.entries.add(new Entry('\u2959', "&LeftDownVectorBar;", "&#x02959;", "&#10585;"));
        this.entries.add(new Entry('\u295a', "&LeftTeeVector;", "&#x0295A;", "&#10586;"));
        this.entries.add(new Entry('\u295b', "&RightTeeVector;", "&#x0295B;", "&#10587;"));
        this.entries.add(new Entry('\u295c', "&RightUpTeeVector;", "&#x0295C;", "&#10588;"));
        this.entries.add(new Entry('\u295d', "&RightDownTeeVector;", "&#x0295D;", "&#10589;"));
        this.entries.add(new Entry('\u295e', "&DownLeftTeeVector;", "&#x0295E;", "&#10590;"));
        this.entries.add(new Entry('\u295f', "&DownRightTeeVector;", "&#x0295F;", "&#10591;"));
        this.entries.add(new Entry('\u2960', "&LeftUpTeeVector;", "&#x02960;", "&#10592;"));
        this.entries.add(new Entry('\u2961', "&LeftDownTeeVector;", "&#x02961;", "&#10593;"));
        this.entries.add(new Entry('\u2962', "&lHar;", "&#x02962;", "&#10594;"));
        this.entries.add(new Entry('\u2963', "&uHar;", "&#x02963;", "&#10595;"));
        this.entries.add(new Entry('\u2964', "&rHar;", "&#x02964;", "&#10596;"));
        this.entries.add(new Entry('\u2965', "&dHar;", "&#x02965;", "&#10597;"));
        this.entries.add(new Entry('\u2966', "&luruhar;", "&#x02966;", "&#10598;"));
        this.entries.add(new Entry('\u2967', "&ldrdhar;", "&#x02967;", "&#10599;"));
        this.entries.add(new Entry('\u2968', "&ruluhar;", "&#x02968;", "&#10600;"));
        this.entries.add(new Entry('\u2969', "&rdldhar;", "&#x02969;", "&#10601;"));
        this.entries.add(new Entry('\u296a', "&lharul;", "&#x0296A;", "&#10602;"));
        this.entries.add(new Entry('\u296b', "&llhard;", "&#x0296B;", "&#10603;"));
        this.entries.add(new Entry('\u296c', "&rharul;", "&#x0296C;", "&#10604;"));
        this.entries.add(new Entry('\u296d', "&lrhard;", "&#x0296D;", "&#10605;"));
        this.entries.add(new Entry('\u296e', "&udhar;", "&UpEquilibrium;", "&#x0296E;", "&#10606;"));
        this.entries.add(new Entry('\u296f', "&duhar;", "&ReverseUpEquilibrium;", "&#x0296F;", "&#10607;"));
        this.entries.add(new Entry('\u2970', "&RoundImplies;", "&#x02970;", "&#10608;"));
        this.entries.add(new Entry('\u2971', "&erarr;", "&#x02971;", "&#10609;"));
        this.entries.add(new Entry('\u2972', "&simrarr;", "&#x02972;", "&#10610;"));
        this.entries.add(new Entry('\u2973', "&larrsim;", "&#x02973;", "&#10611;"));
        this.entries.add(new Entry('\u2974', "&rarrsim;", "&#x02974;", "&#10612;"));
        this.entries.add(new Entry('\u2975', "&rarrap;", "&#x02975;", "&#10613;"));
        this.entries.add(new Entry('\u2976', "&ltlarr;", "&#x02976;", "&#10614;"));
        this.entries.add(new Entry('\u2978', "&gtrarr;", "&#x02978;", "&#10616;"));
        this.entries.add(new Entry('\u2979', "&subrarr;", "&#x02979;", "&#10617;"));
        this.entries.add(new Entry('\u297b', "&suplarr;", "&#x0297B;", "&#10619;"));
        this.entries.add(new Entry('\u297c', "&lfisht;", "&#x0297C;", "&#10620;"));
        this.entries.add(new Entry('\u297d', "&rfisht;", "&#x0297D;", "&#10621;"));
        this.entries.add(new Entry('\u297e', "&ufisht;", "&#x0297E;", "&#10622;"));
        this.entries.add(new Entry('\u297f', "&dfisht;", "&#x0297F;", "&#10623;"));
        this.entries.add(new Entry('\u2985', "&lopar;", "&#x02985;", "&#10629;"));
        this.entries.add(new Entry('\u2986', "&ropar;", "&#x02986;", "&#10630;"));
        this.entries.add(new Entry('\u298b', "&lbrke;", "&#x0298B;", "&#10635;"));
        this.entries.add(new Entry('\u298c', "&rbrke;", "&#x0298C;", "&#10636;"));
        this.entries.add(new Entry('\u298d', "&lbrkslu;", "&#x0298D;", "&#10637;"));
        this.entries.add(new Entry('\u298e', "&rbrksld;", "&#x0298E;", "&#10638;"));
        this.entries.add(new Entry('\u298f', "&lbrksld;", "&#x0298F;", "&#10639;"));
        this.entries.add(new Entry('\u2990', "&rbrkslu;", "&#x02990;", "&#10640;"));
        this.entries.add(new Entry('\u2991', "&langd;", "&#x02991;", "&#10641;"));
        this.entries.add(new Entry('\u2992', "&rangd;", "&#x02992;", "&#10642;"));
        this.entries.add(new Entry('\u2993', "&lparlt;", "&#x02993;", "&#10643;"));
        this.entries.add(new Entry('\u2994', "&rpargt;", "&#x02994;", "&#10644;"));
        this.entries.add(new Entry('\u2995', "&gtlPar;", "&#x02995;", "&#10645;"));
        this.entries.add(new Entry('\u2996', "&ltrPar;", "&#x02996;", "&#10646;"));
        this.entries.add(new Entry('\u299a', "&vzigzag;", "&#x0299A;", "&#10650;"));
        this.entries.add(new Entry('\u299c', "&vangrt;", "&#x0299C;", "&#10652;"));
        this.entries.add(new Entry('\u299d', "&angrtvbd;", "&#x0299D;", "&#10653;"));
        this.entries.add(new Entry('\u29a4', "&ange;", "&#x029A4;", "&#10660;"));
        this.entries.add(new Entry('\u29a5', "&range;", "&#x029A5;", "&#10661;"));
        this.entries.add(new Entry('\u29a6', "&dwangle;", "&#x029A6;", "&#10662;"));
        this.entries.add(new Entry('\u29a7', "&uwangle;", "&#x029A7;", "&#10663;"));
        this.entries.add(new Entry('\u29a8', "&angmsdaa;", "&#x029A8;", "&#10664;"));
        this.entries.add(new Entry('\u29a9', "&angmsdab;", "&#x029A9;", "&#10665;"));
        this.entries.add(new Entry('\u29aa', "&angmsdac;", "&#x029AA;", "&#10666;"));
        this.entries.add(new Entry('\u29ab', "&angmsdad;", "&#x029AB;", "&#10667;"));
        this.entries.add(new Entry('\u29ac', "&angmsdae;", "&#x029AC;", "&#10668;"));
        this.entries.add(new Entry('\u29ad', "&angmsdaf;", "&#x029AD;", "&#10669;"));
        this.entries.add(new Entry('\u29ae', "&angmsdag;", "&#x029AE;", "&#10670;"));
        this.entries.add(new Entry('\u29af', "&angmsdah;", "&#x029AF;", "&#10671;"));
        this.entries.add(new Entry('\u29b0', "&bemptyv;", "&#x029B0;", "&#10672;"));
        this.entries.add(new Entry('\u29b1', "&demptyv;", "&#x029B1;", "&#10673;"));
        this.entries.add(new Entry('\u29b2', "&cemptyv;", "&#x029B2;", "&#10674;"));
        this.entries.add(new Entry('\u29b3', "&raemptyv;", "&#x029B3;", "&#10675;"));
        this.entries.add(new Entry('\u29b4', "&laemptyv;", "&#x029B4;", "&#10676;"));
        this.entries.add(new Entry('\u29b5', "&ohbar;", "&#x029B5;", "&#10677;"));
        this.entries.add(new Entry('\u29b6', "&omid;", "&#x029B6;", "&#10678;"));
        this.entries.add(new Entry('\u29b7', "&opar;", "&#x029B7;", "&#10679;"));
        this.entries.add(new Entry('\u29b9', "&operp;", "&#x029B9;", "&#10681;"));
        this.entries.add(new Entry('\u29bb', "&olcross;", "&#x029BB;", "&#10683;"));
        this.entries.add(new Entry('\u29bc', "&odsold;", "&#x029BC;", "&#10684;"));
        this.entries.add(new Entry('\u29be', "&olcir;", "&#x029BE;", "&#10686;"));
        this.entries.add(new Entry('\u29bf', "&ofcir;", "&#x029BF;", "&#10687;"));
        this.entries.add(new Entry('\u29c0', "&olt;", "&#x029C0;", "&#10688;"));
        this.entries.add(new Entry('\u29c1', "&ogt;", "&#x029C1;", "&#10689;"));
        this.entries.add(new Entry('\u29c2', "&cirscir;", "&#x029C2;", "&#10690;"));
        this.entries.add(new Entry('\u29c3', "&cirE;", "&#x029C3;", "&#10691;"));
        this.entries.add(new Entry('\u29c4', "&solb;", "&#x029C4;", "&#10692;"));
        this.entries.add(new Entry('\u29c5', "&bsolb;", "&#x029C5;", "&#10693;"));
        this.entries.add(new Entry('\u29c9', "&boxbox;", "&#x029C9;", "&#10697;"));
        this.entries.add(new Entry('\u29cd', "&trisb;", "&#x029CD;", "&#10701;"));
        this.entries.add(new Entry('\u29ce', "&rtriltri;", "&#x029CE;", "&#10702;"));
        this.entries.add(new Entry('\u29cf', "&LeftTriangleBar;", "&#x029CF;", "&#10703;"));
        this.entries.add(new Entry('\u29d0', "&RightTriangleBar;", "&#x029D0;", "&#10704;"));
        this.entries.add(new Entry('\u29da', "&race;", "&#x029DA;", "&#10714;"));
        this.entries.add(new Entry('\u29dc', "&iinfin;", "&#x029DC;", "&#10716;"));
        this.entries.add(new Entry('\u29dd', "&infintie;", "&#x029DD;", "&#10717;"));
        this.entries.add(new Entry('\u29de', "&nvinfin;", "&#x029DE;", "&#10718;"));
        this.entries.add(new Entry('\u29e3', "&eparsl;", "&#x029E3;", "&#10723;"));
        this.entries.add(new Entry('\u29e4', "&smeparsl;", "&#x029E4;", "&#10724;"));
        this.entries.add(new Entry('\u29e5', "&eqvparsl;", "&#x029E5;", "&#10725;"));
        this.entries.add(new Entry('\u29eb', "&lozf;", "&blacklozenge;", "&#x029EB;", "&#10731;"));
        this.entries.add(new Entry('\u29f4', "&RuleDelayed;", "&#x029F4;", "&#10740;"));
        this.entries.add(new Entry('\u29f6', "&dsol;", "&#x029F6;", "&#10742;"));
        this.entries.add(new Entry('\u2a00', "&xodot;", "&bigodot;", "&#x02A00;", "&#10752;"));
        this.entries.add(new Entry('\u2a01', "&xoplus;", "&bigoplus;", "&#x02A01;", "&#10753;"));
        this.entries.add(new Entry('\u2a02', "&xotime;", "&bigotimes;", "&#x02A02;", "&#10754;"));
        this.entries.add(new Entry('\u2a04', "&xuplus;", "&biguplus;", "&#x02A04;", "&#10756;"));
        this.entries.add(new Entry('\u2a06', "&xsqcup;", "&bigsqcup;", "&#x02A06;", "&#10758;"));
        this.entries.add(new Entry('\u2a0c', "&qint;", "&iiiint;", "&#x02A0C;", "&#10764;"));
        this.entries.add(new Entry('\u2a0d', "&fpartint;", "&#x02A0D;", "&#10765;"));
        this.entries.add(new Entry('\u2a10', "&cirfnint;", "&#x02A10;", "&#10768;"));
        this.entries.add(new Entry('\u2a11', "&awint;", "&#x02A11;", "&#10769;"));
        this.entries.add(new Entry('\u2a12', "&rppolint;", "&#x02A12;", "&#10770;"));
        this.entries.add(new Entry('\u2a13', "&scpolint;", "&#x02A13;", "&#10771;"));
        this.entries.add(new Entry('\u2a14', "&npolint;", "&#x02A14;", "&#10772;"));
        this.entries.add(new Entry('\u2a15', "&pointint;", "&#x02A15;", "&#10773;"));
        this.entries.add(new Entry('\u2a16', "&quatint;", "&#x02A16;", "&#10774;"));
        this.entries.add(new Entry('\u2a17', "&intlarhk;", "&#x02A17;", "&#10775;"));
        this.entries.add(new Entry('\u2a22', "&pluscir;", "&#x02A22;", "&#10786;"));
        this.entries.add(new Entry('\u2a23', "&plusacir;", "&#x02A23;", "&#10787;"));
        this.entries.add(new Entry('\u2a24', "&simplus;", "&#x02A24;", "&#10788;"));
        this.entries.add(new Entry('\u2a25', "&plusdu;", "&#x02A25;", "&#10789;"));
        this.entries.add(new Entry('\u2a26', "&plussim;", "&#x02A26;", "&#10790;"));
        this.entries.add(new Entry('\u2a27', "&plustwo;", "&#x02A27;", "&#10791;"));
        this.entries.add(new Entry('\u2a29', "&mcomma;", "&#x02A29;", "&#10793;"));
        this.entries.add(new Entry('\u2a2a', "&minusdu;", "&#x02A2A;", "&#10794;"));
        this.entries.add(new Entry('\u2a2d', "&loplus;", "&#x02A2D;", "&#10797;"));
        this.entries.add(new Entry('\u2a2e', "&roplus;", "&#x02A2E;", "&#10798;"));
        this.entries.add(new Entry('\u2a2f', "&Cross;", "&#x02A2F;", "&#10799;"));
        this.entries.add(new Entry('\u2a30', "&timesd;", "&#x02A30;", "&#10800;"));
        this.entries.add(new Entry('\u2a31', "&timesbar;", "&#x02A31;", "&#10801;"));
        this.entries.add(new Entry('\u2a33', "&smashp;", "&#x02A33;", "&#10803;"));
        this.entries.add(new Entry('\u2a34', "&lotimes;", "&#x02A34;", "&#10804;"));
        this.entries.add(new Entry('\u2a35', "&rotimes;", "&#x02A35;", "&#10805;"));
        this.entries.add(new Entry('\u2a36', "&otimesas;", "&#x02A36;", "&#10806;"));
        this.entries.add(new Entry('\u2a37', "&Otimes;", "&#x02A37;", "&#10807;"));
        this.entries.add(new Entry('\u2a38', "&odiv;", "&#x02A38;", "&#10808;"));
        this.entries.add(new Entry('\u2a39', "&triplus;", "&#x02A39;", "&#10809;"));
        this.entries.add(new Entry('\u2a3a', "&triminus;", "&#x02A3A;", "&#10810;"));
        this.entries.add(new Entry('\u2a3b', "&tritime;", "&#x02A3B;", "&#10811;"));
        this.entries.add(new Entry('\u2a3c', "&iprod;", "&intprod;", "&#x02A3C;", "&#10812;"));
        this.entries.add(new Entry('\u2a3f', "&amalg;", "&#x02A3F;", "&#10815;"));
        this.entries.add(new Entry('\u2a40', "&capdot;", "&#x02A40;", "&#10816;"));
        this.entries.add(new Entry('\u2a42', "&ncup;", "&#x02A42;", "&#10818;"));
        this.entries.add(new Entry('\u2a43', "&ncap;", "&#x02A43;", "&#10819;"));
        this.entries.add(new Entry('\u2a44', "&capand;", "&#x02A44;", "&#10820;"));
        this.entries.add(new Entry('\u2a45', "&cupor;", "&#x02A45;", "&#10821;"));
        this.entries.add(new Entry('\u2a46', "&cupcap;", "&#x02A46;", "&#10822;"));
        this.entries.add(new Entry('\u2a47', "&capcup;", "&#x02A47;", "&#10823;"));
        this.entries.add(new Entry('\u2a48', "&cupbrcap;", "&#x02A48;", "&#10824;"));
        this.entries.add(new Entry('\u2a49', "&capbrcup;", "&#x02A49;", "&#10825;"));
        this.entries.add(new Entry('\u2a4a', "&cupcup;", "&#x02A4A;", "&#10826;"));
        this.entries.add(new Entry('\u2a4b', "&capcap;", "&#x02A4B;", "&#10827;"));
        this.entries.add(new Entry('\u2a4c', "&ccups;", "&#x02A4C;", "&#10828;"));
        this.entries.add(new Entry('\u2a4d', "&ccaps;", "&#x02A4D;", "&#10829;"));
        this.entries.add(new Entry('\u2a50', "&ccupssm;", "&#x02A50;", "&#10832;"));
        this.entries.add(new Entry('\u2a53', "&And;", "&#x02A53;", "&#10835;"));
        this.entries.add(new Entry('\u2a54', "&Or;", "&#x02A54;", "&#10836;"));
        this.entries.add(new Entry('\u2a55', "&andand;", "&#x02A55;", "&#10837;"));
        this.entries.add(new Entry('\u2a56', "&oror;", "&#x02A56;", "&#10838;"));
        this.entries.add(new Entry('\u2a57', "&orslope;", "&#x02A57;", "&#10839;"));
        this.entries.add(new Entry('\u2a58', "&andslope;", "&#x02A58;", "&#10840;"));
        this.entries.add(new Entry('\u2a5a', "&andv;", "&#x02A5A;", "&#10842;"));
        this.entries.add(new Entry('\u2a5b', "&orv;", "&#x02A5B;", "&#10843;"));
        this.entries.add(new Entry('\u2a5c', "&andd;", "&#x02A5C;", "&#10844;"));
        this.entries.add(new Entry('\u2a5d', "&ord;", "&#x02A5D;", "&#10845;"));
        this.entries.add(new Entry('\u2a5f', "&wedbar;", "&#x02A5F;", "&#10847;"));
        this.entries.add(new Entry('\u2a66', "&sdote;", "&#x02A66;", "&#10854;"));
        this.entries.add(new Entry('\u2a6a', "&simdot;", "&#x02A6A;", "&#10858;"));
        this.entries.add(new Entry('\u2a6d', "&congdot;", "&#x02A6D;", "&#10861;"));
        this.entries.add(new Entry('\u2a6e', "&easter;", "&#x02A6E;", "&#10862;"));
        this.entries.add(new Entry('\u2a6f', "&apacir;", "&#x02A6F;", "&#10863;"));
        this.entries.add(new Entry('\u2a70', "&apE;", "&#x02A70;", "&#10864;"));
        this.entries.add(new Entry('\u2a71', "&eplus;", "&#x02A71;", "&#10865;"));
        this.entries.add(new Entry('\u2a72', "&pluse;", "&#x02A72;", "&#10866;"));
        this.entries.add(new Entry('\u2a73', "&Esim;", "&#x02A73;", "&#10867;"));
        this.entries.add(new Entry('\u2a74', "&Colone;", "&#x02A74;", "&#10868;"));
        this.entries.add(new Entry('\u2a75', "&Equal;", "&#x02A75;", "&#10869;"));
        this.entries.add(new Entry('\u2a77', "&eDDot;", "&ddotseq;", "&#x02A77;", "&#10871;"));
        this.entries.add(new Entry('\u2a78', "&equivDD;", "&#x02A78;", "&#10872;"));
        this.entries.add(new Entry('\u2a79', "&ltcir;", "&#x02A79;", "&#10873;"));
        this.entries.add(new Entry('\u2a7a', "&gtcir;", "&#x02A7A;", "&#10874;"));
        this.entries.add(new Entry('\u2a7b', "&ltquest;", "&#x02A7B;", "&#10875;"));
        this.entries.add(new Entry('\u2a7c', "&gtquest;", "&#x02A7C;", "&#10876;"));
        this.entries.add(new Entry('\u2a7d', "&les;", "&LessSlantEqual;", "&leqslant;", "&#x02A7D;", "&#10877;"));
        this.entries.add(new Entry('\u2a7e', "&ges;", "&GreaterSlantEqual;", "&geqslant;", "&#x02A7E;", "&#10878;"));
        this.entries.add(new Entry('\u2a7f', "&lesdot;", "&#x02A7F;", "&#10879;"));
        this.entries.add(new Entry('\u2a80', "&gesdot;", "&#x02A80;", "&#10880;"));
        this.entries.add(new Entry('\u2a81', "&lesdoto;", "&#x02A81;", "&#10881;"));
        this.entries.add(new Entry('\u2a82', "&gesdoto;", "&#x02A82;", "&#10882;"));
        this.entries.add(new Entry('\u2a83', "&lesdotor;", "&#x02A83;", "&#10883;"));
        this.entries.add(new Entry('\u2a84', "&gesdotol;", "&#x02A84;", "&#10884;"));
        this.entries.add(new Entry('\u2a85', "&lap;", "&lessapprox;", "&#x02A85;", "&#10885;"));
        this.entries.add(new Entry('\u2a86', "&gap;", "&gtrapprox;", "&#x02A86;", "&#10886;"));
        this.entries.add(new Entry('\u2a87', "&lne;", "&lneq;", "&#x02A87;", "&#10887;"));
        this.entries.add(new Entry('\u2a88', "&gne;", "&gneq;", "&#x02A88;", "&#10888;"));
        this.entries.add(new Entry('\u2a89', "&lnap;", "&lnapprox;", "&#x02A89;", "&#10889;"));
        this.entries.add(new Entry('\u2a8a', "&gnap;", "&gnapprox;", "&#x02A8A;", "&#10890;"));
        this.entries.add(new Entry('\u2a8b', "&lEg;", "&lesseqqgtr;", "&#x02A8B;", "&#10891;"));
        this.entries.add(new Entry('\u2a8c', "&gEl;", "&gtreqqless;", "&#x02A8C;", "&#10892;"));
        this.entries.add(new Entry('\u2a8d', "&lsime;", "&#x02A8D;", "&#10893;"));
        this.entries.add(new Entry('\u2a8e', "&gsime;", "&#x02A8E;", "&#10894;"));
        this.entries.add(new Entry('\u2a8f', "&lsimg;", "&#x02A8F;", "&#10895;"));
        this.entries.add(new Entry('\u2a90', "&gsiml;", "&#x02A90;", "&#10896;"));
        this.entries.add(new Entry('\u2a91', "&lgE;", "&#x02A91;", "&#10897;"));
        this.entries.add(new Entry('\u2a92', "&glE;", "&#x02A92;", "&#10898;"));
        this.entries.add(new Entry('\u2a93', "&lesges;", "&#x02A93;", "&#10899;"));
        this.entries.add(new Entry('\u2a94', "&gesles;", "&#x02A94;", "&#10900;"));
        this.entries.add(new Entry('\u2a95', "&els;", "&eqslantless;", "&#x02A95;", "&#10901;"));
        this.entries.add(new Entry('\u2a96', "&egs;", "&eqslantgtr;", "&#x02A96;", "&#10902;"));
        this.entries.add(new Entry('\u2a97', "&elsdot;", "&#x02A97;", "&#10903;"));
        this.entries.add(new Entry('\u2a98', "&egsdot;", "&#x02A98;", "&#10904;"));
        this.entries.add(new Entry('\u2a99', "&el;", "&#x02A99;", "&#10905;"));
        this.entries.add(new Entry('\u2a9a', "&eg;", "&#x02A9A;", "&#10906;"));
        this.entries.add(new Entry('\u2a9d', "&siml;", "&#x02A9D;", "&#10909;"));
        this.entries.add(new Entry('\u2a9e', "&simg;", "&#x02A9E;", "&#10910;"));
        this.entries.add(new Entry('\u2a9f', "&simlE;", "&#x02A9F;", "&#10911;"));
        this.entries.add(new Entry('\u2aa0', "&simgE;", "&#x02AA0;", "&#10912;"));
        this.entries.add(new Entry('\u2aa1', "&LessLess;", "&#x02AA1;", "&#10913;"));
        this.entries.add(new Entry('\u2aa2', "&GreaterGreater;", "&#x02AA2;", "&#10914;"));
        this.entries.add(new Entry('\u2aa4', "&glj;", "&#x02AA4;", "&#10916;"));
        this.entries.add(new Entry('\u2aa5', "&gla;", "&#x02AA5;", "&#10917;"));
        this.entries.add(new Entry('\u2aa6', "&ltcc;", "&#x02AA6;", "&#10918;"));
        this.entries.add(new Entry('\u2aa7', "&gtcc;", "&#x02AA7;", "&#10919;"));
        this.entries.add(new Entry('\u2aa8', "&lescc;", "&#x02AA8;", "&#10920;"));
        this.entries.add(new Entry('\u2aa9', "&gescc;", "&#x02AA9;", "&#10921;"));
        this.entries.add(new Entry('\u2aaa', "&smt;", "&#x02AAA;", "&#10922;"));
        this.entries.add(new Entry('\u2aab', "&lat;", "&#x02AAB;", "&#10923;"));
        this.entries.add(new Entry('\u2aac', "&smte;", "&#x02AAC;", "&#10924;"));
        this.entries.add(new Entry('\u2aad', "&late;", "&#x02AAD;", "&#10925;"));
        this.entries.add(new Entry('\u2aae', "&bumpE;", "&#x02AAE;", "&#10926;"));
        this.entries.add(new Entry('\u2aaf', "&pre;", "&preceq;", "&PrecedesEqual;", "&#x02AAF;", "&#10927;"));
        this.entries.add(new Entry('\u2ab0', "&sce;", "&succeq;", "&SucceedsEqual;", "&#x02AB0;", "&#10928;"));
        this.entries.add(new Entry('\u2ab3', "&prE;", "&#x02AB3;", "&#10931;"));
        this.entries.add(new Entry('\u2ab4', "&scE;", "&#x02AB4;", "&#10932;"));
        this.entries.add(new Entry('\u2ab5', "&prnE;", "&precneqq;", "&#x02AB5;", "&#10933;"));
        this.entries.add(new Entry('\u2ab6', "&scnE;", "&succneqq;", "&#x02AB6;", "&#10934;"));
        this.entries.add(new Entry('\u2ab7', "&prap;", "&precapprox;", "&#x02AB7;", "&#10935;"));
        this.entries.add(new Entry('\u2ab8', "&scap;", "&succapprox;", "&#x02AB8;", "&#10936;"));
        this.entries.add(new Entry('\u2ab9', "&prnap;", "&precnapprox;", "&#x02AB9;", "&#10937;"));
        this.entries.add(new Entry('\u2aba', "&scnap;", "&succnapprox;", "&#x02ABA;", "&#10938;"));
        this.entries.add(new Entry('\u2abb', "&Pr;", "&#x02ABB;", "&#10939;"));
        this.entries.add(new Entry('\u2abc', "&Sc;", "&#x02ABC;", "&#10940;"));
        this.entries.add(new Entry('\u2abd', "&subdot;", "&#x02ABD;", "&#10941;"));
        this.entries.add(new Entry('\u2abe', "&supdot;", "&#x02ABE;", "&#10942;"));
        this.entries.add(new Entry('\u2abf', "&subplus;", "&#x02ABF;", "&#10943;"));
        this.entries.add(new Entry('\u2ac0', "&supplus;", "&#x02AC0;", "&#10944;"));
        this.entries.add(new Entry('\u2ac1', "&submult;", "&#x02AC1;", "&#10945;"));
        this.entries.add(new Entry('\u2ac2', "&supmult;", "&#x02AC2;", "&#10946;"));
        this.entries.add(new Entry('\u2ac3', "&subedot;", "&#x02AC3;", "&#10947;"));
        this.entries.add(new Entry('\u2ac4', "&supedot;", "&#x02AC4;", "&#10948;"));
        this.entries.add(new Entry('\u2ac5', "&subE;", "&subseteqq;", "&#x02AC5;", "&#10949;"));
        this.entries.add(new Entry('\u2ac6', "&supE;", "&supseteqq;", "&#x02AC6;", "&#10950;"));
        this.entries.add(new Entry('\u2ac7', "&subsim;", "&#x02AC7;", "&#10951;"));
        this.entries.add(new Entry('\u2ac8', "&supsim;", "&#x02AC8;", "&#10952;"));
        this.entries.add(new Entry('\u2acb', "&subnE;", "&subsetneqq;", "&#x02ACB;", "&#10955;"));
        this.entries.add(new Entry('\u2acc', "&supnE;", "&supsetneqq;", "&#x02ACC;", "&#10956;"));
        this.entries.add(new Entry('\u2acf', "&csub;", "&#x02ACF;", "&#10959;"));
        this.entries.add(new Entry('\u2ad0', "&csup;", "&#x02AD0;", "&#10960;"));
        this.entries.add(new Entry('\u2ad1', "&csube;", "&#x02AD1;", "&#10961;"));
        this.entries.add(new Entry('\u2ad2', "&csupe;", "&#x02AD2;", "&#10962;"));
        this.entries.add(new Entry('\u2ad3', "&subsup;", "&#x02AD3;", "&#10963;"));
        this.entries.add(new Entry('\u2ad4', "&supsub;", "&#x02AD4;", "&#10964;"));
        this.entries.add(new Entry('\u2ad5', "&subsub;", "&#x02AD5;", "&#10965;"));
        this.entries.add(new Entry('\u2ad6', "&supsup;", "&#x02AD6;", "&#10966;"));
        this.entries.add(new Entry('\u2ad7', "&suphsub;", "&#x02AD7;", "&#10967;"));
        this.entries.add(new Entry('\u2ad8', "&supdsub;", "&#x02AD8;", "&#10968;"));
        this.entries.add(new Entry('\u2ad9', "&forkv;", "&#x02AD9;", "&#10969;"));
        this.entries.add(new Entry('\u2ada', "&topfork;", "&#x02ADA;", "&#10970;"));
        this.entries.add(new Entry('\u2adb', "&mlcp;", "&#x02ADB;", "&#10971;"));
        this.entries.add(new Entry('\u2ae4', "&Dashv;", "&DoubleLeftTee;", "&#x02AE4;", "&#10980;"));
        this.entries.add(new Entry('\u2ae6', "&Vdashl;", "&#x02AE6;", "&#10982;"));
        this.entries.add(new Entry('\u2ae7', "&Barv;", "&#x02AE7;", "&#10983;"));
        this.entries.add(new Entry('\u2ae8', "&vBar;", "&#x02AE8;", "&#10984;"));
        this.entries.add(new Entry('\u2ae9', "&vBarv;", "&#x02AE9;", "&#10985;"));
        this.entries.add(new Entry('\u2aeb', "&Vbar;", "&#x02AEB;", "&#10987;"));
        this.entries.add(new Entry('\u2aec', "&Not;", "&#x02AEC;", "&#10988;"));
        this.entries.add(new Entry('\u2aed', "&bNot;", "&#x02AED;", "&#10989;"));
        this.entries.add(new Entry('\u2aee', "&rnmid;", "&#x02AEE;", "&#10990;"));
        this.entries.add(new Entry('\u2aef', "&cirmid;", "&#x02AEF;", "&#10991;"));
        this.entries.add(new Entry('\u2af0', "&midcir;", "&#x02AF0;", "&#10992;"));
        this.entries.add(new Entry('\u2af1', "&topcir;", "&#x02AF1;", "&#10993;"));
        this.entries.add(new Entry('\u2af2', "&nhpar;", "&#x02AF2;", "&#10994;"));
        this.entries.add(new Entry('\u2af3', "&parsim;", "&#x02AF3;", "&#10995;"));
        this.entries.add(new Entry('\u2afd', "&parsl;", "&#x02AFD;", "&#11005;"));
        this.entries.add(new Entry('\ufb00', "&fflig;", "&#x0FB00;", "&#64256;"));
        this.entries.add(new Entry('\ufb01', "&filig;", "&#x0FB01;", "&#64257;"));
        this.entries.add(new Entry('\ufb02', "&fllig;", "&#x0FB02;", "&#64258;"));
        this.entries.add(new Entry('\ufb03', "&ffilig;", "&#x0FB03;", "&#64259;"));
        this.entries.add(new Entry('\ufb04', "&ffllig;", "&#x0FB04;", "&#64260;"));
        this.entries.add(new Entry('\ud49c', "&Ascr;", "&#x1D49C;", "&#119964;"));
        this.entries.add(new Entry('\ud49e', "&Cscr;", "&#x1D49E;", "&#119966;"));
        this.entries.add(new Entry('\ud49f', "&Dscr;", "&#x1D49F;", "&#119967;"));
        this.entries.add(new Entry('\ud4a2', "&Gscr;", "&#x1D4A2;", "&#119970;"));
        this.entries.add(new Entry('\ud4a5', "&Jscr;", "&#x1D4A5;", "&#119973;"));
        this.entries.add(new Entry('\ud4a6', "&Kscr;", "&#x1D4A6;", "&#119974;"));
        this.entries.add(new Entry('\ud4a9', "&Nscr;", "&#x1D4A9;", "&#119977;"));
        this.entries.add(new Entry('\ud4aa', "&Oscr;", "&#x1D4AA;", "&#119978;"));
        this.entries.add(new Entry('\ud4ab', "&Pscr;", "&#x1D4AB;", "&#119979;"));
        this.entries.add(new Entry('\ud4ac', "&Qscr;", "&#x1D4AC;", "&#119980;"));
        this.entries.add(new Entry('\ud4ae', "&Sscr;", "&#x1D4AE;", "&#119982;"));
        this.entries.add(new Entry('\ud4af', "&Tscr;", "&#x1D4AF;", "&#119983;"));
        this.entries.add(new Entry('\ud4b0', "&Uscr;", "&#x1D4B0;", "&#119984;"));
        this.entries.add(new Entry('\ud4b1', "&Vscr;", "&#x1D4B1;", "&#119985;"));
        this.entries.add(new Entry('\ud4b2', "&Wscr;", "&#x1D4B2;", "&#119986;"));
        this.entries.add(new Entry('\ud4b3', "&Xscr;", "&#x1D4B3;", "&#119987;"));
        this.entries.add(new Entry('\ud4b4', "&Yscr;", "&#x1D4B4;", "&#119988;"));
        this.entries.add(new Entry('\ud4b5', "&Zscr;", "&#x1D4B5;", "&#119989;"));
        this.entries.add(new Entry('\ud4b6', "&ascr;", "&#x1D4B6;", "&#119990;"));
        this.entries.add(new Entry('\ud4b7', "&bscr;", "&#x1D4B7;", "&#119991;"));
        this.entries.add(new Entry('\ud4b8', "&cscr;", "&#x1D4B8;", "&#119992;"));
        this.entries.add(new Entry('\ud4b9', "&dscr;", "&#x1D4B9;", "&#119993;"));
        this.entries.add(new Entry('\ud4bb', "&fscr;", "&#x1D4BB;", "&#119995;"));
        this.entries.add(new Entry('\ud4bd', "&hscr;", "&#x1D4BD;", "&#119997;"));
        this.entries.add(new Entry('\ud4be', "&iscr;", "&#x1D4BE;", "&#119998;"));
        this.entries.add(new Entry('\ud4bf', "&jscr;", "&#x1D4BF;", "&#119999;"));
        this.entries.add(new Entry('\ud4c0', "&kscr;", "&#x1D4C0;", "&#120000;"));
        this.entries.add(new Entry('\ud4c1', "&lscr;", "&#x1D4C1;", "&#120001;"));
        this.entries.add(new Entry('\ud4c2', "&mscr;", "&#x1D4C2;", "&#120002;"));
        this.entries.add(new Entry('\ud4c3', "&nscr;", "&#x1D4C3;", "&#120003;"));
        this.entries.add(new Entry('\ud4c5', "&pscr;", "&#x1D4C5;", "&#120005;"));
        this.entries.add(new Entry('\ud4c6', "&qscr;", "&#x1D4C6;", "&#120006;"));
        this.entries.add(new Entry('\ud4c7', "&rscr;", "&#x1D4C7;", "&#120007;"));
        this.entries.add(new Entry('\ud4c8', "&sscr;", "&#x1D4C8;", "&#120008;"));
        this.entries.add(new Entry('\ud4c9', "&tscr;", "&#x1D4C9;", "&#120009;"));
        this.entries.add(new Entry('\ud4ca', "&uscr;", "&#x1D4CA;", "&#120010;"));
        this.entries.add(new Entry('\ud4cb', "&vscr;", "&#x1D4CB;", "&#120011;"));
        this.entries.add(new Entry('\ud4cc', "&wscr;", "&#x1D4CC;", "&#120012;"));
        this.entries.add(new Entry('\ud4cd', "&xscr;", "&#x1D4CD;", "&#120013;"));
        this.entries.add(new Entry('\ud4ce', "&yscr;", "&#x1D4CE;", "&#120014;"));
        this.entries.add(new Entry('\ud4cf', "&zscr;", "&#x1D4CF;", "&#120015;"));
        this.entries.add(new Entry('\ud504', "&Afr;", "&#x1D504;", "&#120068;"));
        this.entries.add(new Entry('\ud505', "&Bfr;", "&#x1D505;", "&#120069;"));
        this.entries.add(new Entry('\ud507', "&Dfr;", "&#x1D507;", "&#120071;"));
        this.entries.add(new Entry('\ud508', "&Efr;", "&#x1D508;", "&#120072;"));
        this.entries.add(new Entry('\ud509', "&Ffr;", "&#x1D509;", "&#120073;"));
        this.entries.add(new Entry('\ud50a', "&Gfr;", "&#x1D50A;", "&#120074;"));
        this.entries.add(new Entry('\ud50d', "&Jfr;", "&#x1D50D;", "&#120077;"));
        this.entries.add(new Entry('\ud50e', "&Kfr;", "&#x1D50E;", "&#120078;"));
        this.entries.add(new Entry('\ud50f', "&Lfr;", "&#x1D50F;", "&#120079;"));
        this.entries.add(new Entry('\ud510', "&Mfr;", "&#x1D510;", "&#120080;"));
        this.entries.add(new Entry('\ud511', "&Nfr;", "&#x1D511;", "&#120081;"));
        this.entries.add(new Entry('\ud512', "&Ofr;", "&#x1D512;", "&#120082;"));
        this.entries.add(new Entry('\ud513', "&Pfr;", "&#x1D513;", "&#120083;"));
        this.entries.add(new Entry('\ud514', "&Qfr;", "&#x1D514;", "&#120084;"));
        this.entries.add(new Entry('\ud516', "&Sfr;", "&#x1D516;", "&#120086;"));
        this.entries.add(new Entry('\ud517', "&Tfr;", "&#x1D517;", "&#120087;"));
        this.entries.add(new Entry('\ud518', "&Ufr;", "&#x1D518;", "&#120088;"));
        this.entries.add(new Entry('\ud519', "&Vfr;", "&#x1D519;", "&#120089;"));
        this.entries.add(new Entry('\ud51a', "&Wfr;", "&#x1D51A;", "&#120090;"));
        this.entries.add(new Entry('\ud51b', "&Xfr;", "&#x1D51B;", "&#120091;"));
        this.entries.add(new Entry('\ud51c', "&Yfr;", "&#x1D51C;", "&#120092;"));
        this.entries.add(new Entry('\ud51e', "&afr;", "&#x1D51E;", "&#120094;"));
        this.entries.add(new Entry('\ud51f', "&bfr;", "&#x1D51F;", "&#120095;"));
        this.entries.add(new Entry('\ud520', "&cfr;", "&#x1D520;", "&#120096;"));
        this.entries.add(new Entry('\ud521', "&dfr;", "&#x1D521;", "&#120097;"));
        this.entries.add(new Entry('\ud522', "&efr;", "&#x1D522;", "&#120098;"));
        this.entries.add(new Entry('\ud523', "&ffr;", "&#x1D523;", "&#120099;"));
        this.entries.add(new Entry('\ud524', "&gfr;", "&#x1D524;", "&#120100;"));
        this.entries.add(new Entry('\ud525', "&hfr;", "&#x1D525;", "&#120101;"));
        this.entries.add(new Entry('\ud526', "&ifr;", "&#x1D526;", "&#120102;"));
        this.entries.add(new Entry('\ud527', "&jfr;", "&#x1D527;", "&#120103;"));
        this.entries.add(new Entry('\ud528', "&kfr;", "&#x1D528;", "&#120104;"));
        this.entries.add(new Entry('\ud529', "&lfr;", "&#x1D529;", "&#120105;"));
        this.entries.add(new Entry('\ud52a', "&mfr;", "&#x1D52A;", "&#120106;"));
        this.entries.add(new Entry('\ud52b', "&nfr;", "&#x1D52B;", "&#120107;"));
        this.entries.add(new Entry('\ud52c', "&ofr;", "&#x1D52C;", "&#120108;"));
        this.entries.add(new Entry('\ud52d', "&pfr;", "&#x1D52D;", "&#120109;"));
        this.entries.add(new Entry('\ud52e', "&qfr;", "&#x1D52E;", "&#120110;"));
        this.entries.add(new Entry('\ud52f', "&rfr;", "&#x1D52F;", "&#120111;"));
        this.entries.add(new Entry('\ud530', "&sfr;", "&#x1D530;", "&#120112;"));
        this.entries.add(new Entry('\ud531', "&tfr;", "&#x1D531;", "&#120113;"));
        this.entries.add(new Entry('\ud532', "&ufr;", "&#x1D532;", "&#120114;"));
        this.entries.add(new Entry('\ud533', "&vfr;", "&#x1D533;", "&#120115;"));
        this.entries.add(new Entry('\ud534', "&wfr;", "&#x1D534;", "&#120116;"));
        this.entries.add(new Entry('\ud535', "&xfr;", "&#x1D535;", "&#120117;"));
        this.entries.add(new Entry('\ud536', "&yfr;", "&#x1D536;", "&#120118;"));
        this.entries.add(new Entry('\ud537', "&zfr;", "&#x1D537;", "&#120119;"));
        for (Entry entry : this.entries) {
            if (this.entriesByChar.containsKey(Character.valueOf(entry.getCharacter()))) {
                boolean fixed = false;
                String[] stringArray = entry.getEntities();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String entity = stringArray[i];
                    if (!entity.startsWith("&#x")) continue;
                    String hexString = entity.substring(3, entity.length() - 1);
                    long l = Long.parseLong(hexString, 16);
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalStateException("double bound character: " + entry.getCharacter());
                    }
                    int i2 = (int)l;
                    char c = (char)i2;
                    if (this.entriesByChar.containsKey(Character.valueOf(c))) {
                        throw new IllegalStateException("double bound character: " + entry.getCharacter());
                    }
                    this.entriesByChar.put(Character.valueOf(c), entry);
                    fixed = true;
                }
                if (!fixed) {
                    throw new IllegalStateException("double bound character: " + entry.getCharacter());
                }
            } else {
                this.entriesByChar.put(Character.valueOf(entry.getCharacter()), entry);
            }
            for (String entity : entry.getEntities()) {
                if (this.entriesByEntity.containsKey(entity)) {
                    throw new IllegalStateException("double bound entity: " + entity);
                }
                this.entriesByEntity.put(entity, entry);
            }
        }
    }

    static {
        INSTANCE.init();
    }

    private class Entry {
        private final char character;
        private final String[] entities;
        private final String defaultName;

        public Entry(char character, String ... entities) {
            this.character = character;
            if (entities == null || entities.length < 1) {
                throw new IllegalArgumentException("a entity map entry requires at least on entity");
            }
            this.entities = entities;
            for (String entity : entities) {
                if (entity.length() < 2) {
                    throw new IllegalArgumentException("entities need at least 2 characters");
                }
                if (entity.charAt(0) != '&') {
                    throw new IllegalArgumentException("entity did not start with &");
                }
                if (entity.charAt(entity.length() - 1) == ';') continue;
                throw new IllegalArgumentException("entity did not end with ;");
            }
            this.defaultName = entities[0].substring(1, entities[0].length() - 1);
        }

        public final char getCharacter() {
            return this.character;
        }

        public final String[] getEntities() {
            return this.entities;
        }

        public final String getDefaultEntityName() {
            return this.defaultName;
        }
    }
}

