/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bndly.common.html.Attribute;
import org.bndly.common.html.Content;
import org.bndly.common.html.Entity;
import org.bndly.common.html.HTML;
import org.bndly.common.html.HTMLParsingException;
import org.bndly.common.html.Parser;
import org.bndly.common.html.PrettyPrintHandler;
import org.bndly.common.html.Tag;

public final class HTMLUtils {
    private HTMLUtils() {
    }

    public static void applyCSSOnBulletpoints(List<Content> content, boolean isInList, String bulletPointIcon) {
        if (content != null) {
            for (Content c : content) {
                if (!Tag.class.isInstance(c)) continue;
                Tag tag = (Tag)c;
                if ("ul".equals(tag.getName())) {
                    Attribute att = tag.getAttribute("class");
                    String cls = "list-" + bulletPointIcon;
                    if (att == null) {
                        tag.setAttribute("class", cls);
                    } else {
                        String v = att.getValue();
                        if (v == null) {
                            att.setValue(cls);
                        } else {
                            att.setValue(att.getValue() + " " + cls);
                        }
                    }
                    HTMLUtils.applyCSSOnBulletpoints(tag.getContent(), true, bulletPointIcon);
                    continue;
                }
                if ("li".equals(tag.getName()) && isInList) {
                    Tag spanTag = new Tag(tag);
                    spanTag.setName("span");
                    spanTag.setAttribute("class", "icon iconfont-" + bulletPointIcon);
                    spanTag.setContent(new ArrayList<Content>());
                    spanTag.getContent().add(new Entity(spanTag, "#8203"));
                    List<Content> liContent = tag.getContent();
                    if (liContent == null) {
                        liContent = new ArrayList<Content>();
                        tag.setContent(liContent);
                    }
                    liContent.add(0, spanTag);
                }
                HTMLUtils.applyCSSOnBulletpoints(tag.getContent(), false, bulletPointIcon);
            }
        }
    }

    public static void applyCSSOnUl(List<Content> content, String listType) {
        if (content != null) {
            for (Content c : content) {
                if (!Tag.class.isInstance(c)) continue;
                Tag tag = (Tag)c;
                if ("ul".equals(tag.getName())) {
                    Attribute att = tag.getAttribute("class");
                    String cls = "list-" + listType;
                    if (att == null) {
                        tag.setAttribute("class", cls);
                    } else {
                        String v = att.getValue();
                        if (v == null) {
                            att.setValue(cls);
                        } else {
                            att.setValue(att.getValue() + " " + cls);
                        }
                    }
                    HTMLUtils.applyCSSOnUl(tag.getContent(), listType);
                    continue;
                }
                HTMLUtils.applyCSSOnUl(tag.getContent(), listType);
            }
        }
    }

    public static HTML applyCSSOnHTML(HTML html, String cssClass) {
        List<Object> content = new ArrayList();
        if (html != null) {
            content = html.getContent();
        }
        for (Content c : content) {
            Tag tag;
            if (!Tag.class.isInstance(c) || !"p".equals((tag = (Tag)c).getName())) continue;
            HTMLUtils.appendCSSClassToTag(tag, cssClass);
        }
        return html;
    }

    public static String applyCSSOnHTMLString(String html, final String cssClass) {
        if (html == null || "".equals(html)) {
            return null;
        }
        PrettyPrintHandler lightFontHandler = new PrettyPrintHandler(){
            private int level = 0;

            @Override
            public void openedTag(Tag tag) {
                if (this.isOnRootLevel() && "p".equals(tag.getName())) {
                    HTMLUtils.appendCSSClassToTag(tag, cssClass);
                }
                super.openedTag(tag);
                ++this.level;
            }

            @Override
            public void closedTag(Tag tag) {
                super.closedTag(tag);
                --this.level;
            }

            private boolean isOnRootLevel() {
                return this.level == 0;
            }
        };
        try {
            new Parser(html).handler(lightFontHandler).parse();
            return lightFontHandler.getPrettyString();
        }
        catch (IOException | HTMLParsingException ex) {
            throw new IllegalStateException("could not reformat html", ex);
        }
    }

    private static void appendCSSClassToTag(Tag tag, String cssClass) {
        Attribute classAtt = tag.getAttribute("class");
        if (classAtt == null) {
            tag.setAttribute("class", cssClass);
        } else {
            String v = classAtt.getValue();
            if (v == null) {
                classAtt.setValue(cssClass);
            } else {
                classAtt.setValue(v + " " + cssClass);
            }
        }
    }
}

