/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.bndly.common.html.Attribute;
import org.bndly.common.html.Content;
import org.bndly.common.html.ContentContainer;
import org.bndly.common.html.DefaultHandler;
import org.bndly.common.html.DefaultParserConfig;
import org.bndly.common.html.Entity;
import org.bndly.common.html.HTML;
import org.bndly.common.html.HTMLParsingException;
import org.bndly.common.html.Parser;
import org.bndly.common.html.ParserConfig;
import org.bndly.common.html.ProxyContent;
import org.bndly.common.html.SelfClosingTag;
import org.bndly.common.html.Tag;
import org.bndly.common.html.Text;

public final class HTMLShortener {
    private HTMLShortener() {
    }

    public static String shorten(String inputHtml, int maxCharacters) throws HTMLParsingException {
        return HTMLShortener.shorten(inputHtml, maxCharacters, false, null);
    }

    public static String shortenAndKeepMarkup(String inputHtml, int maxCharacters) throws HTMLParsingException {
        return HTMLShortener.shorten(inputHtml, maxCharacters, true, null);
    }

    public static void shortenAndKeepMarkupOnHTML(HTML html, int maxCharacters, String appendAtEnd) throws HTMLParsingException {
        List<Content> content = html.getContent();
        Holder holder = new Holder();
        HTMLShortener.shortenContentList(null, content, 0, maxCharacters, appendAtEnd, holder);
        if (holder.getContent() != null) {
            Content c = holder.getContent();
            if (Text.class.isInstance(c)) {
                Text tmpText = (Text)c;
                if (!tmpText.getValue().endsWith(appendAtEnd)) {
                    tmpText.setValue(tmpText.getValue() + appendAtEnd);
                }
            } else if (Entity.class.isInstance(c) && holder.getContentContainer() != null) {
                ContentContainer container = holder.getContentContainer();
                List<Content> contentItems = container.getContent();
                Text t = new Text(container);
                t.setValue(appendAtEnd);
                int index = holder.getIndex();
                contentItems.add(index, t);
            }
        }
    }

    private static Content unwrap(Content content) {
        if (ProxyContent.class.isInstance(content)) {
            return HTMLShortener.unwrap(((ProxyContent)content).getContent());
        }
        return content;
    }

    private static int shortenContentList(ContentContainer parent, List<Content> content, int length, int maxCharacters, String appendAtEnd, final Holder holder) {
        if (content == null) {
            return length;
        }
        List toRemove = null;
        Text textToAppend = null;
        for (Content _c : content) {
            Content inspected;
            if (length >= maxCharacters) {
                toRemove = HTMLShortener.appendToList(_c, toRemove);
            }
            if ((inspected = HTMLShortener.unwrap(_c)) == null) continue;
            if (Text.class.isInstance(inspected)) {
                Text text = (Text)inspected;
                int originalLength = length;
                int newLength = length + text.getValue().length();
                boolean textWillBeRemovedCompletely = false;
                if (newLength > maxCharacters) {
                    String newText = HTMLShortener.cutTextAtLastSpace(text.getValue().substring(0, maxCharacters - length));
                    text.setValue(newText);
                    textWillBeRemovedCompletely = "".equals(newText);
                    length = maxCharacters;
                } else {
                    length = newLength;
                }
                if (length != maxCharacters) continue;
                if ("".equals(text.getValue().trim())) {
                    toRemove = HTMLShortener.appendToList(_c, toRemove);
                    if (holder.didAppendEndToken()) continue;
                    holder.setDidAppendEndToken(true);
                    HTMLShortener.reverseTraverse(text, new TraverseListener(){

                        @Override
                        public void onContent(int index, Content content, ContentContainer container) {
                            if (holder.getContent() != null) {
                                return;
                            }
                            boolean isEntity = Entity.class.isInstance(content);
                            boolean isText = Text.class.isInstance(content);
                            if (isEntity) {
                                holder.setContent(content);
                                holder.setContentContainer(container);
                                holder.setIndex(index);
                            } else if (isText && !"".equals(((Text)content).getValue().trim())) {
                                holder.setContent(content);
                                holder.setContentContainer(container);
                                holder.setIndex(index);
                            }
                        }
                    });
                    continue;
                }
                if (holder.didAppendEndToken()) continue;
                holder.setDidAppendEndToken(true);
                text.setValue(text.getValue() + appendAtEnd);
                continue;
            }
            if (Entity.class.isInstance(inspected)) {
                int newLength = length + 1;
                if (newLength > maxCharacters) {
                    length = maxCharacters;
                    toRemove = HTMLShortener.appendToList(_c, toRemove);
                    continue;
                }
                length = newLength;
                if (newLength != maxCharacters) continue;
                textToAppend = new Text(parent);
                textToAppend.setValue(appendAtEnd);
                continue;
            }
            if (Tag.class.isInstance(inspected)) {
                Tag tag = (Tag)inspected;
                List<Content> subContent = tag.getContent();
                length = HTMLShortener.shortenContentList(tag, subContent, length, maxCharacters, appendAtEnd, holder);
                continue;
            }
            if (SelfClosingTag.class.isInstance(inspected)) continue;
            throw new IllegalStateException("unsupported content");
        }
        if (toRemove != null) {
            content.removeAll(toRemove);
        }
        if (textToAppend != null) {
            content.add(textToAppend);
        }
        return length;
    }

    private static ContentContainer getRoot(ContentContainer contentContainer) {
        if (contentContainer == null) {
            return null;
        }
        if (contentContainer.getParent() != null) {
            return HTMLShortener.getRoot(contentContainer.getParent());
        }
        return contentContainer;
    }

    private static void reverseTraverse(Content content, TraverseListener listener) {
        Content c;
        int i;
        ContentContainer contentContainer = content.getParent();
        if (contentContainer == null) {
            return;
        }
        List<Content> contentList = contentContainer.getContent();
        int index = -1;
        for (i = contentList.size() - 1; i >= 0; --i) {
            c = contentList.get(i);
            if (ProxyContent.class.isInstance(c)) {
                c = ((ProxyContent)c).getContent();
            }
            if (c != content) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new IllegalStateException("content is not in content list of container");
        }
        for (i = index - 1; i >= 0; --i) {
            c = contentList.get(i);
            if (ProxyContent.class.isInstance(c)) {
                c = ((ProxyContent)c).getContent();
            }
            if (ContentContainer.class.isInstance(c)) {
                HTMLShortener.reverseTraverse((ContentContainer)c, listener);
            }
            listener.onContent(i, c, contentContainer);
        }
        HTMLShortener.reverseTraverse((Content)contentContainer, listener);
    }

    private static void reverseTraverse(ContentContainer contentContainer, TraverseListener listener) {
        List<Content> content = contentContainer.getContent();
        if (content != null) {
            for (int i = content.size() - 1; i >= 0; --i) {
                Content c = content.get(i);
                if (ProxyContent.class.isInstance(c)) {
                    c = ((ProxyContent)c).getContent();
                }
                if (ContentContainer.class.isInstance(c)) {
                    ContentContainer cc = (ContentContainer)c;
                    HTMLShortener.reverseTraverse(cc, listener);
                }
                listener.onContent(i, c, contentContainer);
            }
        }
    }

    private static List appendToList(Object o, List list) {
        if (list == null) {
            list = new ArrayList<Object>();
        }
        list.add(o);
        return list;
    }

    public static String shortenAndKeepMarkup(String inputHtml, int maxCharacters, String appendAtEnd) throws HTMLParsingException {
        return HTMLShortener.shorten(inputHtml, maxCharacters, true, appendAtEnd);
    }

    private static String shorten(String inputHtml, final int maxCharacters, final boolean keepMarkup, final String appendAtEnd) throws HTMLParsingException {
        try {
            final StringBuffer sb = new StringBuffer();
            final DefaultParserConfig config = new DefaultParserConfig();
            new Parser(inputHtml, (ParserConfig)config).handler(new DefaultHandler(){
                int l = 0;
                boolean complete = false;
                Stack<Tag> tagStack = new Stack();
                private boolean didAppendAtEnd;

                @Override
                public void onText(Text text) {
                    int length = text.getValue().length();
                    if (!this.complete) {
                        if (this.l + length >= maxCharacters) {
                            length = maxCharacters - this.l;
                            this.complete = true;
                        }
                        if (length == text.getValue().length()) {
                            sb.append(text.getValue());
                        } else {
                            String lastTxt = text.getValue().substring(0, length);
                            lastTxt = HTMLShortener.cutTextAtLastSpace(lastTxt);
                            sb.append(lastTxt);
                        }
                        this.l += length;
                    } else {
                        this.appendCompleteContent(appendAtEnd);
                    }
                }

                @Override
                public void onEntity(Entity entity) {
                    if (!this.complete) {
                        sb.append('&').append(entity.getName()).append(';');
                        ++this.l;
                        if (this.l == maxCharacters) {
                            this.complete = true;
                        }
                    } else {
                        this.appendCompleteContent(appendAtEnd);
                    }
                }

                @Override
                public void onSelfClosingTag(SelfClosingTag tag) {
                    if (keepMarkup) {
                        if (this.complete) {
                            return;
                        }
                        sb.append('<').append(tag.getName());
                        if (!config.isSelfClosingTag(tag.getName())) {
                            sb.append('/');
                        }
                        sb.append('>');
                    }
                }

                @Override
                public void openedTag(Tag tag) {
                    if (keepMarkup) {
                        if (this.complete) {
                            return;
                        }
                        this.tagStack.push(tag);
                        sb.append('<').append(tag.getName());
                        List<Attribute> attributes = tag.getAttributes();
                        if (attributes != null) {
                            for (Attribute attribute : attributes) {
                                sb.append(' ').append(attribute.getName());
                                if (attribute.getValue() == null) continue;
                                sb.append("=\"").append(attribute.getValue()).append('\"');
                            }
                        }
                        sb.append('>');
                    }
                }

                @Override
                public void closedTag(Tag tag) {
                    if (keepMarkup && !this.tagStack.isEmpty()) {
                        Tag t = this.tagStack.pop();
                        sb.append("</").append(t.getName()).append('>');
                    }
                }

                private void appendCompleteContent(String appendAtEnd2) {
                    if (appendAtEnd2 != null && this.complete && !this.didAppendAtEnd) {
                        sb.append(appendAtEnd2);
                        this.didAppendAtEnd = true;
                    }
                }
            }).parse();
            return sb.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String cutTextAtLastSpace(String lastTxt) {
        int idx = lastTxt.lastIndexOf(" ");
        if (idx > 0) {
            lastTxt = lastTxt.substring(0, idx);
        }
        return lastTxt;
    }

    private static interface TraverseListener {
        public void onContent(int var1, Content var2, ContentContainer var3);
    }

    private static final class Holder {
        private Content content;
        private ContentContainer contentContainer;
        private Integer index;
        private boolean didAppendEndToken;

        private Holder() {
        }

        public Content getContent() {
            return this.content;
        }

        public void setContent(Content content) {
            this.content = content;
        }

        public ContentContainer getContentContainer() {
            return this.contentContainer;
        }

        public void setContentContainer(ContentContainer contentContainer) {
            this.contentContainer = contentContainer;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public boolean didAppendEndToken() {
            return this.didAppendEndToken;
        }

        public void setDidAppendEndToken(boolean didAppendEndToken) {
            this.didAppendEndToken = didAppendEndToken;
        }
    }
}

