/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.util.List;
import org.bndly.common.html.Attribute;
import org.bndly.common.html.Content;
import org.bndly.common.html.DefaultHandler;
import org.bndly.common.html.Entity;
import org.bndly.common.html.ProxyContent;
import org.bndly.common.html.SelfClosingTag;
import org.bndly.common.html.Tag;
import org.bndly.common.html.Text;

public class PrettyPrintHandler
extends DefaultHandler {
    int indent = 0;
    final StringBuffer sb = new StringBuffer();
    private boolean skipNewLines;
    private boolean skipIndent;

    public PrettyPrintHandler skipNewLines() {
        this.skipNewLines = true;
        return this;
    }

    public PrettyPrintHandler skipIndent() {
        this.skipIndent = true;
        return this;
    }

    @Override
    public void onText(Text text) {
        this.printIndent();
        this.sb.append(text.getValue());
        if (!this.skipNewLines) {
            this.sb.append('\n');
        }
    }

    @Override
    public void onEntity(Entity entity) {
        this.printIndent();
        this.sb.append('&');
        this.sb.append(entity.getName());
        this.sb.append(';');
        if (!this.skipNewLines) {
            this.sb.append('\n');
        }
    }

    @Override
    public void onSelfClosingTag(SelfClosingTag tag) {
        this.printIndent();
        this.sb.append('<');
        this.sb.append(tag.getName());
        this.sb.append("/>");
        if (!this.skipNewLines) {
            this.sb.append('\n');
        }
    }

    @Override
    public void openedTag(Tag tag) {
        this.printIndent();
        this.sb.append('<');
        this.sb.append(tag.getName());
        List<Attribute> attributes = tag.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                String n = attribute.getName();
                if (n == null) continue;
                this.sb.append(' ').append(n);
                String v = attribute.getValue();
                if (v == null) continue;
                this.sb.append("=\"").append(v).append('\"');
            }
        }
        this.sb.append('>');
        if (!this.skipNewLines) {
            this.sb.append('\n');
        }
        ++this.indent;
    }

    @Override
    public void closedTag(Tag tag) {
        --this.indent;
        this.printIndent();
        this.sb.append("</");
        this.sb.append(tag.getName());
        this.sb.append('>');
        if (!this.skipNewLines) {
            this.sb.append('\n');
        }
    }

    private void printIndent() {
        if (this.skipIndent) {
            return;
        }
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append("  ");
        }
    }

    public String getPrettyString() {
        return this.sb.toString();
    }

    public static void printContent(List<Content> parsedContent, PrettyPrintHandler pph) {
        if (parsedContent == null) {
            return;
        }
        for (Content content : parsedContent) {
            PrettyPrintHandler.printContent(content, pph);
        }
    }

    public static void printContent(Content content, PrettyPrintHandler pph) {
        if (Text.class.isInstance(content)) {
            pph.onText((Text)content);
        } else if (Entity.class.isInstance(content)) {
            pph.onEntity((Entity)content);
        } else if (SelfClosingTag.class.isInstance(content)) {
            pph.onSelfClosingTag((SelfClosingTag)content);
        } else if (Tag.class.isInstance(content)) {
            Tag tag = (Tag)content;
            pph.openedTag(tag);
            PrettyPrintHandler.printContent(tag.getContent(), pph);
            pph.closedTag(tag);
        } else if (ProxyContent.class.isInstance(content)) {
            PrettyPrintHandler.printContent(((ProxyContent)content).getContent(), pph);
        }
    }
}

