/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class HTMLWriter {
    private final Writer writer;
    private final List<Element> rootElements = new ArrayList<Element>();
    private Element currentElement;

    public HTMLWriter(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        for (Element element : this.rootElements) {
            if (element.isRendered()) continue;
            element.render();
        }
    }

    public final HTMLWriter createElement(String type) {
        this.currentElement = new Element(type, this.currentElement);
        Element p = this.currentElement.getParent();
        if (p != null) {
            p.getChildElements().add(this.currentElement);
        } else {
            this.rootElements.add(this.currentElement);
        }
        return this;
    }

    public final HTMLWriter closeElement() {
        this.currentElement.closed = true;
        this.currentElement = this.currentElement.getParent();
        return this;
    }

    public final HTMLWriter setAttribute(String name, String value) {
        Attribute att = new Attribute(name, value);
        this.currentElement.getAttributes().add(att);
        return this;
    }

    public final HTMLWriter content(String value) {
        this.currentElement.getChildElements().add(new Content(value));
        return this;
    }

    private final class Content
    implements Renderable {
        private boolean rendered;
        private final String value;

        public Content(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isRendered() {
            return this.rendered;
        }

        @Override
        public void render() throws IOException {
            if (!this.rendered && this.value != null) {
                HTMLWriter.this.writer.append(this.value);
            }
            this.rendered = true;
        }
    }

    private final class Element
    implements Renderable {
        private boolean renderedStart;
        private boolean renderingComplete;
        private boolean closed = false;
        private final List<Attribute> attributes = new ArrayList<Attribute>();
        private final Element parent;
        private final List<Renderable> childElements = new ArrayList<Renderable>();
        private final String type;

        public Element(String type, Element parent) {
            this.type = type;
            this.parent = parent;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public List<Renderable> getChildElements() {
            return this.childElements;
        }

        public Element getParent() {
            return this.parent;
        }

        @Override
        public boolean isRendered() {
            return this.renderingComplete;
        }

        @Override
        public void render() throws IOException {
            if (!this.renderedStart) {
                HTMLWriter.this.writer.append('<').append(this.type);
                if (!this.attributes.isEmpty()) {
                    for (Attribute attribute : this.attributes) {
                        HTMLWriter.this.writer.append(' ');
                        attribute.render();
                    }
                }
                HTMLWriter.this.writer.append('>');
                this.renderedStart = true;
            }
            if (!this.childElements.isEmpty()) {
                for (Renderable element : this.childElements) {
                    if (this.renderingComplete || element.isRendered()) continue;
                    element.render();
                }
            }
            if (this.closed && !this.renderingComplete) {
                HTMLWriter.this.writer.append("</").append(this.type).append('>');
                this.renderingComplete = true;
            }
        }
    }

    private final class Attribute
    implements Renderable {
        private boolean rendered;
        private final String name;
        private final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isRendered() {
            return this.rendered;
        }

        @Override
        public void render() throws IOException {
            HTMLWriter.this.writer.append(this.getName());
            if (this.getValue() != null) {
                HTMLWriter.this.writer.append("=\"").append(this.getValue()).append('\"');
            }
            this.rendered = true;
        }
    }

    private static interface Renderable {
        public boolean isRendered();

        public void render() throws IOException;
    }
}

