/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.ip2location.impl;

import java.nio.ByteBuffer;
import org.bndly.shop.common.csv.parsing.CSVDataHandler;

class ByteBasedCSVDataHandler
implements CSVDataHandler {
    private final byte[] bytes;
    private final byte[] doubleValueBuffer = new byte[8];
    private final long columnIndexIPStart;
    private final long columnIndexIPEnd;
    private final long columnIndexLatitude;
    private final long columnIndexLongitude;
    String ipStart;
    String ipEnd;
    String lat;
    String lng;
    private long count;

    public ByteBasedCSVDataHandler(byte[] bytes, long columnIndexIPStart, long columnIndexIPEnd, long columnIndexLatitude, long columnIndexLongitude) {
        this.bytes = bytes;
        this.columnIndexIPStart = columnIndexIPStart;
        this.columnIndexIPEnd = columnIndexIPEnd;
        this.columnIndexLatitude = columnIndexLatitude;
        this.columnIndexLongitude = columnIndexLongitude;
    }

    public void documentOpened() {
        this.count = 0L;
    }

    public void rowOpened(long l) {
        this.ipStart = null;
        this.ipEnd = null;
        this.lat = null;
        this.lng = null;
    }

    public void value(long index, String value, boolean bln) {
        if (this.columnIndexIPStart == index) {
            this.ipStart = value;
        } else if (this.columnIndexIPEnd == index) {
            this.ipEnd = value;
        } else if (this.columnIndexLatitude == index) {
            this.lat = value;
        } else if (this.columnIndexLongitude == index) {
            this.lng = value;
        }
    }

    public void rowClosed(long l) {
        if (this.ipStart != null && this.ipEnd != null && this.lat != null && this.lng != null) {
            int s = this.parseUnsignedInt(this.ipStart);
            int e = this.parseUnsignedInt(this.ipEnd);
            double latitutde = Double.parseDouble(this.lat);
            double longitude = Double.parseDouble(this.lng);
            this.writeInt(s, 0);
            this.writeInt(e, 4);
            this.writeDouble(latitutde, 8);
            this.writeDouble(longitude, 16);
            ++this.count;
        }
    }

    public void documentClosed() {
    }

    private void writeInt(int intValue, int offset) {
        int shift = (int)(this.count * 24L + (long)offset);
        this.bytes[shift] = (byte)((intValue & 0xFF000000) >> 24);
        this.bytes[shift + 1] = (byte)((intValue & 0xFF0000) >> 16);
        this.bytes[shift + 2] = (byte)((intValue & 0xFF00) >> 8);
        this.bytes[shift + 3] = (byte)(intValue & 0xFF);
    }

    private void writeDouble(double doubleValue, int offset) {
        ByteBuffer.wrap(this.doubleValueBuffer).putDouble(doubleValue);
        int shift = (int)(this.count * 24L + (long)offset);
        System.arraycopy(this.doubleValueBuffer, 0, this.bytes, shift, this.doubleValueBuffer.length);
    }

    private int parseUnsignedInt(String numberString) {
        long ell = Long.parseLong(numberString, 10);
        if ((ell & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("value to big for an integer: " + numberString);
        }
        return (int)ell;
    }
}

