/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.ip2location.impl;

import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Arrays;
import org.bndly.common.ip2location.impl.IPBasedGeoLocatorImpl;
import org.bndly.common.lang.StopWatch;
import org.bndly.shop.common.csv.parsing.CSVDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntryCreatingCSVDataHandler
implements CSVDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EntryCreatingCSVDataHandler.class);
    private static final long IP_START = 0L;
    private static final long IP_END = 1L;
    private static final long COUNTRY_CODE = 2L;
    private static final long COUNTRY_NAME = 3L;
    private static final long STATE = 4L;
    private static final long CITY = 5L;
    private static final long LAT = 6L;
    private static final long LNG = 7L;
    private final Path get;
    private final IPBasedGeoLocatorImpl.Entry[] entries;
    String ipStart;
    String ipEnd;
    String country;
    String countryCode;
    String state;
    String city;
    String lat;
    String lng;
    private long count;
    private StopWatch stopWatch;
    private StopWatch intermediateStopWatch;

    public EntryCreatingCSVDataHandler(Path get, IPBasedGeoLocatorImpl.Entry[] entries) {
        this.get = get;
        this.entries = entries;
    }

    public void documentOpened() {
        this.stopWatch = new StopWatch().start();
        this.intermediateStopWatch = new StopWatch().start();
        LOG.info("started to parse the CSV at '{}'", (Object)this.get);
    }

    public void rowOpened(long index) {
        this.ipStart = null;
        this.ipEnd = null;
        this.country = null;
        this.city = null;
        this.lat = null;
        this.lng = null;
    }

    public void value(long index, String value, boolean quoted) {
        if (0L == index) {
            this.ipStart = value;
        } else if (1L == index) {
            this.ipEnd = value;
        } else if (2L == index) {
            this.countryCode = value;
        } else if (3L == index) {
            this.country = value;
        } else if (4L == index) {
            this.state = value;
        } else if (5L == index) {
            this.city = value;
        } else if (6L == index) {
            this.lat = value;
        } else if (7L == index) {
            this.lng = value;
        }
    }

    public void rowClosed(long index) {
        IPBasedGeoLocatorImpl.Entry entry;
        if (this.count == Long.MAX_VALUE) {
            throw new IllegalStateException("too many rows in CSV");
        }
        this.entries[(int)this.count] = entry = new IPBasedGeoLocatorImpl.Entry(new BigInteger(this.ipStart), new BigInteger(this.ipEnd), Double.valueOf(this.lat), Double.valueOf(this.lng), this.city, this.country, this.countryCode, this.state);
        ++this.count;
        if (this.count % 10000L == 0L) {
            this.intermediateStopWatch.stop();
            LOG.info("parsed 10000 entries in {}ms", (Object)this.intermediateStopWatch.getMillis());
            this.intermediateStopWatch.reset();
            this.intermediateStopWatch.start();
        }
    }

    public void documentClosed() {
        this.stopWatch.stop();
        LOG.info("finished parsing the CSV at '{}' in {}ms", (Object)this.get, (Object)this.stopWatch.getMillis());
        LOG.info("sorting the parsed data now");
        Arrays.sort(this.entries, IPBasedGeoLocatorImpl.Entry.IP_RANGE_COMPARATOR);
        LOG.info("sorted the parsed data");
    }
}

