/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.ip2location.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bndly.common.ip2location.IPBasedGeoLocator;
import org.bndly.common.ip2location.IPGeoLocation;
import org.bndly.common.ip2location.impl.ByteBasedCSVDataHandler;
import org.bndly.common.lang.StopWatch;
import org.bndly.shop.common.csv.parsing.CSVDataHandler;
import org.bndly.shop.common.csv.parsing.CSVParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IPBasedGeoLocator.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class IPBasedGeoLocatorImpl
implements IPBasedGeoLocator {
    private static final Logger LOG = LoggerFactory.getLogger(IPBasedGeoLocatorImpl.class);
    private String dataLocation;
    private ExecutorService executorService;
    private Future<byte[]> init;
    private long columnIndexIPStart;
    private long columnIndexIPEnd;
    private long columnIndexLatitude;
    private long columnIndexLongitude;

    @Activate
    public void activate(Configuration configuration) {
        this.dataLocation = configuration.dataLocation();
        this.columnIndexIPStart = configuration.columnIndexIPStart();
        this.columnIndexIPEnd = configuration.columnIndexIPEnd();
        this.columnIndexLatitude = configuration.columnIndexLatitude();
        this.columnIndexLongitude = configuration.columnIndexLongitude();
        this.initData();
    }

    public void initData() {
        if (this.dataLocation == null) {
            return;
        }
        final Path get = Paths.get(this.dataLocation, new String[0]);
        if (!Files.isRegularFile(get, new LinkOption[0])) {
            LOG.error("could not find ip2location data at {}", (Object)this.dataLocation);
            return;
        }
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        this.init = this.executorService.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws IOException {
                RowCountingCSVDataHandler rowCountingCSVDataHandler = new RowCountingCSVDataHandler();
                try (InputStream is = Files.newInputStream(get, StandardOpenOption.READ);){
                    new CSVParser().parse((InputStream)new BufferedInputStream(is), (CSVDataHandler)rowCountingCSVDataHandler);
                }
                LOG.info("the CSV at '{}' contains {} entries", (Object)get, (Object)rowCountingCSVDataHandler.getRowCount());
                long byteArraySize = rowCountingCSVDataHandler.getRowCount() * 24L;
                byte[] bytes = new byte[(int)byteArraySize];
                try (InputStream is = Files.newInputStream(get, StandardOpenOption.READ);){
                    StopWatch sw = new StopWatch().start();
                    System.out.println("parsing to bytes...");
                    new CSVParser().parse((InputStream)new BufferedInputStream(is), (CSVDataHandler)new ByteBasedCSVDataHandler(bytes, IPBasedGeoLocatorImpl.this.columnIndexIPStart, IPBasedGeoLocatorImpl.this.columnIndexIPEnd, IPBasedGeoLocatorImpl.this.columnIndexLatitude, IPBasedGeoLocatorImpl.this.columnIndexLongitude));
                    System.out.println("parsing to bytes done in " + sw.stop().getMillis() + "ms.");
                }
                return bytes;
            }
        });
    }

    @Deactivate
    public void deactivate() {
        if (this.init != null) {
            this.init.cancel(true);
            this.init = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    @Override
    public IPGeoLocation getGeoLocationByIPAddress(BigInteger ip) {
        if (this.init == null) {
            LOG.warn("ip2location could not be loaded during activation. therefore {} can not be resolved to a location", (Object)ip);
            return null;
        }
        try {
            byte[] entries = this.init.get();
            long longValue = ip.longValue();
            int ipInt = (int)((longValue & 0xFFFFFFFFFF000000L) >> 24);
            ipInt = ipInt << 8 | (int)((longValue & 0xFF0000L) >> 16);
            ipInt = ipInt << 8 | (int)((longValue & 0xFF00L) >> 8);
            ipInt = ipInt << 8 | (int)(longValue & 0xFFL);
            return this.search(entries, 0, entries.length / 24, ipInt);
        }
        catch (InterruptedException ex) {
            return null;
        }
        catch (ExecutionException ex) {
            LOG.error("could not get geo location, because initialization failed", (Throwable)ex);
            return null;
        }
    }

    private double toDouble(byte[] bytes, int pos) {
        return ByteBuffer.wrap(bytes, pos, 8).getDouble();
    }

    private int toInt(byte[] bytes, int pos) {
        return (bytes[pos + 0] & 0xFF) << 24 | (bytes[pos + 1] & 0xFF) << 16 | (bytes[pos + 2] & 0xFF) << 8 | bytes[pos + 3] & 0xFF;
    }

    private static int compareUnsigned(int x, int y) {
        return (x += Integer.MIN_VALUE) < (y += Integer.MIN_VALUE) ? -1 : (x == y ? 0 : 1);
    }

    IPGeoLocation search(byte[] bytes, int left, int right, int ip) {
        if (left >= right) {
            return null;
        }
        int pos = left + (right - left) / 2;
        int shift = pos * 24;
        int ipStart = this.toInt(bytes, shift);
        if (IPBasedGeoLocatorImpl.compareUnsigned(ipStart, ip) > 0) {
            return this.search(bytes, left, pos, ip);
        }
        int ipEnd = this.toInt(bytes, shift + 4);
        if (IPBasedGeoLocatorImpl.compareUnsigned(ipEnd, ip) < 0) {
            return this.search(bytes, pos + 1, right, ip);
        }
        final double lat = this.toDouble(bytes, shift + 8);
        final double lng = this.toDouble(bytes, shift + 16);
        return new IPGeoLocation(){

            @Override
            public double getLatitude() {
                return lat;
            }

            @Override
            public double getLongitude() {
                return lng;
            }
        };
    }

    Entry search(Entry[] entries, int left, int right, BigInteger ip) {
        if (left >= right) {
            return null;
        }
        int pos = left + (right - left) / 2;
        Entry e = entries[pos];
        if (e.ipStart.subtract(ip).signum() == 1) {
            return this.search(entries, left, pos, ip);
        }
        if (e.ipEnd.subtract(ip).signum() == -1) {
            return this.search(entries, pos + 1, right, ip);
        }
        return e;
    }

    @Override
    public IPGeoLocation getGeoLocationByIPAddress(String ipAddressString) {
        try {
            InetAddress address = InetAddress.getByName(ipAddressString);
            if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isSiteLocalAddress()) {
                return null;
            }
            if (Inet4Address.class.isInstance(address)) {
                return this.getGeoLocationByIPAddress(new BigInteger(((Inet4Address)address).getAddress()));
            }
            if (Inet6Address.class.isInstance(address)) {
                return this.getGeoLocationByIPAddress(new BigInteger(((Inet6Address)address).getAddress()));
            }
            return null;
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    void setDataLocation(String dataLocation) {
        this.dataLocation = dataLocation;
    }

    public void setColumnIndexIPStart(long columnIndexIPStart) {
        this.columnIndexIPStart = columnIndexIPStart;
    }

    public void setColumnIndexIPEnd(long columnIndexIPEnd) {
        this.columnIndexIPEnd = columnIndexIPEnd;
    }

    public void setColumnIndexLatitude(long columnIndexLatitude) {
        this.columnIndexLatitude = columnIndexLatitude;
    }

    public void setColumnIndexLongitude(long columnIndexLongitude) {
        this.columnIndexLongitude = columnIndexLongitude;
    }

    private static class RowCountingCSVDataHandler
    implements CSVDataHandler {
        private long row = 0L;

        private RowCountingCSVDataHandler() {
        }

        public void documentOpened() {
        }

        public void rowOpened(long l) {
        }

        public void value(long l, String string, boolean bln) {
        }

        public void rowClosed(long l) {
            ++this.row;
        }

        public void documentClosed() {
        }

        public long getRowCount() {
            return this.row;
        }
    }

    static class Entry
    implements IPGeoLocation {
        static Comparator<Entry> IP_RANGE_COMPARATOR = new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.ipStart.subtract(o2.ipStart).signum();
            }
        };
        private final BigInteger ipStart;
        private final BigInteger ipEnd;
        private final double lat;
        private final double lng;
        private final String city;
        private final String country;
        private final String countryCode;
        private final String state;

        public Entry(BigInteger ipStart, BigInteger ipEnd, double lat, double lng, String city, String country, String countryCode, String state) {
            this.ipStart = ipStart;
            this.ipEnd = ipEnd;
            this.lat = lat;
            this.lng = lng;
            this.city = city;
            this.country = country;
            this.countryCode = countryCode;
            this.state = state;
        }

        @Override
        public double getLatitude() {
            return this.lat;
        }

        @Override
        public double getLongitude() {
            return this.lng;
        }

        public String toString() {
            return this.lat + "," + this.lng;
        }
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(name="Data location", description="Path to the IP2Location CSV with the address mappings")
        public String dataLocation();

        @AttributeDefinition(name="Column index IP start", description="Index of the column in the CSV, that contains the start IP of the IP range")
        public long columnIndexIPStart() default 0L;

        @AttributeDefinition(name="Column index IP end", description="Index of the column in the CSV, that contains the end IP of the IP range")
        public long columnIndexIPEnd() default 1L;

        @AttributeDefinition(name="Column index latitude", description="Index of the column in the CSV, that contains the latitude of the IP range location")
        public long columnIndexLatitude() default 2L;

        @AttributeDefinition(name="Column index longitude", description="Index of the column in the CSV, that contains the longitude of the IP range location")
        public long columnIndexLongitude() default 3L;
    }
}

