/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.osgi.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.ServiceReference;

public final class DictionaryAdapter {
    private final Dictionary<String, Object> props;
    private final boolean emptyStringAsNull;

    public final Dictionary<String, Object> getProps() {
        return this.props;
    }

    public DictionaryAdapter(ServiceReference serviceReference) {
        this(serviceReference, false);
    }

    public DictionaryAdapter(ServiceReference serviceReference, boolean emptyStringAsNull) {
        String[] keys = serviceReference.getPropertyKeys();
        this.props = new Hashtable<String, Object>(keys.length);
        for (String key : keys) {
            this.props.put(key, serviceReference.getProperty(key));
        }
        this.emptyStringAsNull = emptyStringAsNull;
    }

    public DictionaryAdapter(Dictionary<String, Object> props, boolean emptyStringAsNull) {
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        this.props = props;
        this.emptyStringAsNull = emptyStringAsNull;
    }

    public DictionaryAdapter(Dictionary<String, Object> props) {
        this(props, false);
    }

    public final DictionaryAdapter emptyStringAsNull() {
        return new DictionaryAdapter(this.props, true);
    }

    private Object filterEmptyStringValue(Object value) {
        if (String.class.isInstance(value) && this.emptyStringAsNull && ((String)value).isEmpty()) {
            return null;
        }
        return value;
    }

    public final Collection<String> getStringCollection(String key, String ... defaultValues) {
        Object raw = this.get(key);
        if (String[].class.isInstance(raw)) {
            defaultValues = (String[])raw;
        } else if (String.class.isInstance(raw)) {
            defaultValues = ((String)raw).split(",");
        }
        if (defaultValues == null || defaultValues.length == 0) {
            return null;
        }
        return Arrays.asList(defaultValues);
    }

    public final String getString(String key) {
        return this.getString(key, null);
    }

    public final String getString(String key, String defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        Object val = this.filterEmptyStringValue(this.props.get(key));
        if (String.class.isInstance(val)) {
            return (String)val;
        }
        return defaultValue;
    }

    public final Long getLong(String key) {
        return this.getLong(key, null);
    }

    public final Long getLong(String key, Long defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        Object val = this.filterEmptyStringValue(this.props.get(key));
        if (Long.class.isInstance(val)) {
            return (Long)val;
        }
        if (Number.class.isInstance(val)) {
            return ((Number)val).longValue();
        }
        if (String.class.isInstance(val)) {
            try {
                return Long.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public final Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public final Integer getInteger(String key, Integer defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        Object val = this.props.get(key);
        if (Integer.class.isInstance(val)) {
            return (Integer)val;
        }
        if (Number.class.isInstance(val)) {
            return ((Number)val).intValue();
        }
        if (String.class.isInstance(val)) {
            try {
                return Integer.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public final Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public final Float getFloat(String key, Float defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        Object val = this.filterEmptyStringValue(this.props.get(key));
        if (Float.class.isInstance(val)) {
            return (Float)val;
        }
        if (Number.class.isInstance(val)) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (String.class.isInstance(val)) {
            try {
                return Float.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public final Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public final Double getDouble(String key, Double defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        Object val = this.filterEmptyStringValue(this.props.get(key));
        if (Double.class.isInstance(val)) {
            return (Double)val;
        }
        if (Number.class.isInstance(val)) {
            return ((Number)val).doubleValue();
        }
        if (String.class.isInstance(val)) {
            try {
                return Double.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public final Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public final Boolean getBoolean(String key, Boolean defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        Object val = this.filterEmptyStringValue(this.props.get(key));
        if (Boolean.class.isInstance(val)) {
            return (Boolean)val;
        }
        if (String.class.isInstance(val)) {
            return Boolean.parseBoolean((String)val);
        }
        return defaultValue;
    }

    public final Object get(Object key) {
        if (this.props == null) {
            return null;
        }
        return this.filterEmptyStringValue(this.props.get(key));
    }
}

