/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.osgi.util;

import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DictionaryAsMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Dictionary<K, V> dictionary;

    public DictionaryAsMap(Dictionary<K, V> dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> set = new LinkedHashSet<Map.Entry<K, V>>();
        Enumeration<K> keyEnum = this.dictionary.keys();
        while (keyEnum.hasMoreElements()) {
            final K key = keyEnum.nextElement();
            set.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return DictionaryAsMap.this.dictionary.get(key);
                }

                @Override
                public V setValue(V value) {
                    Object old = DictionaryAsMap.this.dictionary.get(key);
                    DictionaryAsMap.this.dictionary.put(key, value);
                    return old;
                }
            });
        }
        return set;
    }
}

