/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.osgi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bndly.common.osgi.util.DictionaryAdapter;

public class DictionaryToPropertiesAdapter
extends Properties {
    private final DictionaryAdapter dictionaryAdapter;

    public DictionaryToPropertiesAdapter(DictionaryAdapter dictionaryAdapter) {
        if (dictionaryAdapter == null) {
            throw new IllegalArgumentException("dictionaryAdapter is not allowed to be null");
        }
        this.dictionaryAdapter = dictionaryAdapter;
    }

    public final Properties toStringProperties() {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entrySet : this.entrySet()) {
            Object k = entrySet.getKey();
            Object val = entrySet.getValue();
            if (val == null || !String.class.isInstance(k)) continue;
            String key = (String)k;
            String value = (String)(String.class.isInstance(val) ? val : val.toString());
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entrySet : this.entrySet()) {
            Object val = entrySet.getValue();
            if (val == null) continue;
            values.add(val);
        }
        return Collections.enumeration(values);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        LinkedHashSet<Map.Entry<Object, Object>> set = new LinkedHashSet<Map.Entry<Object, Object>>();
        Set<Object> ks = this.keySet();
        for (final Object key : ks) {
            final Object val = this.dictionaryAdapter.get(key);
            if (val == null) continue;
            set.add(new Map.Entry<Object, Object>(){

                @Override
                public Object getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return val;
                }

                @Override
                public Object setValue(Object value) {
                    DictionaryToPropertiesAdapter.this.dictionaryAdapter.getProps().put((String)key, value);
                    return value;
                }
            });
        }
        return set;
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> set = new HashSet<Object>();
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            Object nextElement = keys.nextElement();
            if (this.get(nextElement) == null) continue;
            set.add(nextElement);
        }
        return set;
    }

    @Override
    public synchronized int size() {
        return this.keySet().size();
    }

    @Override
    public synchronized Enumeration keys() {
        Enumeration<String> tmp = this.dictionaryAdapter.getProps().keys();
        ArrayList<String> nonNullKeys = new ArrayList<String>();
        while (tmp.hasMoreElements()) {
            String nextElement = tmp.nextElement();
            if (this.dictionaryAdapter.get(nextElement) == null) continue;
            nonNullKeys.add(nextElement);
        }
        return Collections.enumeration(nonNullKeys);
    }

    @Override
    public synchronized Object get(Object key) {
        return this.dictionaryAdapter.get(key);
    }

    @Override
    public String getProperty(String key) {
        return this.dictionaryAdapter.getString(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.dictionaryAdapter.getString(key, defaultValue);
    }
}

