/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.osgi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MultipleServiceTracker
extends ServiceTracker {
    private final CompiledDependency[] dependencies;
    private final Map<CompiledDependency, Object> serviceByDependency = new HashMap<CompiledDependency, Object>();
    private final ReadWriteLock serviceByDependencyLock = new ReentrantReadWriteLock();
    private boolean ready;
    private final Callback callback;
    private final Wiring wiring;

    private MultipleServiceTracker(BundleContext context, Callback callback, Filter filter, CompiledDependency ... dependencies) {
        super(context, filter, null);
        this.dependencies = dependencies;
        this.callback = callback;
        this.ready = false;
        this.wiring = new Wiring(){

            @Override
            public void wire(Object target) {
                for (Map.Entry entry : MultipleServiceTracker.this.serviceByDependency.entrySet()) {
                    CompiledDependency key = (CompiledDependency)entry.getKey();
                    Object value = entry.getValue();
                    Dependency dep = key.getDependency();
                    if (!(dep instanceof WiringDependency)) continue;
                    ((WiringDependency)dep).wire(target, value);
                }
            }
        };
    }

    public void close() {
        this.serviceByDependencyLock.writeLock().lock();
        try {
            this.fireDestroy();
        }
        finally {
            this.serviceByDependencyLock.writeLock().unlock();
        }
        super.close();
    }

    public static MultipleServiceTracker newInstance(BundleContext bundleContext, Callback callback, Dependency ... dependencies) throws InvalidSyntaxException {
        CompiledDependency[] compiledDependencies = new CompiledDependency[dependencies.length];
        StringBuilder sb = new StringBuilder();
        sb.append("(|");
        int i = 0;
        for (final Dependency dependency : dependencies) {
            String depLdap = dependency.toLdapFilter();
            final Filter depFilter = bundleContext.createFilter(depLdap);
            compiledDependencies[i] = new CompiledDependency(){

                @Override
                public Dependency getDependency() {
                    return dependency;
                }

                @Override
                public Filter getFilter() {
                    return depFilter;
                }
            };
            sb.append(depLdap);
            ++i;
        }
        sb.append(")");
        return new MultipleServiceTracker(bundleContext, callback, bundleContext.createFilter(sb.toString()), compiledDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        this.serviceByDependencyLock.writeLock().lock();
        try {
            Object service = super.addingService(reference);
            for (CompiledDependency dependency : this.dependencies) {
                if (!dependency.getFilter().match(reference)) continue;
                this.serviceByDependency.put(dependency, service);
                this.fireReady();
                Object object = service;
                return object;
            }
            Object object = service;
            return object;
        }
        finally {
            this.serviceByDependencyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        this.serviceByDependencyLock.writeLock().lock();
        try {
            for (CompiledDependency dependency : this.dependencies) {
                Object trackedItem;
                if (!dependency.getFilter().match(reference) || (trackedItem = this.serviceByDependency.get(dependency)) != service) continue;
                this.fireDestroy();
                this.serviceByDependency.remove(dependency);
            }
        }
        finally {
            this.serviceByDependencyLock.writeLock().unlock();
        }
    }

    private void fireDestroy() {
        if (this.serviceByDependency.size() != this.dependencies.length) {
            return;
        }
        if (this.ready) {
            this.ready = false;
            try {
                this.callback.onDestroy(this.context);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to fire destroy event", e);
            }
        }
    }

    private void fireReady() {
        if (this.serviceByDependency.size() != this.dependencies.length) {
            return;
        }
        if (!this.ready) {
            this.ready = true;
            try {
                this.callback.onReady(this.context, this.wiring);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to fire ready event", e);
            }
        }
    }

    public static <V> TypedDependency<V> serviceInterfaceDependency(Class<V> serviceInterface) {
        return MultipleServiceTracker.serviceInterfaceDependency(serviceInterface, null);
    }

    public static <V> TypedDependency<V> serviceInterfaceDependency(final Class<V> serviceInterface, final String furtherFilter) {
        return new TypedDependency<V>(){

            @Override
            public String toLdapFilter() {
                if (furtherFilter == null) {
                    return "(objectClass=" + serviceInterface.getName() + ")";
                }
                return "(&(objectClass=" + serviceInterface.getName() + ")" + furtherFilter + ")";
            }

            @Override
            public <T> WiringDependency wire(final Setter<T, V> setter) {
                final 3 that = this;
                return new WiringDependency<V>(){

                    @Override
                    public String toLdapFilter() {
                        return that.toLdapFilter();
                    }

                    @Override
                    public void wire(Object target, V trackedService) {
                        setter.set(target, trackedService);
                    }
                };
            }
        };
    }

    public static interface Callback {
        public void onReady(BundleContext var1, Wiring var2) throws Exception;

        public void onDestroy(BundleContext var1) throws Exception;
    }

    public static interface Wiring {
        public void wire(Object var1);
    }

    public static interface TypedDependency<V>
    extends Dependency {
        public <T> WiringDependency<V> wire(Setter<T, V> var1);
    }

    public static interface WiringDependency<V>
    extends Dependency {
        public void wire(Object var1, V var2);
    }

    public static interface Setter<T, V> {
        public void set(T var1, V var2);
    }

    public static interface Dependency {
        public String toLdapFilter();
    }

    private static interface CompiledDependency {
        public Dependency getDependency();

        public Filter getFilter();
    }
}

