/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.osgi.util;

public final class ServicePidUtil {
    private ServicePidUtil() {
    }

    public static PID parseFileName(String pidFileName) {
        int endOfPid = pidFileName.lastIndexOf(46);
        String pidTmp = pidFileName.substring(0, endOfPid);
        return ServicePidUtil.parsePid(pidTmp);
    }

    public static PID parsePid(String pidWithoutFileExtension) {
        String pid;
        String factoryPid;
        int n = pidWithoutFileExtension.indexOf(45);
        if (n > 0) {
            factoryPid = pidWithoutFileExtension.substring(n + 1);
            pid = pidWithoutFileExtension.substring(0, n);
        } else {
            factoryPid = null;
            pid = pidWithoutFileExtension;
        }
        return new PID(){

            @Override
            public String getPid() {
                return pid;
            }

            @Override
            public String getFactoryPid() {
                return factoryPid;
            }

            public String toString() {
                return "PID: " + this.getPid() + " FactoryPID: " + this.getFactoryPid();
            }
        };
    }

    public static interface PID {
        public String getPid();

        public String getFactoryPid();
    }
}

