/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.osgi.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class ServiceRegistrationBuilder<E> {
    private final E service;
    private final Class<E> serviceInterface;
    private final List<Class> serviceInterfaces = new ArrayList<Class>();
    private final Dictionary<String, Object> props = new Hashtable<String, Object>();

    private ServiceRegistrationBuilder(Class<E> serviceInterface, E service) {
        if (service == null) {
            throw new IllegalArgumentException("service is not allowed to be null");
        }
        this.service = service;
        if (serviceInterface == null) {
            throw new IllegalArgumentException("serviceInterface is not allowed to be null");
        }
        this.serviceInterface = serviceInterface;
    }

    public static <F> ServiceRegistrationBuilder<F> newInstance(Class<F> serviceInterface, F service) {
        return new ServiceRegistrationBuilder<F>(serviceInterface, service);
    }

    public static <F> ServiceRegistrationBuilder<F> newInstance(F service) {
        Class<?> serviceInterface = service.getClass();
        return ServiceRegistrationBuilder.newInstance(serviceInterface, service);
    }

    public final ServiceRegistrationBuilder serviceInterface(Class<?> serviceInterface) {
        if (!serviceInterface.isInstance(this.service)) {
            throw new IllegalArgumentException("service is not implementing " + serviceInterface.getName());
        }
        this.serviceInterfaces.add(serviceInterface);
        return this;
    }

    public final ServiceRegistrationBuilder<E> pid(String pid) {
        return this.property("service.pid", pid);
    }

    public final ServiceRegistrationBuilder<E> property(String property, Object value) {
        this.props.put(property, value);
        return this;
    }

    public ServiceRegistration<E> register(BundleContext context) {
        if (this.props.get("service.pid") == null) {
            this.pid(this.serviceInterface.getName());
        }
        if (this.serviceInterfaces.isEmpty()) {
            ServiceRegistration reg = context.registerService(this.serviceInterface, this.service, this.props);
            return reg;
        }
        String[] interfacesTemp = new String[this.serviceInterfaces.size()];
        for (int i = 0; i < this.serviceInterfaces.size(); ++i) {
            Class get = this.serviceInterfaces.get(i);
            interfacesTemp[i] = get.getName();
        }
        ServiceRegistration reg = context.registerService(interfacesTemp, this.service, this.props);
        return reg;
    }
}

