/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.varnish;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.bndly.common.osgi.util.DictionaryAdapter;
import org.bndly.common.varnish.PurgeRequestResponseHandler;
import org.bndly.rest.api.PathCoder;
import org.bndly.rest.api.ResourceURI;
import org.bndly.rest.api.ResourceURIParser;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Cache.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(factory=true, ocd=Configuration.class)
public class Cache {
    private static final Logger LOG = LoggerFactory.getLogger(Cache.class);
    private static final PathCoder PATH_CODER = new PathCoder.UTF8();
    @Reference(name="httpClient")
    private HttpClient httpClient;
    @Reference(name="purgeRequestResponseHandler")
    private PurgeRequestResponseHandler purgeRequestResponseHandler;
    private String scheme;
    private String host;
    private int port;
    private String urlPrefix;

    @Activate
    public void activate(ComponentContext componentContext) {
        DictionaryAdapter da = new DictionaryAdapter(componentContext.getProperties());
        this.scheme = da.getString("scheme", "http");
        this.host = da.getString("host", "localhost");
        this.port = da.getLong("port", Long.valueOf(8079L)).intValue();
        this.urlPrefix = this.scheme + "://" + this.host + ":" + this.port;
    }

    public void flushPaths(Iterable<String> pathsWithExtension) {
        for (String pathToFlush : pathsWithExtension) {
            LOG.debug("flushing {}", (Object)pathToFlush);
            String url = this.urlPrefix + Cache.escapeSpecialCharactersToProperURL(pathToFlush);
            try {
                for (final HttpRequestBase purgeRequest : this.purgeRequestResponseHandler.createPurgeRequests(pathToFlush, url)) {
                    Boolean purged = (Boolean)this.httpClient.execute((HttpUriRequest)purgeRequest, (ResponseHandler)new ResponseHandler<Boolean>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Boolean handleResponse(HttpResponse hr) throws ClientProtocolException, IOException {
                            HttpEntity entity = hr.getEntity();
                            try {
                                Boolean bl = Cache.this.purgeRequestResponseHandler.isPurgeSuccessResponse(hr, purgeRequest);
                                return bl;
                            }
                            finally {
                                if (entity != null) {
                                    EntityUtils.consumeQuietly((HttpEntity)entity);
                                }
                            }
                        }
                    });
                    if (purged.booleanValue()) {
                        LOG.debug("flushed {}", (Object)pathToFlush);
                        continue;
                    }
                    LOG.warn("could not flush {} for unknown reasons", (Object)pathToFlush);
                }
            }
            catch (IOException e) {
                LOG.error("could not flush cache for path " + pathToFlush + " due to IO issues", (Throwable)e);
            }
        }
    }

    public static String escapeSpecialCharactersToProperURL(String path) {
        ResourceURI resourceURI = new ResourceURIParser(PATH_CODER, path).parse().getResourceURI();
        return resourceURI.asString();
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(name="Name", description="The name to use in order to reference this cache implementation")
        public String name() default "default";

        @AttributeDefinition(name="Cache URI scheme", description="The URI scheme to contact the cache.")
        public String scheme() default "http";

        @AttributeDefinition(name="Cache URI host", description="The URI host to contact the cache.")
        public String host() default "localhost";

        @AttributeDefinition(name="Cache URI port", description="The URI port to contact the cache.")
        public int port() default 8079;

        @AttributeDefinition(name="HttpClient PID", description="The PID of the HttpClient to use to contact the cache")
        public String httpClient_target() default "(service.pid=org.apache.http.client.HttpClient.varnish)";

        @AttributeDefinition(name="Purge request/response handler", description="An OSGI filter expression to access the handler, that builds purge requests and evaluates purge responses.")
        public String purgeRequestResponseHandler_target() default "(component.name=org.bndly.common.varnish.DefaultPurgeRequestResponseHandler)";
    }
}

