/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.document.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.bndly.document.xml.XContainer;
import org.bndly.document.xml.XDocument;
import org.bndly.document.xml.XVisualObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentReader {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentReader.class);

    public XDocument read(String file) {
        File f = new File(file);
        if (!f.exists()) {
            throw new RuntimeException("could not read " + file + " because it does not exist.");
        }
        try {
            FileInputStream is = new FileInputStream(f);
            return this.readXML(XDocument.class, is);
        }
        catch (FileNotFoundException e) {
            LOG.error("could not read file from provided path: " + file, (Throwable)e);
            throw new IllegalStateException("could not open inputstream from file " + file);
        }
    }

    public XDocument read(InputStream is) {
        XDocument xdoc = this.readXML(XDocument.class, is);
        this.setParentContainerOnChildsOf(xdoc);
        return xdoc;
    }

    private void setParentContainerOnChildsOf(XContainer c) {
        List<XVisualObject> items = c.getItems();
        if (items != null) {
            for (XVisualObject xVisualObject : items) {
                xVisualObject.setOwnerContainer(c);
                if (!XContainer.class.isAssignableFrom(xVisualObject.getClass())) continue;
                this.setParentContainerOnChildsOf((XContainer)xVisualObject);
            }
        }
    }

    private <T> T readXML(Class<T> type, InputStream is) {
        if (is != null) {
            try {
                JAXBContext context = null;
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                XMLReader xmlReader = spf.newSAXParser().getXMLReader();
                InputSource inputSource = new InputSource(is);
                SAXSource source = new SAXSource(xmlReader, inputSource);
                Unmarshaller unmarshaller = context.createUnmarshaller();
                Object configurations = unmarshaller.unmarshal((Source)source);
                if (configurations == null) {
                    return null;
                }
                return type.cast(configurations);
            }
            catch (JAXBException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("could not set up JAXB context", e);
            }
        }
        throw new IllegalStateException("no inputstream provided to read XML data");
    }
}

