/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf;

import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrintingObjectImpl
implements PrintingObject {
    private static final Logger LOG = LoggerFactory.getLogger(PrintingObject.class);
    private final long id;
    private String itemId;
    private final PrintingObject owner;
    private final PrintingContext context;

    protected PrintingObjectImpl(PrintingContext context, PrintingObject owner) {
        if (context == null) {
            throw new IllegalArgumentException("context is not allowed to be empty");
        }
        this.context = context;
        if (owner == null) {
            throw new IllegalArgumentException("owner is not allowed to be empty");
        }
        this.owner = owner;
        this.id = context.plusplus();
    }

    @Override
    public final PrintingContext getContext() {
        return this.context;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final String getItemId() {
        return this.itemId;
    }

    public final void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public final PrintingObject getOwner() {
        return this.owner;
    }

    @Override
    public final boolean is(Class<? extends PrintingObject> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public final <T extends PrintingObject> T as(Class<T> type) {
        return (T)((PrintingObject)type.cast(this));
    }
}

