/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.visualobject;

import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.style.Overflows;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.TableColumn;
import org.bndly.pdf.visualobject.VisualObject;

public class Table
extends Container {
    public Table(PrintingContext context, PrintingObject owner) {
        super(context, owner);
        this.setLayout(this.getContext().createTableLayout(this));
    }

    public int getRowCount() {
        int max = 0;
        List<VisualObject> items = this.getItems();
        if (items != null) {
            for (VisualObject visualObject : this.getItems()) {
                Container c = (Container)visualObject;
                List<VisualObject> rows = c.getItems();
                if (rows == null || max >= rows.size()) continue;
                max = rows.size();
            }
        }
        return max;
    }

    public double getRowHeightForRow(int i) {
        double max = 0.0;
        List<VisualObject> items = this.getItems();
        if (items != null) {
            for (VisualObject visualObject : this.getItems()) {
                VisualObject cell;
                Double h;
                Container c = (Container)visualObject;
                List<VisualObject> rows = c.getItems();
                if (rows == null || rows.size() <= i || !((h = (cell = rows.get(i)).getHeight()) > max)) continue;
                max = h;
            }
        }
        return max;
    }

    @Override
    public void overflowVerticalInto(Container overflowToContainer, Double maxHeight) {
        Style cStyle = this.getCalculatedStyle();
        if (cStyle != null) {
            String overflowRaw = (String)cStyle.get("overflow");
            Overflows overflow = null;
            if (overflowRaw != null) {
                overflow = Overflows.valueOf(overflowRaw);
            }
            if (overflow != null && overflow.equals((Object)Overflows.split)) {
                int i;
                int rowCount = this.getRowCount();
                double tmp = 0.0;
                boolean found = false;
                for (i = 0; i < rowCount; ++i) {
                    if (!((tmp += this.getRowHeightForRow(i)) > maxHeight)) continue;
                    ++i;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalStateException("actually the table " + this.getItemId() + " did not require to be split. what happened here?");
                }
                if (i > 0) {
                    int rowsToMove = rowCount - i + 1;
                    Table overflowToTable = this.copyToWithoutChildren(overflowToContainer).as(Table.class);
                    overflowToContainer.add(overflowToTable);
                    List<TableColumn> columns = this.getItems(TableColumn.class);
                    for (TableColumn rawColumn : columns) {
                        TableColumn clonedColumn = rawColumn.copyToWithoutChildren(overflowToTable).as(TableColumn.class);
                        overflowToTable.add(clonedColumn);
                        List<VisualObject> rows = rawColumn.getItems();
                        int firstRowIndexToMove = i - 1;
                        if (rows == null || rows.size() <= firstRowIndexToMove) continue;
                        for (int j = firstRowIndexToMove; j < rows.size(); ++j) {
                            clonedColumn.add(rows.get(j));
                        }
                    }
                    this.setHeight(maxHeight);
                    return;
                }
            }
        }
        super.overflowVerticalInto(overflowToContainer, maxHeight);
    }

    @Override
    public Table copyToWithoutChildren(VisualObject owner) {
        Table copyTable = this.getContext().createTable(owner);
        return this.copyStyleClassesTo(copyTable);
    }

    @Override
    public Table copyTo(VisualObject owner) {
        Table copyContainer = this.getContext().createTable(owner);
        List<VisualObject> subs = this.getItems();
        if (subs != null) {
            for (VisualObject sub : subs) {
                sub.copyTo(copyContainer);
            }
        }
        return copyContainer;
    }
}

