/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.visualobject;

import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.VisualObject;

public class Text
extends VisualObject {
    private String value;

    public Text(PrintingContext context, PrintingObject owner) {
        super(context, owner);
    }

    @Override
    public Double getWidth() {
        return this.getContext().getTextSizeStrategy().calculateWidthForText(this);
    }

    @Override
    public Double getHeight() {
        return this.getContext().getTextSizeStrategy().calculateHeightForText(this);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    protected String asString() {
        return super.asString() + " : " + this.value;
    }

    public Double getFontSize() {
        Style style = this.getCalculatedStyle();
        return (Double)style.get("font-size");
    }

    @Override
    public Text copyTo(VisualObject owner) {
        Text copy = this.getContext().createText(owner);
        copy.value = this.value;
        return copy;
    }
}

