/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.layout.AbstractVerticalLayout;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.VisualObject;

public class TableColumnLayout
extends AbstractVerticalLayout {
    public TableColumnLayout(PrintingContext printingContext, Container ownerContainer) {
        super(printingContext, ownerContainer);
    }

    @Override
    protected void performRendering(Container container) {
        Double maxContentWidth = this.getMaxContentWidth(container);
        Double minWidth = container.getMinWidth();
        Double minHeight = container.getMinHeight();
        Double calculatedContentWidth = null;
        Double calculatedContentHeight = null;
        List<VisualObject> items = container.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                if (visualObject.is(Container.class)) {
                    Container subContainer = visualObject.as(Container.class);
                    subContainer.doLayout();
                }
                Double width = visualObject.getWidth();
                Double height = visualObject.getHeight();
                if (width != null && (calculatedContentWidth == null || calculatedContentWidth < width)) {
                    calculatedContentWidth = width;
                }
                if (height != null) {
                    if (calculatedContentHeight == null) {
                        calculatedContentHeight = height;
                        continue;
                    }
                    calculatedContentHeight = calculatedContentHeight + height;
                    continue;
                }
                throw new IllegalStateException("visual object " + visualObject.getItemId() + " had no height after layouting.");
            }
        }
        if (calculatedContentHeight == null) {
            calculatedContentHeight = 0.0;
        }
        if (calculatedContentWidth == null) {
            calculatedContentWidth = 0.0;
        }
        if (maxContentWidth != null) {
            if (calculatedContentWidth > maxContentWidth) {
                this.handleHorizontalContainerOverflow(container, maxContentWidth);
                calculatedContentWidth = maxContentWidth;
            }
        } else if (minWidth != null && calculatedContentWidth < minWidth - this.getTotalHorizontalMargins(container)) {
            calculatedContentWidth = minWidth - this.getTotalHorizontalMargins(container);
        }
        Double calculatedWidth = calculatedContentWidth + this.getTotalHorizontalMargins(container);
        if (minHeight != null && calculatedContentHeight < minHeight - this.getTotalVerticalMargins(container)) {
            calculatedContentHeight = minHeight - this.getTotalVerticalMargins(container);
        }
        Double calculatedHeight = calculatedContentHeight + this.getTotalVerticalMargins(container);
        if (minWidth != null && minWidth > calculatedWidth) {
            container.setWidth(minWidth);
        } else {
            container.setWidth(calculatedWidth);
        }
        Double height = null;
        height = minHeight != null && minHeight > calculatedHeight ? minHeight : calculatedHeight;
        container.setHeight(height);
        this.horizontallyAlignChildren(container);
    }
}

