/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.List;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.layout.ColumnLayout;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.VisualObject;

public class TableLayout
extends ColumnLayout {
    public TableLayout(PrintingContext printingContext, Container ownerContainer) {
        super(printingContext, ownerContainer);
    }

    @Override
    protected void performRendering(Container container) {
        Double maxContentHeight = this.getMaxContentHeight(container);
        super.performRendering(container);
        Double calculatedContentHeight = this.alignCellsAsRows(container);
        if (this.isSignificantlyLower(maxContentHeight, calculatedContentHeight)) {
            this.handleVerticalContainerOverflow(container, container, maxContentHeight, maxContentHeight);
        }
    }

    protected Double alignCellsAsRows(Container container) {
        Double calculatedContentHeight = 0.0;
        List<VisualObject> columns = container.getItems();
        if (columns != null) {
            int rowCount = this.getRowCount(columns);
            int i = 0;
            for (i = 0; i < rowCount; ++i) {
                double rowHeight = this.getRowHeightForRow(i, columns);
                calculatedContentHeight = calculatedContentHeight + rowHeight;
                for (VisualObject visualObject : columns) {
                    Container column = (Container)visualObject;
                    List<VisualObject> rows = column.getItems();
                    if (rows == null || rows.size() <= i) continue;
                    VisualObject cell = rows.get(i);
                    Double cellHeight = cell.getHeight();
                    if (cellHeight == null && cell.is(Container.class)) {
                        Container cellContainer = (Container)cell;
                        cellContainer.doLayout();
                        cellHeight = cellContainer.getHeight();
                    }
                    if (!(cellHeight < rowHeight)) continue;
                    double delta = rowHeight - cellHeight;
                    for (int j = i + 1; j < rows.size(); ++j) {
                        VisualObject cellToMove = rows.get(j);
                        Point2D pos = cellToMove.getRelativePosition();
                        pos = pos.moveY(delta);
                        cellToMove.setRelativePosition(pos);
                    }
                    cell.setHeight(rowHeight);
                }
            }
            Double columnMaxHeight = 0.0;
            for (VisualObject visualObject : columns) {
                Double colHeight = calculatedContentHeight + this.getTotalVerticalMargins(visualObject);
                visualObject.setHeight(colHeight);
                if (!(colHeight > columnMaxHeight)) continue;
                columnMaxHeight = colHeight;
            }
            container.setHeight(columnMaxHeight + this.getTotalVerticalMargins(container));
            calculatedContentHeight = columnMaxHeight;
        }
        return calculatedContentHeight;
    }

    protected double getColumnHeight(Container column) {
        double result = 0.0;
        List<VisualObject> items = column.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                result += visualObject.getHeight().doubleValue();
            }
        }
        return result;
    }

    public double getRowHeightForRow(int i, List<VisualObject> items) {
        double max = 0.0;
        for (VisualObject visualObject : items) {
            VisualObject cell;
            Double h;
            Container c = (Container)visualObject;
            List<VisualObject> rows = c.getItems();
            if (rows == null || rows.size() <= i || !((h = (cell = rows.get(i)).getHeight()) > max)) continue;
            max = h;
        }
        return max;
    }

    public int getRowCount(List<VisualObject> items) {
        int max = 0;
        for (VisualObject visualObject : items) {
            Container c = (Container)visualObject;
            List<VisualObject> rows = c.getItems();
            if (rows == null || max >= rows.size()) continue;
            max = rows.size();
        }
        return max;
    }
}

