/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.ArrayList;
import java.util.List;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.layout.Layout;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.VisualObject;

public class ColumnLayout
extends Layout {
    protected ColumnLayout(PrintingContext printingContext, Container layoutedContainer) {
        super(printingContext, layoutedContainer);
    }

    @Override
    protected void performRendering(Container container) {
        Double maxContentWidth = this.getMaxContentWidth(container);
        Double calculatedContentWidth = 0.0;
        this.wrapChildElementsInContainers(container);
        List<Container> columns = container.getItems(Container.class);
        if (columns != null) {
            Double currentX = 0.0;
            for (Container column : columns) {
                column.setMinWidth(this.getMaxWidthForSubContainer(column));
                column.doLayout();
                Double w = column.getWidth();
                calculatedContentWidth = calculatedContentWidth + w;
                column.setRelativePosition(new Point2D(currentX, 0.0));
                currentX = currentX + w;
            }
        }
        Double calculatedContentHeight = 0.0;
        if (columns != null) {
            for (Container column : columns) {
                Double h = column.getHeight();
                if (!(h > calculatedContentHeight)) continue;
                calculatedContentHeight = h;
            }
            for (Container column : columns) {
                column.setHeight(calculatedContentHeight);
            }
        }
        Double calculatedHeight = calculatedContentHeight + this.getTotalVerticalMargins(container);
        Double calculatedWidth = calculatedContentWidth + this.getTotalHorizontalMargins(container);
        if (!this.isScalingTable()) {
            container.setWidth(calculatedWidth);
        }
        container.setHeight(calculatedHeight);
        if (this.isSignificantlyLower(maxContentWidth, calculatedContentWidth)) {
            throw new IllegalStateException("layout did not pay attention to maxWidth for container " + container.getItemId());
        }
    }

    private void handleHorizontalOverflow(Container container, Double calculatedWidth, Double maxWidth) {
        Double mWidth;
        double relativeWidth;
        Style vStyle;
        List<VisualObject> items = container.getItems();
        Double flex = null;
        Double flexTotal = 0.0;
        for (VisualObject visualObject : items) {
            Style vStyle2 = visualObject.getStyle();
            flex = (Double)vStyle2.get("flex");
            if (flex == null) {
                flex = 1.0;
                vStyle2.set("flex", flex);
            }
            flexTotal = flexTotal + flex;
        }
        double extraSpaceToDistribute = 0.0;
        ArrayList<VisualObject> extraSpaceReceivers = new ArrayList<VisualObject>();
        for (VisualObject visualObject : items) {
            vStyle = visualObject.getStyle();
            flex = (Double)vStyle.get("flex");
            relativeWidth = flex / flexTotal;
            mWidth = relativeWidth * maxWidth;
            Double vMaxWidth = visualObject.getMaxWidth();
            if (vMaxWidth != null && vMaxWidth < mWidth) {
                extraSpaceToDistribute += mWidth - vMaxWidth;
                mWidth = vMaxWidth;
            } else {
                extraSpaceReceivers.add(visualObject);
            }
            visualObject.setMinWidth(mWidth);
            visualObject.setMaxWidth(mWidth);
        }
        if (this.isSignificantlyLower(0.0, extraSpaceToDistribute)) {
            flexTotal = 0.0;
            for (VisualObject visualObject : extraSpaceReceivers) {
                vStyle = visualObject.getStyle();
                flex = (Double)vStyle.get("flex");
                flexTotal = flexTotal + flex;
            }
            for (VisualObject visualObject : extraSpaceReceivers) {
                vStyle = visualObject.getStyle();
                flex = (Double)vStyle.get("flex");
                relativeWidth = flex / flexTotal;
                mWidth = visualObject.getMinWidth();
                mWidth = mWidth + relativeWidth * extraSpaceToDistribute;
                visualObject.setMinWidth(mWidth);
                visualObject.setMaxWidth(mWidth);
            }
        }
        container.setWidth(maxWidth);
        this.performRendering(container);
    }

    protected void wrapChildElementsInContainers(Container container) {
        List<VisualObject> items = container.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                if (Container.class.isAssignableFrom(visualObject.getClass())) continue;
                Container wrapperContainer = container.getContext().createContainer(container);
                wrapperContainer.add(visualObject);
                container.insertAfter(wrapperContainer, visualObject);
            }
        }
    }

    public Double getMaxWidthForSubContainer(Container container) {
        PrintingObject layoutOwner;
        Double result = null;
        Container owningContainer = container.getOwnerContainer();
        if (owningContainer != (layoutOwner = this.getOwner())) {
            throw new IllegalStateException("layout " + this.getId() + " is used to calculate the max width for a visual object " + container.getId() + ", that is not a subelement (actual owner: " + owningContainer.getId() + " " + owningContainer.getItemId() + ") of the container " + layoutOwner.getId() + " this layout is controlling.");
        }
        Double ownerMaxWidth = this.getMaxContentWidth(owningContainer);
        double distributableSpace = 0.0;
        double distributableFlexTotal = 0.0;
        ArrayList<VisualObject> flexDistributableItems = new ArrayList<VisualObject>();
        List<VisualObject> subItems = owningContainer.getItems();
        if (subItems != null) {
            double flexedWidth;
            Double flex;
            Style vStyle;
            double flexTotal = 0.0;
            for (VisualObject visualObject : subItems) {
                Double flex2;
                Style vStyle2 = visualObject.getStyle();
                if (vStyle2 == null) {
                    vStyle2 = visualObject.createStyle();
                }
                if ((flex2 = (Double)vStyle2.get("flex")) == null) {
                    flex2 = new Double(1.0);
                    vStyle2.set("flex", flex2);
                }
                flexTotal += flex2.doubleValue();
            }
            for (VisualObject visualObject : subItems) {
                Double mw = visualObject.getMaxWidth();
                vStyle = visualObject.getStyle();
                flex = (Double)vStyle.get("flex");
                flexedWidth = flex / flexTotal * ownerMaxWidth;
                if (mw != null && flexedWidth > mw) {
                    distributableSpace += flexedWidth - mw;
                    continue;
                }
                distributableFlexTotal += flex.doubleValue();
                flexDistributableItems.add(visualObject);
            }
            boolean didFindContainer = false;
            for (VisualObject visualObject : subItems) {
                if (visualObject != container) continue;
                vStyle = visualObject.getStyle();
                flex = (Double)vStyle.get("flex");
                flexedWidth = flex / flexTotal * ownerMaxWidth;
                if (flexDistributableItems.contains(visualObject)) {
                    flexedWidth += flex / distributableFlexTotal * distributableSpace;
                } else if (flexedWidth > visualObject.getMaxWidth()) {
                    flexedWidth = visualObject.getMaxWidth();
                }
                result = flexedWidth;
                didFindContainer = true;
            }
            if (!didFindContainer) {
                throw new IllegalStateException("maxwidth could not be determined, because the visual object " + container.getItemId() + " was not contained by its referenced owning container. owner container: " + owningContainer.getItemId());
            }
        } else {
            throw new IllegalStateException("a maxwidth can only be determined for direct subelements. the owning container " + owningContainer.getItemId() + " had no sub elements.");
        }
        if (result == null) {
            throw new IllegalStateException("a maxwidth could not be determined for container " + container.getItemId() + ", but is required to perform the layouting process. owner container: " + owningContainer.getItemId());
        }
        return result;
    }
}

