/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.css;

import java.util.List;
import org.bndly.common.lang.StringUtil;
import org.bndly.css.CSSStyle;
import org.bndly.css.selector.CSSChildSelector;
import org.bndly.css.selector.CSSSelector;
import org.bndly.css.selector.CSSSelectorParser;
import org.bndly.css.selector.CSSTypeSelector;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.VisualObject;

public class CSSSelectorMatcher {
    private VisualObject currentVisualObject;

    public boolean styleAppliesOn(CSSStyle style, VisualObject v) {
        this.currentVisualObject = v;
        String selectorString = style.getSelector();
        CSSSelectorParser parser = new CSSSelectorParser();
        List selectors = parser.parseSelectorString(selectorString);
        boolean allSelectorsApply = true;
        for (int i = selectors.size() - 1; i >= 0 && allSelectorsApply; --i) {
            CSSSelector selector = (CSSSelector)selectors.get(i);
            if (selector.is(CSSTypeSelector.class)) {
                allSelectorsApply = allSelectorsApply && this.typeSelectorAppliesOnCurrentVisualObject((CSSTypeSelector)selector.as(CSSTypeSelector.class));
                continue;
            }
            if (!selector.is(CSSChildSelector.class)) continue;
            CSSTypeSelector parentTypeSelector = (CSSTypeSelector)((CSSSelector)selectors.get(i - 1)).as(CSSTypeSelector.class);
            allSelectorsApply = allSelectorsApply && this.typeChildSelectorAppliesOnCurrentVisualObject(parentTypeSelector);
            --i;
        }
        return allSelectorsApply;
    }

    private boolean typeChildSelectorAppliesOnCurrentVisualObject(CSSTypeSelector parentTypeSelector) {
        for (Container owner = this.currentVisualObject.getOwnerContainer(); owner != null; owner = owner.getOwnerContainer()) {
            this.currentVisualObject = owner;
            if (!this.typeSelectorAppliesOnCurrentVisualObject(parentTypeSelector)) continue;
            return true;
        }
        return false;
    }

    private boolean typeSelectorAppliesOnCurrentVisualObject(CSSTypeSelector as) {
        String n = as.getTypeName();
        if (n.startsWith(".")) {
            String[] styleClassesArray;
            String styleClasses = this.currentVisualObject.getStyleClasses();
            if (styleClasses != null && (styleClassesArray = styleClasses.split(" ")) != null) {
                for (String styleName : styleClassesArray) {
                    if (!("." + styleName).equals(n)) continue;
                    return true;
                }
            }
        } else {
            Class<?> clazz = this.currentVisualObject.getClass();
            String baseClass = clazz.getSimpleName();
            if (n.equals(baseClass = StringUtil.lowerCaseFirstLetter((String)baseClass))) {
                return true;
            }
        }
        return false;
    }
}

