/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.List;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.layout.Layout;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.VisualObject;

public class AbsoluteLayout
extends Layout {
    public AbsoluteLayout(PrintingContext printingContext, Container layoutedContainer) {
        super(printingContext, layoutedContainer);
    }

    @Override
    protected void performRendering(Container container) {
        Double w = 0.0;
        Double h = 0.0;
        List<VisualObject> items = container.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                if (visualObject.is(Container.class)) {
                    Container subContainer = (Container)visualObject;
                    subContainer.doLayout();
                }
                Style style = visualObject.getCalculatedStyle();
                Double top = (Double)style.get("top");
                Double left = (Double)style.get("left");
                if (top == null) {
                    top = 0.0;
                }
                if (left == null) {
                    left = 0.0;
                }
                double x = left;
                double y = top;
                visualObject.setRelativePosition(new Point2D(x, y));
                Double vW = visualObject.getWidth();
                Double vH = visualObject.getHeight();
                if (vW == null) {
                    visualObject.getWidth();
                    throw new IllegalStateException(visualObject.getClass().getSimpleName() + " " + visualObject.getItemId() + " had no width after layouting");
                }
                if (vH == null) {
                    throw new IllegalStateException(visualObject.getClass().getSimpleName() + " " + visualObject.getItemId() + " had no height after layouting");
                }
                double farX = x + vW;
                double farY = y + vH;
                if (farX > w) {
                    w = farX;
                }
                if (!(farY > h)) continue;
                h = farY;
            }
        }
        Double minWidth = container.getMinWidth();
        Double minHeight = container.getMinHeight();
        if (minWidth != null && minWidth > w) {
            w = minWidth;
        }
        if (minHeight != null && minHeight > h) {
            h = minHeight;
        }
        Double maxWidth = container.getMaxWidth();
        Double maxHeight = container.getMaxHeight();
        if (maxWidth != null && maxWidth < w) {
            w = maxWidth;
        }
        if (maxHeight != null && maxHeight < h) {
            h = maxHeight;
        }
        container.setWidth(w);
        container.setHeight(h);
    }
}

