/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.List;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.layout.Layout;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.Image;
import org.bndly.pdf.visualobject.Paragraph;
import org.bndly.pdf.visualobject.Text;
import org.bndly.pdf.visualobject.VisualObject;

public abstract class AbstractVerticalLayout
extends Layout {
    protected AbstractVerticalLayout(PrintingContext printingContext, Container layoutedContainer) {
        super(printingContext, layoutedContainer);
    }

    protected void handleHorizontalContainerOverflow(Container container, Double maxWidth) {
        List<VisualObject> items = container.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                Double w = visualObject.getWidth();
                if (w == null || !(w > maxWidth)) continue;
                if (visualObject.is(Text.class)) {
                    this.handleHorizontalContainerOverflowForText(container, maxWidth, (Text)visualObject);
                    continue;
                }
                if (!visualObject.is(Image.class)) continue;
                this.handleHorizontalContainerOverflowForImage(container, maxWidth, (Image)visualObject);
            }
        }
        this.performRendering(container);
    }

    protected void handleHorizontalContainerOverflowForImage(Container container, Double maxWidth, Image visualObject) {
        Double ratio = maxWidth / visualObject.getWidth();
        visualObject.setWidth(maxWidth);
        if (ratio != null) {
            visualObject.setHeight(visualObject.getHeight() * ratio);
        }
    }

    protected void handleHorizontalContainerOverflowForText(Container container, Double maxWidth, Text visualObject) {
        String textValue = visualObject.getValue();
        int i = textValue.length();
        do {
            if ((i = textValue.lastIndexOf(" ", i - 1)) <= -1) continue;
            visualObject.setValue(textValue.substring(0, i));
        } while (i > -1 && visualObject.getWidth() > maxWidth);
        if (visualObject.getWidth() > maxWidth) {
            i = textValue.length();
            do {
                if (--i <= -1) continue;
                visualObject.setValue(textValue.substring(0, i));
            } while (i > -1 && visualObject.getWidth() > maxWidth);
        }
        String remainingTextValue = textValue.substring(i);
        Text remainingText = this.getContext().createText(container);
        remainingText.setValue(remainingTextValue);
        container.insertAfter(remainingText, visualObject);
        remainingText.setStyle(visualObject.getStyle());
    }

    protected void horizontallyAlignChildren(Container container) {
        Style style = container.getCalculatedStyle();
        boolean rightAligned = style.isRightAligned();
        Double mt = (Double)style.get("margin-top");
        mt = mt == null ? 0.0 : mt;
        Double mr = (Double)style.get("margin-right");
        mr = mr == null ? 0.0 : mr;
        Double ml = (Double)style.get("margin-left");
        ml = ml == null ? 0.0 : ml;
        List<VisualObject> items = container.getItems();
        if (items != null) {
            double currentX = 0.0;
            double currentY = 0.0 + mt;
            currentX = rightAligned ? container.getWidth() - mr : (currentX += ml.doubleValue());
            for (VisualObject visualObject : items) {
                double x = currentX;
                double y = currentY;
                if (visualObject.is(Text.class)) {
                    Double bls;
                    Text text = (Text)visualObject;
                    Double fontSize = text.getFontSize();
                    if (fontSize == null) {
                        fontSize = 1.0;
                    }
                    if ((bls = (Double)text.getCalculatedStyle().get("font-baseline-shift")) == null) {
                        throw new IllegalStateException("base line shift for " + text.getClass().getSimpleName() + " " + text.getItemId() + " was null.");
                    }
                    y -= fontSize * bls;
                    Style tStyle = text.getCalculatedStyle();
                    x = tStyle.isRightAligned() ? container.getWidth() - mr - text.getWidth() : ml;
                } else if (visualObject.is(Paragraph.class)) {
                    Paragraph p = visualObject.as(Paragraph.class);
                    Style tStyle = p.getCalculatedStyle();
                    x = tStyle.isRightAligned() ? container.getWidth() - mr - p.getWidth() : ml;
                } else if (rightAligned) {
                    x = currentX - visualObject.getWidth();
                }
                visualObject.setRelativePosition(new Point2D(x, y));
                currentY += visualObject.getHeight().doubleValue();
            }
        }
    }
}

