/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.ArrayList;
import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.PrintingObjectImpl;
import org.bndly.pdf.layout.VerticalOverflowStrategy;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.Document;
import org.bndly.pdf.visualobject.OverflowPage;
import org.bndly.pdf.visualobject.Page;
import org.bndly.pdf.visualobject.PageTemplate;
import org.bndly.pdf.visualobject.VisualObject;

public class AddPageOverflowStrategy
extends PrintingObjectImpl
implements VerticalOverflowStrategy {
    public AddPageOverflowStrategy(PrintingContext context, PrintingObject owner) {
        super(context, owner);
    }

    private Document getDocumentOf(VisualObject visualObject) {
        return this.getOwnerContainerByType(Document.class, visualObject);
    }

    private Page getPageOf(VisualObject visualObject) {
        return this.getOwnerContainerByType(Page.class, visualObject);
    }

    private <T extends Container> T getOwnerContainerByType(Class<T> type, VisualObject visualObject) {
        if (visualObject.is(type)) {
            return (T)((Container)visualObject.as(type));
        }
        if (visualObject.getOwnerContainer() == null) {
            return null;
        }
        return this.getOwnerContainerByType(type, visualObject.getOwnerContainer());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleVerticalOverflowIn(Container container, VisualObject overflownObject, Double maxHeight, Double overflownObjectMaxHeight) {
        if (!container.isParentOf(overflownObject)) {
            return;
        }
        Document document = this.getDocumentOf(container);
        if (document == null) throw new IllegalStateException("there has to be a document instance in the root of the visual object hierarchy.");
        Page page = this.getPageOf(container);
        if (page == null) throw new IllegalStateException("there has to be a page instance in the visual object hierarchy.");
        Container overflowToContainer = this.cloneParentContainersOfOverflownObjectToNewPage(page, overflownObject, document);
        Page overflowToPage = this.getPageOf(overflowToContainer);
        ArrayList<VisualObject> siblingsToMove = new ArrayList<VisualObject>();
        for (VisualObject sibling = overflownObject.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            siblingsToMove.add(sibling);
        }
        overflownObject.overflowVerticalInto(overflowToContainer, overflownObjectMaxHeight);
        for (VisualObject visualObject : siblingsToMove) {
            overflowToContainer.add(visualObject);
        }
        overflowToPage.doLayout();
    }

    private Container cloneParentContainersOfOverflownObjectToNewPage(Container container, VisualObject overflownObject, Container overflowToContainer) {
        Container clonedOwnerContainer;
        Container ownerContainer = overflownObject.getOwnerContainer();
        if (container != ownerContainer) {
            overflowToContainer = this.cloneParentContainersOfOverflownObjectToNewPage(container, ownerContainer, overflowToContainer);
        }
        OverflowPage overflowPage = null;
        if (overflowToContainer.is(Document.class)) {
            Document doc = overflowToContainer.as(Document.class);
            overflowPage = doc.getItem(OverflowPage.class);
            if (overflowPage != null) {
                Page page = overflowPage.getContext().createPage(overflowToContainer);
                overflowToContainer.add(page);
                clonedOwnerContainer = page;
            } else {
                clonedOwnerContainer = ownerContainer.copyToWithoutChildren(overflowToContainer).as(Container.class);
                doc.add(clonedOwnerContainer);
            }
        } else {
            clonedOwnerContainer = ownerContainer.copyToWithoutChildren(overflowToContainer).as(Container.class);
            overflowToContainer.add(clonedOwnerContainer);
        }
        if (clonedOwnerContainer.is(Page.class)) {
            List<PageTemplate> templates;
            Page page = ownerContainer.as(Page.class);
            if (overflowPage != null) {
                page = overflowPage;
            }
            if ((templates = page.getItems(PageTemplate.class)) != null) {
                for (PageTemplate pageTemplate : templates) {
                    pageTemplate.copyTo(clonedOwnerContainer);
                }
            }
        }
        for (VisualObject sibling = ownerContainer.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            overflowToContainer.add(sibling);
        }
        return clonedOwnerContainer;
    }
}

