/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObjectImpl;
import org.bndly.pdf.layout.ColumnLayout;
import org.bndly.pdf.layout.VerticalLayout;
import org.bndly.pdf.layout.VerticalOverflowStrategy;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.VisualObject;

public abstract class Layout
extends PrintingObjectImpl {
    private boolean isScalingTable;
    private VerticalOverflowStrategy verticalOverflowStrategy;

    protected Layout(PrintingContext printingContext, Container layoutedContainer) {
        super(printingContext, layoutedContainer);
    }

    public void render() {
        Container owner = (Container)this.getOwner();
        this.performRendering(owner);
    }

    protected boolean isScalingTable() {
        return this.isScalingTable;
    }

    protected Double getMaxContentWidth(Container container) {
        Double max = container.getMaxWidth();
        if (max == null) {
            Container owner = container.getOwnerContainer();
            if (owner == null) {
                throw new IllegalStateException("container had no owner, but the owner was required to calculate maxWidth. container: " + container.getClass().getSimpleName() + " " + container.getItemId());
            }
            Layout layout = owner.getLayout();
            if (layout == null) {
                throw new IllegalStateException("container had no layout. " + owner.getClass().getSimpleName() + " " + owner.getItemId());
            }
            if (layout.is(ColumnLayout.class)) {
                return owner.getLayout().as(ColumnLayout.class).getMaxWidthForSubContainer(container);
            }
            if (owner != null) {
                max = this.getMaxContentWidth(owner);
            }
        }
        Style style = container.getCalculatedStyle();
        Double mr = (Double)style.get("margin-right");
        Double ml = (Double)style.get("margin-left");
        if (max == null) {
            throw new IllegalStateException("container has no maxWidth and no parent that defines one: " + container.getItemId());
        }
        if (mr != null) {
            max = max - mr;
        }
        if (ml != null) {
            max = max - ml;
        }
        return max;
    }

    protected Double getMaxContentHeight(Container controlledSubContainer) {
        Container ownerCt;
        Double max = controlledSubContainer.getMaxHeight();
        if (max == null && (ownerCt = controlledSubContainer.getOwnerContainer()) != null) {
            Layout ownerLayout = ownerCt.getLayout();
            max = ownerLayout.getMaxContentHeight(ownerCt);
            if (ownerLayout.is(VerticalLayout.class)) {
                for (VisualObject sibling = controlledSubContainer.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
                    Double h = sibling.getHeight();
                    max = max - h;
                }
            }
        }
        return max - this.getTotalVerticalMargins(controlledSubContainer);
    }

    protected boolean isSignificantlyLower(double isLower, double than) {
        return than - isLower > 1.0E-6;
    }

    protected double getTotalHorizontalMargins(VisualObject visualObject) {
        double result = 0.0;
        Style vStyle = visualObject.getCalculatedStyle();
        if (vStyle != null) {
            Double ml = (Double)vStyle.get("margin-left");
            Double mr = (Double)vStyle.get("margin-right");
            if (ml != null) {
                result += ml.doubleValue();
            }
            if (mr != null) {
                result += mr.doubleValue();
            }
        }
        return result;
    }

    protected double getTotalVerticalMargins(VisualObject visualObject) {
        double result = 0.0;
        Style vStyle = visualObject.getCalculatedStyle();
        if (vStyle != null) {
            Double mt = (Double)vStyle.get("margin-top");
            Double mb = (Double)vStyle.get("margin-bottom");
            if (mt != null) {
                result += mt.doubleValue();
            }
            if (mb != null) {
                result += mb.doubleValue();
            }
        }
        return result;
    }

    protected abstract void performRendering(Container var1);

    protected void handleVerticalContainerOverflow(Container container, VisualObject overflownObject, Double maxHeight, Double overflownObjectMaxHeight) {
        if (overflownObject == null) {
            throw new IllegalStateException("overflow handlers require the overflownObject parameter to not be null.");
        }
        VerticalOverflowStrategy strategy = this.getVerticalOverflowStrategy(this);
        strategy.handleVerticalOverflowIn(container, overflownObject, maxHeight, overflownObjectMaxHeight);
        this.performRendering(container);
    }

    private VerticalOverflowStrategy getVerticalOverflowStrategy(Layout layout) {
        if (layout.verticalOverflowStrategy != null) {
            return layout.verticalOverflowStrategy;
        }
        Container ownerCt = layout.getOwner().as(Container.class).getOwnerContainer();
        if (ownerCt == null) {
            throw new IllegalStateException("ran into a vertical overflow situation and there was no overflow strategy registered.");
        }
        return this.getVerticalOverflowStrategy(ownerCt.getLayout());
    }

    public void setVerticalOverflowStrategy(VerticalOverflowStrategy verticalOverflowStrategy) {
        this.verticalOverflowStrategy = verticalOverflowStrategy;
    }
}

