/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.layout.AbstractVerticalLayout;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.Text;
import org.bndly.pdf.visualobject.VisualObject;

public class VerticalLayout
extends AbstractVerticalLayout {
    public VerticalLayout(PrintingContext printingContext, Container ownerContainer) {
        super(printingContext, ownerContainer);
    }

    @Override
    protected void performRendering(Container container) {
        Double maxContentWidth = this.getMaxContentWidth(container);
        Double maxContentHeight = this.getMaxContentHeight(container);
        Double minWidth = container.getMinWidth();
        Double minHeight = container.getMinHeight();
        Double calculatedContentWidth = null;
        Double calculatedContentHeight = null;
        VisualObject overflowObject = null;
        Double overflownObjectMaxHeight = null;
        List<VisualObject> items = container.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                String textValue;
                String[] textElements;
                if (!visualObject.is(Text.class) || (textElements = (textValue = visualObject.as(Text.class).getValue()).split("\n")).length <= 1) continue;
                visualObject.as(Text.class).setValue(textElements[0]);
                VisualObject predecessor = visualObject;
                for (int i = 1; i < textElements.length; ++i) {
                    String element = textElements[i];
                    Text newLineText = this.getContext().createText(container);
                    newLineText.setValue(element);
                    container.insertAfter(newLineText, predecessor);
                    predecessor = newLineText;
                }
            }
            items = container.getItems();
            for (VisualObject visualObject : items) {
                if (visualObject.is(Container.class)) {
                    Container subContainer = visualObject.as(Container.class);
                    subContainer.doLayout();
                }
                Double width = visualObject.getWidth();
                Double height = visualObject.getHeight();
                if (width != null && (calculatedContentWidth == null || calculatedContentWidth < width)) {
                    calculatedContentWidth = width;
                }
                if (height != null) {
                    calculatedContentHeight = calculatedContentHeight == null ? height : Double.valueOf(calculatedContentHeight + height);
                } else {
                    throw new IllegalStateException("visual object " + visualObject.getItemId() + " had no height after layouting.");
                }
                double tmpHeight = calculatedContentHeight;
                if (maxContentHeight == null || !this.isSignificantlyLower(maxContentHeight, tmpHeight) || overflowObject != null) continue;
                overflowObject = visualObject;
                overflownObjectMaxHeight = tmpHeight - maxContentHeight;
                break;
            }
        }
        if (calculatedContentHeight == null) {
            calculatedContentHeight = 0.0;
        }
        if (calculatedContentWidth == null) {
            calculatedContentWidth = 0.0;
        }
        if (maxContentWidth != null) {
            if (calculatedContentWidth > maxContentWidth) {
                this.handleHorizontalContainerOverflow(container, maxContentWidth);
                calculatedContentWidth = maxContentWidth;
            }
        } else if (minWidth != null && calculatedContentWidth < minWidth - this.getTotalHorizontalMargins(container)) {
            calculatedContentWidth = minWidth - this.getTotalHorizontalMargins(container);
        }
        Double calculatedWidth = calculatedContentWidth + this.getTotalHorizontalMargins(container);
        if (maxContentHeight != null) {
            if (calculatedContentHeight > maxContentHeight) {
                this.handleVerticalContainerOverflow(container, overflowObject, maxContentHeight, overflownObjectMaxHeight);
                calculatedContentHeight = maxContentHeight;
            }
        } else if (minHeight != null && calculatedContentHeight < minHeight - this.getTotalVerticalMargins(container)) {
            calculatedContentHeight = minHeight - this.getTotalVerticalMargins(container);
        }
        Double calculatedHeight = calculatedContentHeight + this.getTotalVerticalMargins(container);
        if (minWidth != null && minWidth > calculatedWidth) {
            container.setWidth(minWidth);
        } else {
            container.setWidth(calculatedWidth);
        }
        Double height = null;
        height = minHeight != null && minHeight > calculatedHeight ? minHeight : calculatedHeight;
        if (container.getHeight() == null) {
            container.setHeight(height);
        }
        this.horizontallyAlignChildren(container);
    }
}

