/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.output;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.bndly.common.data.io.ReplayableInputStream;
import org.bndly.css.CSSItem;
import org.bndly.css.CSSReader;
import org.bndly.css.CSSStyle;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.PrintingObjectImpl;
import org.bndly.pdf.output.FontBinding;
import org.bndly.pdf.output.ImageBinding;
import org.bndly.pdf.output.InputStreamResolver;
import org.bndly.pdf.output.PDFPrinter;
import org.bndly.pdf.output.PDFontTextSizeStrategy;
import org.bndly.pdf.style.FontStyles;
import org.bndly.pdf.style.FontWeights;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.Document;
import org.bndly.pdf.visualobject.Image;
import org.bndly.pdf.visualobject.OverflowPage;
import org.bndly.pdf.visualobject.Page;
import org.bndly.pdf.visualobject.SystemText;
import org.bndly.pdf.visualobject.Table;
import org.bndly.pdf.visualobject.Text;
import org.bndly.pdf.visualobject.VisualObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFPrinterImpl
extends PrintingObjectImpl
implements PDFPrinter {
    private static final Logger LOG = LoggerFactory.getLogger(PDFPrinter.class);
    private Document document;
    private PDDocument pddoc;
    private final List<FontBinding> fontBindings = new ArrayList<FontBinding>();
    private Container currentPageContainer;
    private final List<ImageBinding> imageBindings = new ArrayList<ImageBinding>();
    private PDPageContentStream contentStream;
    private final float debugFontSize = 6.0f;
    private final boolean isDebugEnabled = false;
    private int currentPageIndex;
    private int totalPages;
    private OutputStream outputStream;

    public PDFPrinterImpl(PrintingContext printingContext, PrintingObject owner) {
        super(printingContext, owner);
        PDFontTextSizeStrategy s = new PDFontTextSizeStrategy();
        s.setPdfPrinter(this);
        this.getContext().setTextSizeStrategy(s);
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void setOutputFileName(String outputFileName) {
        try {
            this.outputStream = new FileOutputStream(outputFileName);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalStateException("could not set file as output target.");
        }
    }

    @Override
    public void print(Document d) {
        this.print(d, this.outputStream);
    }

    @Override
    public void print(Document d, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalStateException("no outputStream specified.");
        }
        this.currentPageIndex = 0;
        this.document = d;
        try {
            this.pddoc = new PDDocument();
            this.loadResources();
            this.fillSystemText(this.document, false);
            this.document.doLayout();
            this.totalPages = this.countPagesOf(this.document);
            this.fillSystemText(this.document, true);
            this.generatePages();
            this.pddoc.save(outputStream);
            this.pddoc.close();
        }
        catch (IOException e) {
            LOG.error("failed to print document as pdf: " + e.getMessage(), (Throwable)e);
        }
    }

    private int countPagesOf(Document document) {
        int i = 0;
        List<VisualObject> items = document.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                if (!visualObject.is(Page.class) || visualObject.is(OverflowPage.class)) continue;
                ++i;
            }
        }
        return i;
    }

    private void fillSystemText(Container container, boolean postLayout) {
        List<VisualObject> items = container.getItems();
        if (items != null) {
            for (VisualObject visualObject : items) {
                if (visualObject.is(Page.class) && postLayout) {
                    ++this.currentPageIndex;
                }
                if (visualObject.is(Container.class)) {
                    this.fillSystemText(visualObject.as(Container.class), postLayout);
                    continue;
                }
                if (!visualObject.is(SystemText.class)) continue;
                if (postLayout) {
                    this.handlePostLayoutSystemText(visualObject.as(SystemText.class));
                    continue;
                }
                this.handlePreLayoutSystemText(visualObject.as(SystemText.class));
            }
        }
    }

    private void handlePostLayoutSystemText(SystemText systemText) {
        String v = systemText.getValue();
        v = v.replaceAll("!page!", "" + this.currentPageIndex);
        v = v.replaceAll("!totalPages!", "" + this.totalPages);
        systemText.setValue(v);
    }

    private void handlePreLayoutSystemText(SystemText systemText) {
        String v = systemText.getValue();
        v = v.replaceAll("!today!", "" + new Date());
        systemText.setValue(v);
    }

    private void generatePages() {
        List<Page> pages = this.document.getItems(Page.class);
        for (Page container : pages) {
            if (container.is(OverflowPage.class)) continue;
            float pWidth = container.getWidth().floatValue();
            float pHeight = container.getHeight().floatValue();
            PDRectangle size = new PDRectangle(pWidth, pHeight);
            PDPage pdpage = new PDPage(size);
            this.printPageContainerToPDPage(container, pdpage);
            this.pddoc.addPage(pdpage);
        }
    }

    private void printPageContainerToPDPage(Container container, PDPage pdpage) {
        try {
            boolean didOpenContentStream = false;
            if (this.contentStream == null) {
                didOpenContentStream = true;
                this.contentStream = new PDPageContentStream(this.pddoc, pdpage);
                this.currentPageContainer = container;
            }
            this.debugPrint(container, this.contentStream);
            List<VisualObject> items = container.getItems();
            if (items != null) {
                for (VisualObject visualObject : items) {
                    VisualObject t;
                    if (visualObject.is(Text.class)) {
                        t = (Text)visualObject;
                        this.printText((Text)t, this.contentStream);
                        continue;
                    }
                    if (visualObject.is(Image.class)) {
                        Image i = (Image)visualObject;
                        this.printImage(i, this.contentStream);
                        continue;
                    }
                    if (visualObject.is(Table.class)) {
                        t = (Table)visualObject;
                        this.printTable((Table)t, this.contentStream);
                        continue;
                    }
                    if (!visualObject.is(Container.class)) continue;
                    Container c = (Container)visualObject;
                    this.printPageContainerToPDPage(c, pdpage);
                }
            }
            if (didOpenContentStream) {
                this.contentStream.close();
                this.contentStream = null;
            }
        }
        catch (IOException e) {
            LOG.error("failed to print document container to pdf page: " + e.getMessage(), (Throwable)e);
        }
    }

    private void printTable(Table t, PDPageContentStream contentStream) throws IOException {
        this.debugPrint(t, contentStream);
        contentStream.saveGraphicsState();
        Style tableStyle = t.getCalculatedStyle();
        Double borderWidth = (Double)tableStyle.get("border");
        if (borderWidth != null && borderWidth > 0.0) {
            this.printTableGrid(t, contentStream, borderWidth);
        }
        this.printTableContent(t, contentStream);
        contentStream.restoreGraphicsState();
    }

    private void printTableContent(Table t, PDPageContentStream contentStream) throws IOException {
        contentStream.saveGraphicsState();
        List<Container> columns = t.getItems(Container.class);
        if (columns != null) {
            for (Container column : columns) {
                this.debugPrint(column, contentStream);
                List<Container> cellItems = column.getItems(Container.class);
                if (cellItems == null) continue;
                for (Container cell : cellItems) {
                    this.debugPrint(cell, contentStream);
                    List<VisualObject> items = cell.getItems();
                    if (items == null) continue;
                    for (VisualObject vo : items) {
                        if (Text.class.isAssignableFrom(vo.getClass())) {
                            this.printText((Text)vo, contentStream);
                            continue;
                        }
                        if (Image.class.isAssignableFrom(vo.getClass())) {
                            this.printImage((Image)vo, contentStream);
                            continue;
                        }
                        if (!Table.class.isAssignableFrom(vo.getClass())) continue;
                        this.printTable((Table)vo, contentStream);
                    }
                }
            }
        }
        contentStream.restoreGraphicsState();
    }

    private void printTableGrid(Table t, PDPageContentStream contentStream, Double borderWidth) throws IOException {
        contentStream.saveGraphicsState();
        contentStream.setLineWidth(borderWidth.floatValue());
        Point2D position = t.getAbsolutePosition();
        position = position.flipY(this.currentPageContainer.getHeight());
        double currentY = position.getY();
        int rowCount = t.getRowCount();
        float xStart = (float)position.getX();
        for (int i = 0; i < rowCount - 1; ++i) {
            double height = t.getRowHeightForRow(i);
            contentStream.addLine(xStart, (float)(currentY -= height), xStart + t.getWidth().floatValue(), (float)currentY);
        }
        contentStream.addRect(xStart, (float)(position.getY() - t.getHeight()), t.getWidth().floatValue(), t.getHeight().floatValue());
        List<Container> columns = t.getItems(Container.class);
        if (columns != null) {
            for (int i = 0; i < columns.size() - 1; ++i) {
                Container column = columns.get(i);
                float xEnd = xStart += column.getWidth().floatValue();
                contentStream.addLine(xStart, (float)(position.getY() - t.getHeight()), xEnd, (float)position.getY());
            }
            contentStream.stroke();
        }
        contentStream.restoreGraphicsState();
    }

    private void printText(Text t, PDPageContentStream contentStream) throws IOException {
        this.debugPrint(t, contentStream);
        contentStream.saveGraphicsState();
        contentStream.beginText();
        Style style = t.getCalculatedStyle();
        String font = (String)style.get("font-family");
        Double fontSize = (Double)style.get("font-size");
        FontBinding fontBinding = this.getFontBinding(font, this.getFontWeight(style), this.getFontStyle(style));
        PDFont pdFont = fontBinding.getPdFont();
        contentStream.setFont(pdFont, fontSize.floatValue());
        Point2D position = t.getAbsolutePosition();
        position = position.flipY(this.currentPageContainer.getHeight());
        position = position.moveY(-fontSize.doubleValue());
        contentStream.newLineAtOffset((float)position.getX(), (float)position.getY());
        contentStream.showText(t.getValue());
        contentStream.endText();
        contentStream.restoreGraphicsState();
    }

    private void debugPrint(VisualObject t, PDPageContentStream contentStream) throws IOException {
    }

    private void printImage(Image i, PDPageContentStream contentStream) throws IOException {
        this.debugPrint(i, contentStream);
        contentStream.saveGraphicsState();
        ImageBinding binding = this.getImageBinding(i.getSource());
        PDImageXObject ximage = binding.getPdImage();
        ximage.setWidth(i.getWidth().intValue());
        ximage.setHeight(i.getHeight().intValue());
        Point2D position = i.getAbsolutePosition();
        position = position.flipY(this.currentPageContainer.getHeight());
        contentStream.drawImage(ximage, (float)((int)position.getX()), (float)((int)position.getY() - ximage.getHeight()));
        contentStream.restoreGraphicsState();
    }

    private void loadResources() throws IOException {
        this.loadResources(this.document);
    }

    private void loadResources(VisualObject vo) throws IOException {
        Container c;
        List<VisualObject> items;
        Image i;
        String src;
        Style style = vo.getCalculatedStyle();
        if (style != null) {
            String font = (String)style.get("font-family");
            FontWeights fontWeight = this.getFontWeight(style);
            FontStyles fontStyle = this.getFontStyle(style);
            if (font != null && !this.isFontLoaded(font, fontWeight, fontStyle)) {
                try {
                    PDFont pdFont = this.fontNameToPDFont(font, fontWeight, fontStyle);
                    FontBinding binding = new FontBinding();
                    binding.setPDFont(pdFont);
                    binding.setName(font);
                    binding.setWeight(fontWeight);
                    binding.setStyle(fontStyle);
                    this.fontBindings.add(binding);
                }
                catch (IOException e) {
                    LOG.error("failed to load a font resource: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (vo.is(Image.class) && (src = (i = vo.as(Image.class)).getSource()).toLowerCase().endsWith(".jpg")) {
            InputStreamResolver resolver = this.getContext().getInputStreamResolver();
            ReplayableInputStream is = resolver != null ? ReplayableInputStream.newInstance((InputStream)resolver.resolve(src)) : ReplayableInputStream.newInstance((InputStream)new FileInputStream(src));
            PDImageXObject ximage = JPEGFactory.createFromStream((PDDocument)this.pddoc, (InputStream)is);
            ximage.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            ImageBinding binding = new ImageBinding();
            binding.setName(src);
            binding.setPdImage(ximage);
            this.imageBindings.add(binding);
        }
        if (Container.class.isAssignableFrom(vo.getClass()) && (items = (c = (Container)vo).getItems()) != null) {
            for (VisualObject visualObject : items) {
                this.loadResources(visualObject);
            }
        }
    }

    @Override
    public FontWeights getFontWeight(Style style) {
        String fontWeightString = (String)style.get("font-weight");
        FontWeights fontWeight = null;
        if (fontWeightString != null) {
            fontWeight = FontWeights.valueOf(fontWeightString);
        }
        return fontWeight;
    }

    @Override
    public FontStyles getFontStyle(Style style) {
        String fontStyleString = (String)style.get("font-style");
        FontStyles fontStyle = null;
        if (fontStyleString != null) {
            fontStyle = FontStyles.valueOf(fontStyleString);
        }
        return fontStyle;
    }

    private PDFont fontNameToPDFont(String font, FontWeights fontWeight, FontStyles fontStyle) throws IOException {
        PDType1Font pdFont = null;
        if ("times".equalsIgnoreCase(font)) {
            if (fontWeight == null && fontStyle == null) {
                pdFont = PDType1Font.TIMES_ROMAN;
            } else if (fontWeight == FontWeights.bold && fontStyle == null) {
                pdFont = PDType1Font.TIMES_BOLD;
            } else if (fontWeight == FontWeights.bold && fontStyle == FontStyles.italic) {
                pdFont = PDType1Font.TIMES_BOLD_ITALIC;
            } else if (fontWeight == null && fontStyle == FontStyles.italic) {
                pdFont = PDType1Font.TIMES_ITALIC;
            }
        } else if ("helvetica".equalsIgnoreCase(font)) {
            if (fontWeight == null && fontStyle == null) {
                pdFont = PDType1Font.HELVETICA;
            } else if (fontWeight == FontWeights.bold && fontStyle == null) {
                pdFont = PDType1Font.HELVETICA_BOLD;
            } else if (fontWeight == FontWeights.bold && fontStyle == FontStyles.italic) {
                pdFont = PDType1Font.HELVETICA_BOLD_OBLIQUE;
            } else if (fontWeight == null && fontStyle == FontStyles.italic) {
                pdFont = PDType1Font.HELVETICA_OBLIQUE;
            }
        } else if ("courier".equalsIgnoreCase(font)) {
            if (fontWeight == null && fontStyle == null) {
                pdFont = PDType1Font.COURIER;
            } else if (fontWeight == FontWeights.bold && fontStyle == null) {
                pdFont = PDType1Font.COURIER_BOLD;
            } else if (fontWeight == FontWeights.bold && fontStyle == FontStyles.italic) {
                pdFont = PDType1Font.COURIER_BOLD_OBLIQUE;
            } else if (fontWeight == null && fontStyle == FontStyles.italic) {
                pdFont = PDType1Font.COURIER_OBLIQUE;
            }
        } else {
            InputStreamResolver isr = this.getContext().getInputStreamResolver();
            InputStream input = isr.resolve(font);
            if (input != null) {
                try (InputStream tmp = input;){
                    pdFont = PDType0Font.load((PDDocument)this.pddoc, (InputStream)tmp);
                }
            }
        }
        return pdFont;
    }

    private boolean isFontLoaded(String name, FontWeights fontWeight, FontStyles fontStyle) {
        if (name != null) {
            for (FontBinding b : this.fontBindings) {
                if (!name.equals(b.getName()) || fontStyle != b.getStyle() || fontWeight != b.getWeight()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public FontBinding getFontBinding(String name, FontWeights fontWeight, FontStyles fontStyle) {
        for (FontBinding b : this.fontBindings) {
            if (!name.equals(b.getName()) || fontStyle != b.getStyle() || fontWeight != b.getWeight()) continue;
            return b;
        }
        return null;
    }

    public ImageBinding getImageBinding(String name) {
        for (ImageBinding b : this.imageBindings) {
            if (!name.equals(b.getName())) continue;
            return b;
        }
        return null;
    }

    public void loadStyleSheet(String css) {
        CSSReader cssReader = new CSSReader();
        try {
            List items = cssReader.read(css);
            List<CSSStyle> styles = this.getContext().getStyles();
            for (CSSItem item : items) {
                if (!CSSStyle.class.isInstance(item)) continue;
                styles.add((CSSStyle)item);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed reading the CSS from " + css, e);
        }
    }
}

