/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.style;

import java.util.ArrayList;
import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.PrintingObjectImpl;
import org.bndly.pdf.style.EnumStyleAttribute;
import org.bndly.pdf.style.NumericStyleAttribute;
import org.bndly.pdf.style.StringStyleAttribute;
import org.bndly.pdf.style.StyleAttribute;

public class Style
extends PrintingObjectImpl {
    private List<StyleAttribute<?>> attributes;

    public Style(PrintingContext context, PrintingObject owner) {
        super(context, owner);
    }

    public StringStyleAttribute createStringAttribute() {
        return this.addAttribute(new StringStyleAttribute(this.getContext(), this));
    }

    public NumericStyleAttribute createNumericAttribute() {
        return this.addAttribute(new NumericStyleAttribute(this.getContext(), this));
    }

    public EnumStyleAttribute createEnumAttribute() {
        return this.addAttribute(new EnumStyleAttribute(this.getContext(), this));
    }

    private <T extends StyleAttribute> T addAttribute(T attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
        return attribute;
    }

    public void set(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            throw new NullPointerException("attribute values can not be null");
        }
        if (attributeName != null) {
            EnumStyleAttribute attribute = null;
            if (this.attributes != null) {
                for (EnumStyleAttribute enumStyleAttribute : this.attributes) {
                    String name = enumStyleAttribute.getName();
                    if (!name.equals(attributeName)) continue;
                    attribute = enumStyleAttribute;
                    break;
                }
            }
            if (attribute == null) {
                Class<?> valueClass = attributeValue.getClass();
                if (valueClass.equals(String.class)) {
                    attribute = this.createStringAttribute();
                } else if (valueClass.equals(Double.class)) {
                    attribute = this.createNumericAttribute();
                } else if (Enum.class.isAssignableFrom(valueClass)) {
                    attribute = this.createEnumAttribute();
                } else {
                    throw new IllegalStateException("unsupported attribute value type");
                }
                attribute.setName(attributeName);
            }
            attribute.setValue(attributeValue);
        }
    }

    public <T> T get(String attributeName) {
        if (attributeName != null && this.attributes != null) {
            for (StyleAttribute<?> attribute : this.attributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return (T)attribute.getValue();
            }
        }
        return null;
    }

    public boolean contains(String attributeName) {
        if (this.attributes != null) {
            for (StyleAttribute<?> attribute : this.attributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<StyleAttribute<?>> getAllAttributes() {
        if (this.attributes != null) {
            return new ArrayList(this.attributes);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.attributes != null) {
            boolean first = true;
            for (StyleAttribute<?> att : this.attributes) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(att.getName());
                sb.append(": ");
                sb.append(att.getValue());
                first = false;
            }
        }
        return sb.toString();
    }

    public void overwriteTo(Style overflowToStyle) {
        if (this.attributes != null) {
            for (StyleAttribute<?> attribute : this.attributes) {
                String name = attribute.getName();
                Object value = attribute.getValue();
                overflowToStyle.set(name, value);
            }
        }
    }

    public boolean isLeftAligned() {
        String voAlign = (String)this.get("text-align");
        return "left".equalsIgnoreCase(voAlign);
    }

    public boolean isRightAligned() {
        String voAlign = (String)this.get("text-align");
        return "right".equalsIgnoreCase(voAlign);
    }
}

