/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.visualobject;

import java.util.ArrayList;
import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.layout.Layout;
import org.bndly.pdf.visualobject.VisualObject;

public class Container
extends VisualObject {
    private Layout layout;
    private List<VisualObject> items;

    public Container(PrintingContext context, PrintingObject owner) {
        super(context, owner);
    }

    public <T extends VisualObject> T getItem(Class<T> type) {
        List<T> tmp = this.getItems(type);
        if (tmp != null && tmp.size() == 1) {
            return (T)((VisualObject)tmp.get(0));
        }
        return null;
    }

    public <T extends VisualObject> List<T> getItems(Class<T> type) {
        if (this.items != null) {
            ArrayList<VisualObject> l = new ArrayList<VisualObject>();
            for (VisualObject t : this.items) {
                if (!type.isAssignableFrom(t.getClass())) continue;
                l.add(t);
            }
            if (l.size() > 0) {
                return l;
            }
        }
        return null;
    }

    public List<VisualObject> getItems() {
        if (this.items != null) {
            return new ArrayList<VisualObject>(this.items);
        }
        return this.items;
    }

    public void remove(VisualObject object) {
        if (this.items != null) {
            this.items.remove(object);
        }
    }

    public void add(VisualObject object) {
        this.insertAfter(object, null);
    }

    public void insertAfter(VisualObject object, VisualObject after) {
        Container oldOwner = object.getOwnerContainer();
        if (oldOwner != null) {
            oldOwner.remove(object);
        }
        if (this.items == null) {
            this.items = new ArrayList<VisualObject>();
        }
        if (after != null) {
            int i = this.items.indexOf(after);
            if (i == -1) {
                this.items.add(object);
            }
            this.items.add(i + 1, object);
        } else {
            this.items.add(object);
        }
        object.ownerContainer = this;
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final <T extends Layout> T setLayout(T layoutInstance) {
        this.layout = layoutInstance;
        return layoutInstance;
    }

    public void doLayout() {
        if (this.layout == null) {
            this.layout = this.setLayout(this.getContext().createVerticalLayout(this));
        }
        this.layout.render();
    }

    @Override
    public Container copyTo(VisualObject owner) {
        Container copyContainer = this.getContext().createContainer(owner);
        List<VisualObject> subs = this.getItems();
        if (subs != null) {
            for (VisualObject sub : subs) {
                sub.copyTo(copyContainer);
            }
        }
        return copyContainer;
    }

    public VisualObject copyToWithoutChildren(VisualObject owner) {
        Container copyContainer = this.getContext().createContainer(owner);
        return this.copyStyleClassesTo(copyContainer);
    }

    @Override
    protected String asStringIndented(int indent) {
        StringBuffer sb = new StringBuffer();
        String layoutString = "";
        if (this.layout != null) {
            layoutString = " : " + this.layout.getClass().getSimpleName();
        }
        sb.append(super.asStringIndented(indent)).append(layoutString);
        if (this.items != null) {
            for (VisualObject o : this.items) {
                sb.append("\n");
                sb.append(o.asStringIndented(indent + 1));
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.asStringIndented(0);
    }

    public boolean isParentOf(VisualObject subObject) {
        boolean result = false;
        if (this.items != null && this.items.contains(subObject) || this == subObject) {
            return true;
        }
        List<Container> subContainers = this.getItems(Container.class);
        if (subContainers != null) {
            for (Container container : subContainers) {
                result = result || container.isParentOf(subObject);
            }
        }
        return result;
    }
}

