/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.layout;

import java.util.List;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.layout.Layout;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.Document;
import org.bndly.pdf.visualobject.VisualObject;

public class DocumentLayout
extends Layout {
    public DocumentLayout(PrintingContext printingContext, Document ownerDocument) {
        super(printingContext, ownerDocument);
    }

    @Override
    protected void performRendering(Container container) {
        Style docStyle = container.getStyle();
        if (docStyle == null) {
            docStyle = container.createStyle();
        }
        docStyle.set("margin-top", new Double(0.0));
        docStyle.set("margin-right", new Double(0.0));
        docStyle.set("margin-bottom", new Double(0.0));
        docStyle.set("margin-left", new Double(0.0));
        List<VisualObject> items = container.getItems();
        if (items != null) {
            Container subContainer;
            for (VisualObject visualObject : items) {
                Double mh;
                if (!Container.class.isAssignableFrom(visualObject.getClass())) continue;
                subContainer = (Container)visualObject;
                subContainer.doLayout();
                Double mw = subContainer.getMaxWidth();
                if (mw != null) {
                    subContainer.setWidth(mw);
                }
                if ((mh = subContainer.getMaxHeight()) == null) continue;
                subContainer.setHeight(mh);
            }
            items = container.getItems();
            for (VisualObject visualObject : items) {
                if (!Container.class.isAssignableFrom(visualObject.getClass())) continue;
                subContainer = (Container)visualObject;
                subContainer.setRelativePosition(Point2D.ZERO);
            }
        }
    }

    @Override
    protected Double getMaxContentWidth(Container container) {
        return null;
    }
}

