/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.output;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.bndly.pdf.layout.TextSizeStrategy;
import org.bndly.pdf.output.AbstractPDFPrinterStrategy;
import org.bndly.pdf.output.FontBinding;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFontTextSizeStrategy
extends AbstractPDFPrinterStrategy
implements TextSizeStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PDFontTextSizeStrategy.class);

    @Override
    public double calculateWidthForText(Text text) {
        Style style = text.getCalculatedStyle();
        Double fontSize = (Double)style.get("font-size");
        if (fontSize == null) {
            throw new IllegalStateException("fontsize for text '" + text.getValue() + "' could not be determined.");
        }
        String fontName = (String)style.get("font-family");
        if (fontName == null) {
            throw new IllegalStateException("fontName for text '" + text.getValue() + "' could not be determined.");
        }
        FontBinding binding = this.getPdfPrinter().getFontBinding(fontName, this.getPdfPrinter().getFontWeight(style), this.getPdfPrinter().getFontStyle(style));
        if (binding != null) {
            PDFont pdFont = binding.getPdFont();
            try {
                return (double)pdFont.getStringWidth(text.getValue()) / 1000.0 * fontSize;
            }
            catch (IOException e) {
                LOG.error("failed to calculate text width for text with font " + fontName + ": " + e.getMessage(), (Throwable)e);
            }
        }
        throw new RuntimeException("could not determine text width, because the font binding for " + fontName + " was not found.");
    }

    @Override
    public double calculateHeightForText(Text text) {
        Style style = text.getCalculatedStyle();
        Double fontsize = (Double)style.get("font-size");
        Double lineHeight = (Double)style.get("line-height");
        if (lineHeight != null) {
            fontsize = fontsize * lineHeight;
        }
        return fontsize;
    }
}

