/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.style;

import java.util.List;
import org.bndly.css.CSSAttribute;
import org.bndly.css.CSSStyle;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.css.CSSSelectorMatcher;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.VisualObject;

public class CalculatedStyle
extends Style {
    public CalculatedStyle(PrintingContext context, PrintingObject owner) {
        super(context, owner);
    }

    public static Style createFrom(VisualObject object) {
        CalculatedStyle style = new CalculatedStyle(object.getContext(), object);
        CalculatedStyle.mergeStyleFromTo(object, style);
        return style;
    }

    private static void mergeStyleFromTo(VisualObject object, CalculatedStyle style) {
        PrintingContext ctx = style.getContext();
        List<CSSStyle> allStyles = ctx.getStyles();
        CSSSelectorMatcher matcher = new CSSSelectorMatcher();
        if (allStyles != null) {
            for (CSSStyle cssStyle : allStyles) {
                List attributes;
                if (!matcher.styleAppliesOn(cssStyle, object) || (attributes = cssStyle.getAttributes()) == null) continue;
                for (CSSAttribute cssAttribute : attributes) {
                    String attributeValue = cssAttribute.getValue();
                    Object filteredValue = CalculatedStyle.filterAttributeValue(attributeValue);
                    String attributeName = cssAttribute.getName();
                    style.superSet(attributeName, filteredValue);
                }
            }
        }
    }

    private static Object filterAttributeValue(String rawValue) {
        Object value = rawValue;
        if (rawValue.charAt(0) == '\"' && rawValue.charAt(rawValue.length() - 1) == '\"') {
            value = rawValue.substring(1, rawValue.length() - 1);
        } else {
            String rawDoubleValue = rawValue;
            if (rawValue.endsWith("pt")) {
                rawDoubleValue = rawValue.replace("pt", "");
            }
            try {
                Double d = new Double(rawDoubleValue);
                value = d;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private void superSet(String attributeName, Object attributeValue) {
        super.set(attributeName, attributeValue);
    }

    @Override
    public void set(String attributeName, Object attributeValue) {
        throw new IllegalAccessError("you are working on a calculated style. this means you are not allowed to add or change any style attributes.");
    }
}

