/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.visualobject;

import java.util.List;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.visualobject.Container;
import org.bndly.pdf.visualobject.Text;
import org.bndly.pdf.visualobject.VisualObject;

public class Paragraph
extends Container {
    public Paragraph(PrintingContext context, PrintingObject owner) {
        super(context, owner);
        this.setLayout(this.getContext().createVerticalLayout(this));
    }

    @Override
    public void add(VisualObject object) {
        if (!object.is(Text.class)) {
            throw new IllegalArgumentException("a paragraph " + this.getItemId() + " can not contain " + object.getClass().getSimpleName() + " " + object.getItemId());
        }
        super.add(object);
    }

    @Override
    public Paragraph copyToWithoutChildren(VisualObject owner) {
        Paragraph copyContainer = this.getContext().createParagraph(owner);
        return this.copyStyleClassesTo(copyContainer);
    }

    @Override
    public Paragraph copyTo(VisualObject owner) {
        Paragraph copyContainer = this.getContext().createParagraph(owner);
        List<VisualObject> subs = this.getItems();
        if (subs != null) {
            for (VisualObject sub : subs) {
                sub.copyTo(copyContainer);
            }
        }
        return copyContainer;
    }
}

