/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.visualobject;

import java.util.List;
import org.bndly.pdf.Point2D;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.PrintingObject;
import org.bndly.pdf.PrintingObjectImpl;
import org.bndly.pdf.style.CalculatedStyle;
import org.bndly.pdf.style.Style;
import org.bndly.pdf.visualobject.Container;

public abstract class VisualObject
extends PrintingObjectImpl {
    private Double minWidth;
    private Double width;
    private Double maxWidth;
    private Double minHeight;
    private Double height;
    private Double maxHeight;
    private Point2D relativePosition = Point2D.ZERO;
    private Style style;
    protected Container ownerContainer;
    private String styleClasses;

    public VisualObject(PrintingContext context, PrintingObject owner) {
        super(context, owner);
    }

    public Container getOwnerContainer() {
        return this.ownerContainer;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style createStyle() {
        this.style = new Style(this.getContext(), this);
        return this.style;
    }

    public Double getMinWidth() {
        if (this.minWidth != null) {
            return this.minWidth;
        }
        Style s = this.getCalculatedStyle();
        return (Double)s.get("width");
    }

    public void setMinWidth(Double minWidth) {
        this.minWidth = minWidth;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getMaxWidth() {
        if (this.maxWidth != null) {
            return this.maxWidth;
        }
        Style s = this.getCalculatedStyle();
        return (Double)s.get("width");
    }

    public void setMaxWidth(Double maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Double getMinHeight() {
        if (this.minHeight != null) {
            return this.minHeight;
        }
        Style s = this.getCalculatedStyle();
        return (Double)s.get("height");
    }

    public void setMinHeight(Double minHeight) {
        this.minHeight = minHeight;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Double getMaxHeight() {
        if (this.maxHeight != null) {
            return this.maxHeight;
        }
        Style s = this.getCalculatedStyle();
        return (Double)s.get("height");
    }

    public void setMaxHeight(Double maxHeight) {
        this.maxHeight = maxHeight;
    }

    public Point2D getRelativePosition() {
        return this.relativePosition;
    }

    public void setRelativePosition(Point2D relativePosition) {
        this.relativePosition = relativePosition;
    }

    public Style getCalculatedStyle() {
        return CalculatedStyle.createFrom(this);
    }

    public Double getRatio() {
        Double w = this.getWidth();
        Double h = this.getHeight();
        if (w != null && h != null) {
            return w / h;
        }
        return null;
    }

    public String toString() {
        return this.getItemId() + " - w:" + this.getWidth() + " h:" + this.getHeight();
    }

    protected String asStringIndented(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        sb.append(this.asString());
        return sb.toString();
    }

    protected String asString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append(" (").append(this.getItemId()).append(", id: ").append(this.getId()).append(", w: ").append(this.getWidth()).append(", h: ").append(this.getHeight()).append(", x: ").append(this.relativePosition.getX()).append(", y: ").append(this.relativePosition.getY()).append(")").toString();
    }

    public Point2D getAbsolutePosition() {
        Point2D abs = this.getRelativePosition();
        for (Container o = this.getOwnerContainer(); o != null; o = o.getOwnerContainer()) {
            Point2D p = o.getRelativePosition();
            abs = abs.moveX(p.getX()).moveY(p.getY());
        }
        return abs;
    }

    public <T extends VisualObject> T getOwnerContainerAs(Class<T> type) {
        return (T)((VisualObject)this.getOwnerContainer().as(type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VisualObject getNextSibling() {
        List<VisualObject> items = this.ownerContainer.getItems();
        if (items == null) throw new IllegalStateException("visual object is refering to an owner container, that has no sub items.");
        int i = items.indexOf(this);
        if (i <= -1) throw new IllegalStateException("visual object is refering to an owner container, but the visualObject is not part of the sub items.");
        if (i + 1 >= items.size()) return null;
        return items.get(i + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VisualObject getPreviousSibling() {
        List<VisualObject> items = this.ownerContainer.getItems();
        if (items == null) throw new IllegalStateException("visual object is refering to an owner container, that has no sub items.");
        int i = items.indexOf(this);
        if (i <= -1) throw new IllegalStateException("visual object is refering to an owner container, but the visualObject is not part of the sub items.");
        if (i - 1 < 0) return null;
        return items.get(i - 1);
    }

    protected abstract VisualObject copyTo(VisualObject var1);

    public final VisualObject copyTo(Container container) {
        VisualObject copy = this.copyTo((VisualObject)container);
        container.add(copy);
        return copy;
    }

    protected final <E extends VisualObject> E copyStyleClassesTo(E copy) {
        copy.setStyleClasses(this.styleClasses);
        return copy;
    }

    protected final VisualObject copyAttributesTo(VisualObject copy) {
        copy.setMaxHeight(this.maxHeight);
        copy.setMaxWidth(this.maxWidth);
        copy.setMinHeight(this.minHeight);
        copy.setMinWidth(this.minWidth);
        copy.setWidth(this.width);
        copy.setHeight(this.height);
        if (this.getItemId() != null) {
            copy.setItemId(this.getItemId() + "Clone");
        }
        copy.setStyleClasses(this.styleClasses);
        if (this.style != null) {
            Style copyStyle = copy.createStyle();
            this.style.overwriteTo(copyStyle);
        }
        return copy;
    }

    public void overflowVerticalInto(Container overflowToContainer, Double maxHeight) {
        overflowToContainer.add(this);
    }

    public String getStyleClasses() {
        return this.styleClasses;
    }

    public void setStyleClasses(String styleClasses) {
        this.styleClasses = styleClasses;
    }

    public void destroy() {
        if (this.ownerContainer != null) {
            this.ownerContainer.remove(this);
        }
    }

    public int indexInOwnerCt() {
        if (this.ownerContainer == null) {
            return -1;
        }
        return this.ownerContainer.getItems().indexOf(this);
    }
}

