/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.pdf.templating;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.common.data.io.ReplayableInputStream;
import org.bndly.common.data.io.SmartBufferOutputStream;
import org.bndly.common.velocity.api.Renderer;
import org.bndly.common.velocity.api.VelocityDataProvider;
import org.bndly.common.velocity.api.VelocityTemplate;
import org.bndly.css.CSSItem;
import org.bndly.css.CSSParsingException;
import org.bndly.css.CSSReader;
import org.bndly.css.CSSStyle;
import org.bndly.document.reader.DocumentReader;
import org.bndly.document.xml.XDocument;
import org.bndly.pdf.PrintingContext;
import org.bndly.pdf.mapper.DocumentMapper;
import org.bndly.pdf.output.InputStreamResolver;
import org.bndly.pdf.output.PDFPrinter;
import org.bndly.pdf.output.PDFPrinterImpl;
import org.bndly.pdf.templating.PDFTemplate;
import org.bndly.pdf.visualobject.Document;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DocumentFactory.class})
public class DocumentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentFactory.class);
    @Reference
    private Renderer renderer;
    private final List<VelocityDataProvider> velocityDataProviders = new ArrayList<VelocityDataProvider>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Reference(bind="addVelocityDataProvider", unbind="removeVelocityDataProvider", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=VelocityDataProvider.class)
    public void addVelocityDataProvider(VelocityDataProvider velocityDataProvider) {
        if (velocityDataProvider != null) {
            this.lock.writeLock().lock();
            try {
                this.velocityDataProviders.add(velocityDataProvider);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVelocityDataProvider(VelocityDataProvider velocityDataProvider) {
        if (velocityDataProvider != null) {
            this.lock.writeLock().lock();
            try {
                Iterator<VelocityDataProvider> iterator = this.velocityDataProviders.iterator();
                while (iterator.hasNext()) {
                    VelocityDataProvider next = iterator.next();
                    if (next != velocityDataProvider) continue;
                    iterator.remove();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemplateAvailable(String templateName) {
        this.lock.readLock().lock();
        try {
            for (VelocityDataProvider velocityDataProvider : this.velocityDataProviders) {
                if (!velocityDataProvider.exists(templateName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private XDocument buildXDocument(PDFTemplate template) {
        SmartBufferOutputStream smartOutputBuffer = SmartBufferOutputStream.newInstance();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)smartOutputBuffer, "UTF-8");
            this.renderer.render((VelocityTemplate)template, (Writer)writer);
            writer.flush();
            writer.close();
            smartOutputBuffer.flush();
            ReplayableInputStream is = smartOutputBuffer.getBufferedDataAsReplayableStream().doReplay();
            XDocument document = new DocumentReader().read((InputStream)is.noOp());
            return document;
        }
        catch (IOException ex) {
            throw new IllegalStateException("failed to render document", ex);
        }
    }

    public void renderTemplateToDocument(PDFTemplate template, String outFileName) {
        try {
            File f = new File(outFileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            this.renderTemplateToDocument(template, fos, true);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalStateException("could not render template to file " + outFileName + ": " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("could not render template to file " + outFileName + ": " + ex.getMessage(), ex);
        }
    }

    public void renderTemplateToDocument(PDFTemplate template, OutputStream outputStream) {
        this.renderTemplateToDocument(template, outputStream, false);
    }

    public void renderTemplateToDocument(PDFTemplate template, OutputStream outputStream, boolean flushAndClose) {
        XDocument xDocument = this.buildXDocument(template);
        this.renderDocument(xDocument, template.getCssNames(), outputStream, flushAndClose);
    }

    public void renderDocument(XDocument xDocument, String[] cssNames, OutputStream outputStream, boolean flushAndClose) {
        try {
            ArrayList<CSSStyle> styles = new ArrayList<CSSStyle>();
            for (String cssName : cssNames) {
                try {
                    InputStream is = this.createInputStreamResolver().resolve(cssName);
                    List items = new CSSReader().read(is);
                    if (items == null) continue;
                    for (CSSItem item : items) {
                        if (!CSSStyle.class.isInstance(item)) continue;
                        styles.add((CSSStyle)item);
                    }
                }
                catch (IllegalStateException e) {
                    LOG.error("failed to load CSS " + cssName, (Throwable)e);
                }
            }
            this.renderDocument(xDocument, styles, outputStream, flushAndClose);
        }
        catch (IOException ex) {
            throw new IllegalStateException("failed to read CSS from inputstream: " + ex.getMessage(), ex);
        }
        catch (CSSParsingException ex) {
            throw new IllegalStateException("failed to parse CSS: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(XDocument xDocument, List<CSSStyle> styles, OutputStream outputStream, boolean flushAndClose) {
        PrintingContext ctx = new PrintingContext();
        ctx.setInputStreamResolver(this.createInputStreamResolver());
        ctx.getStyles().addAll(styles);
        PDFPrinterImpl printer = ctx.createPDFPrinter();
        Document pdfdocument = new DocumentMapper().toDocument(xDocument, (PDFPrinter)printer);
        printer.print(pdfdocument, outputStream);
        if (flushAndClose) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStreamResolver createInputStreamResolver() {
        InputStreamResolver isr = new InputStreamResolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public InputStream resolve(String fileName) throws IOException {
                DocumentFactory.this.lock.readLock().lock();
                try {
                    for (VelocityDataProvider next : DocumentFactory.this.velocityDataProviders) {
                        InputStream stream = next.getStream(fileName);
                        if (stream == null) continue;
                        InputStream inputStream = stream;
                        return inputStream;
                    }
                    InputStream inputStream = null;
                    return inputStream;
                }
                finally {
                    DocumentFactory.this.lock.readLock().unlock();
                }
            }
        };
        return isr;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    @Deprecated
    public void setVelocityDataProvider(VelocityDataProvider velocityDataProvider) {
        this.addVelocityDataProvider(velocityDataProvider);
    }
}

