/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.rest.pdf.renderer;

import java.io.IOException;
import java.io.OutputStream;
import org.bndly.pdf.templating.DocumentFactory;
import org.bndly.pdf.templating.PDFTemplate;
import org.bndly.rest.api.ContentType;
import org.bndly.rest.api.Context;
import org.bndly.rest.api.ContextProvider;
import org.bndly.rest.api.Resource;
import org.bndly.rest.api.ResourceRenderer;
import org.bndly.rest.api.ResourceURI;
import org.bndly.rest.controller.api.EntityRenderer;
import org.bndly.rest.pdf.renderer.PDFResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ResourceRenderer.class, EntityRenderer.class})
@Designate(ocd=Configuration.class)
public class PDFProvider
implements ResourceRenderer,
EntityRenderer {
    @Reference
    private DocumentFactory documentFactory;
    @Reference
    private ContextProvider contextProvider;
    private String defaultCSS;
    private String defaultTemplate;

    @Activate
    public void activate(Configuration configuration) {
        this.defaultCSS = configuration.defaultCSS();
        this.defaultTemplate = configuration.defaultTemplate();
    }

    public boolean supports(Resource resource, Context context) {
        ResourceURI.Extension ext = resource.getURI().getExtension();
        if (ext != null && ext.getName().equalsIgnoreCase(ContentType.PDF.getExtension())) {
            return this.isPDFResource(resource);
        }
        ContentType ct = context.getDesiredContentType();
        if (ct != null && ct.getName().startsWith(ContentType.PDF.getName())) {
            return this.isPDFResource(resource);
        }
        return false;
    }

    private boolean isPDFResource(Resource r) {
        return PDFResource.class.isInstance(r);
    }

    public void render(Resource resource, Context context) throws IOException {
        PDFResource pr = (PDFResource)resource;
        PDFTemplate doc = new PDFTemplate();
        doc.setEntity(pr.getEntity());
        doc.setCssNames(new String[]{this.defaultCSS, pr.getCssName()});
        doc.setLocale(context.getLocale());
        doc.setTemplateName(pr.getTemplateName());
        if (!this.documentFactory.isTemplateAvailable(pr.getTemplateName())) {
            throw new IOException("template " + pr.getTemplateName() + " is not available");
        }
        this.documentFactory.renderTemplateToDocument(doc, context.getOutputStream());
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public ContentType getSupportedContentType() {
        return ContentType.PDF;
    }

    public String getSupportedEncoding() {
        return null;
    }

    public void render(Object entity, OutputStream os) throws IOException {
        PDFTemplate doc = new PDFTemplate();
        String templateName = entity == null ? this.defaultTemplate : entity.getClass().getSimpleName() + ".print.vm";
        String cssName = entity == null ? this.defaultCSS : entity.getClass().getSimpleName() + ".css";
        doc.setEntity(entity);
        doc.setCssNames(new String[]{this.defaultCSS, cssName});
        doc.setLocale(this.contextProvider.getCurrentContext().getLocale());
        doc.setTemplateName(templateName);
        if (!this.documentFactory.isTemplateAvailable(templateName)) {
            throw new IOException("template " + templateName + " is not available");
        }
        this.documentFactory.renderTemplateToDocument(doc, os);
    }

    @ObjectClassDefinition(name="PDF Resource Renderer")
    public static @interface Configuration {
        @AttributeDefinition(name="Default CSS File", description="The default CSS to pick, when a PDF is rendered without specifying any CSS.")
        public String defaultCSS() default "defaultPDF.css";

        @AttributeDefinition(name="Default Template", description="The default template to use, when no entity is provided while rendering a PDF.")
        public String defaultTemplate() default "noModelTempalte.vm";
    }
}

