/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.rest.pdf.renderer;

import org.bndly.rest.api.Resource;
import org.bndly.rest.api.ResourceProvider;
import org.bndly.rest.api.ResourceURI;

public class PDFResource
implements Resource {
    private final ResourceURI uri;
    private final ResourceProvider provider;
    private final Object entity;
    private final String cssName;
    private final String templateName;

    public PDFResource(ResourceURI uri, ResourceProvider provider, Object entity, String cssName, String templateName) {
        this.uri = uri;
        this.provider = provider;
        this.entity = entity;
        String string = this.cssName = cssName == null ? "default.css" : cssName;
        this.templateName = templateName == null ? (entity == null ? null : entity.getClass().getSimpleName() + ".vm") : templateName;
    }

    public PDFResource(ResourceURI uri, ResourceProvider provider, Object entity) {
        this.uri = uri;
        this.provider = provider;
        this.entity = entity;
        if (entity == null) {
            this.cssName = "default.css";
            this.templateName = null;
        } else {
            this.cssName = entity.getClass().getSimpleName() + ".css";
            this.templateName = entity.getClass().getSimpleName() + ".vm";
        }
    }

    public ResourceURI getURI() {
        return this.uri;
    }

    public ResourceProvider getProvider() {
        return this.provider;
    }

    public String getCssName() {
        return this.cssName;
    }

    public Object getEntity() {
        return this.entity;
    }

    public String getTemplateName() {
        return this.templateName;
    }
}

