/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.rest.pdf.controller.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.bndly.pdf.templating.DocumentFactory;
import org.bndly.rest.api.ContentType;
import org.bndly.rest.api.Context;
import org.bndly.rest.api.ResourceURIBuilder;
import org.bndly.rest.atomlink.api.annotation.AtomLink;
import org.bndly.rest.atomlink.api.annotation.AtomLinks;
import org.bndly.rest.common.beans.Services;
import org.bndly.rest.controller.api.ControllerResourceRegistry;
import org.bndly.rest.controller.api.GET;
import org.bndly.rest.controller.api.Meta;
import org.bndly.rest.controller.api.POST;
import org.bndly.rest.controller.api.Path;
import org.bndly.rest.controller.api.PathParam;
import org.bndly.rest.controller.api.Response;
import org.bndly.rest.pdf.beans.PDFDocument;
import org.bndly.rest.pdf.beans.PDFDocuments;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Path(value="pdf")
@Component(service={PDFResource.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class PDFResource {
    private DocumentFactory documentFactory;
    private String pdfTempDirectory;
    @Reference
    private ControllerResourceRegistry controllerResourceRegistry;

    @Activate
    public void activate(Configuration configuration) {
        this.pdfTempDirectory = configuration.pdfTempDirectory();
        this.controllerResourceRegistry.deploy((Object)this);
    }

    @Deactivate
    public void deactivate() {
        this.controllerResourceRegistry.undeploy((Object)this);
    }

    @GET
    @AtomLinks(value={@AtomLink(rel="pdfs", target=Services.class), @AtomLink(rel="list", target=PDFDocument.class), @AtomLink(target=PDFDocuments.class)})
    public Response listPDFs() {
        PDFDocuments docs = new PDFDocuments();
        if (this.pdfTempDirectory != null) {
            File folder = new File(this.pdfTempDirectory);
            File[] files = null;
            if (folder.isDirectory()) {
                files = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".pdf");
                    }
                });
            }
            if (files != null) {
                for (File file : files) {
                    PDFDocument doc = new PDFDocument();
                    String n = file.getName();
                    doc.setName(n.substring(0, n.length() - ".pdf".length()));
                    docs.add((Object)doc);
                }
            }
        }
        return Response.ok((Object)((Object)docs));
    }

    @GET
    @Path(value="{fileName}")
    @AtomLink(target=PDFDocument.class)
    public Response read(@PathParam(value="fileName") String fileName) {
        java.nio.file.Path path = Paths.get(this.pdfTempDirectory, new String[0]).resolve(fileName + ".pdf");
        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            return Response.status((int)404);
        }
        PDFDocument doc = new PDFDocument();
        doc.setName(fileName);
        return Response.ok((Object)((Object)doc));
    }

    @GET
    @Path(value="{fileName}.pdf")
    @AtomLink(rel="download", target=PDFDocument.class)
    public Response readPDF(@PathParam(value="fileName") String fileName) throws IOException {
        java.nio.file.Path path = Paths.get(this.pdfTempDirectory, new String[0]).resolve(fileName + ".pdf");
        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            return Response.status((int)404);
        }
        return Response.ok((Object)new FileInputStream(path.toFile())).contentType(ContentType.PDF, null);
    }

    @POST
    @AtomLink(target=PDFDocuments.class)
    public Response generatePDF(PDFDocument doc, @Meta Context context) throws IOException {
        java.nio.file.Path path = Paths.get(this.pdfTempDirectory, new String[0]).resolve(doc.getName() + ".pdf");
        Files.deleteIfExists(path);
        try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.WRITE);){
            os.flush();
            String[] cssNames = new String[]{doc.getCssName()};
            this.documentFactory.renderDocument(doc.getDocument(), cssNames, os, true);
            ResourceURIBuilder builder = context.createURIBuilder();
            String outFileName = doc.getName();
            String uri = builder.pathElement("pdf").pathElement(outFileName).build().asString();
            Response response = Response.created((String)uri);
            return response;
        }
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public void setPdfTempDirectory(String pdfTempDirectory) {
        this.pdfTempDirectory = pdfTempDirectory;
    }

    @ObjectClassDefinition(name="PDF Resource", description="The PDF resource is used to generate and provide PDF files based on templates.")
    public static @interface Configuration {
        @AttributeDefinition(name="Temp folder", description="A folder where temporary PDF data can be stored.")
        public String pdfTempDirectory();
    }
}

