/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.rest.root.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.bndly.common.json.marshalling.Marshaller;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSString;
import org.bndly.common.json.model.JSValue;
import org.bndly.common.json.serializing.JSONSerializer;
import org.bndly.rest.api.ContentType;
import org.bndly.rest.api.Context;
import org.bndly.rest.api.ResourceURI;
import org.bndly.rest.atomlink.api.AtomLinkInjector;
import org.bndly.rest.common.beans.AtomLink;
import org.bndly.rest.common.beans.Services;
import org.bndly.rest.controller.api.ControllerResourceRegistry;
import org.bndly.rest.controller.api.Documentation;
import org.bndly.rest.controller.api.GET;
import org.bndly.rest.controller.api.Meta;
import org.bndly.rest.controller.api.Path;
import org.bndly.rest.controller.api.Response;
import org.bndly.rest.descriptor.CommunicationDescriptionProviderImpl;
import org.bndly.rest.descriptor.model.LinkDescriptor;
import org.bndly.rest.descriptor.model.TypeBinding;
import org.bndly.rest.descriptor.model.TypeDescriptor;
import org.bndly.rest.descriptor.model.TypeMember;
import org.bndly.rest.descriptor.util.TypeUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Path(value="")
@Component(service={RootResourceImpl.class}, immediate=true)
public class RootResourceImpl {
    @Reference
    private CommunicationDescriptionProviderImpl communicationDescriptionProviderImpl;
    @Reference
    private AtomLinkInjector atomLinkInjector;
    @Reference
    private ControllerResourceRegistry controllerResourceRegistry;

    @Activate
    public void activate() {
        this.controllerResourceRegistry.deploy((Object)this);
    }

    @Deactivate
    public void deactivate() {
        this.controllerResourceRegistry.undeploy((Object)this);
    }

    @GET
    @org.bndly.rest.atomlink.api.annotation.AtomLink(target=Services.class)
    @Documentation(authors={"bndly@bndly.org"}, value="This is the entry point into the Bndly eBusiness Core. From here on, you will be able to digg into the existing resources.")
    public Response getServices() {
        Services services = new Services();
        return Response.ok((Object)services);
    }

    private JSObject buildCommunitcationDescriptionPayload() {
        Map<String, Object> result = this.generateCommunicationDescription();
        JSValue json = new Marshaller().marshall(result);
        JSObject wrapper = new JSObject();
        wrapper.setMembers(new LinkedHashSet());
        JSMember types = new JSMember();
        types.setName(new JSString("types"));
        types.setValue(json);
        wrapper.getMembers().add(types);
        JSMember entryPoint = new JSMember();
        entryPoint.setName(new JSString("entry"));
        Services services = this.getServicesPayload();
        AtomLink lnk = services.follow("self");
        entryPoint.setValue((JSValue)new JSString(lnk.getHref()));
        wrapper.getMembers().add(entryPoint);
        return wrapper;
    }

    private Services getServicesPayload() {
        Services services = new Services();
        this.atomLinkInjector.addDiscovery((Object)services);
        return services;
    }

    @GET
    @Path(value="communicationDescription.jsonp")
    @org.bndly.rest.atomlink.api.annotation.AtomLink(rel="communicationDescription", target=Services.class)
    @Documentation(authors={"bndly@bndly.org"}, value="This resource is used by the Bndly eBusiness Admin in order to load a machine readable description of the exchanged messages and the links between the different resources.")
    public Response getCommunicationDescription(@Meta Context context) {
        JSObject wrapper = this.buildCommunitcationDescriptionPayload();
        ResourceURI uri = context.getURI();
        ResourceURI.QueryParameter p = uri.getParameter("callback");
        String tmpCallbackName = "define";
        if (p != null && p.getValue() != null) {
            tmpCallbackName = p.getValue();
        }
        String callbackName = tmpCallbackName;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            writer.append(callbackName);
            writer.append("(");
            writer.flush();
            new JSONSerializer().serialize((JSValue)wrapper, (Writer)writer);
            writer.flush();
            writer.append(");");
            writer.flush();
            writer.close();
            byte[] communicationDescription = bos.toByteArray();
            return Response.ok((Object)new ByteArrayInputStream(communicationDescription)).contentType(new ContentType(){

                public String getName() {
                    return "application/javascript";
                }

                public String getExtension() {
                    return "js";
                }
            }, "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("could not serialize description", e);
        }
    }

    @GET
    @Path(value="communicationschema.xsd")
    @org.bndly.rest.atomlink.api.annotation.AtomLink(rel="communicationschema", target=Services.class)
    @Documentation(authors={"bndly@bndly.org"}, value="This XSD is generated from all available JAXB classes in the eBX Core.")
    public Response getCommunicationSchema(@Meta Context context) {
        String xsdAsString = this.communicationDescriptionProviderImpl.getXsdString();
        if (xsdAsString == null) {
            return Response.status((int)404);
        }
        try {
            byte[] bytes = xsdAsString.getBytes("UTF-8");
            context.setOutputContentType(ContentType.XML, "UTF-8");
            return Response.ok((Object)new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException ex) {
            return Response.status((int)500);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertTypeMemberToJSType(Class<?> javaType) {
        if (TypeUtil.isSimpleType(javaType)) {
            if (TypeUtil.isNumericType(javaType)) {
                return "Number";
            }
            if (TypeUtil.isStringType(javaType)) {
                return "String";
            }
            if (TypeUtil.isDateType(javaType)) {
                return "Date";
            }
            if (!TypeUtil.isBooleanType(javaType)) throw new IllegalStateException("unmapped java type: " + javaType);
            return "Boolean";
        }
        if (!TypeUtil.isCollection(javaType)) return javaType.getSimpleName();
        return "Collection";
    }

    private Map<String, Object> generateCommunicationDescription() {
        Map desc = this.communicationDescriptionProviderImpl.getTypeDescriptors();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : desc.entrySet()) {
            final TypeDescriptor typeDescriptor = (TypeDescriptor)entry.getValue();
            result.put(typeDescriptor.getName(), new Object(){

                public String getParent() {
                    if (typeDescriptor.getParent() == null) {
                        return null;
                    }
                    return typeDescriptor.getParent().getName();
                }

                public String getRootElement() {
                    return typeDescriptor.getRootElement();
                }

                public Boolean getReferenceType() {
                    return typeDescriptor.isReferenceType();
                }

                public List<String> getSub() {
                    ArrayList<String> l = new ArrayList<String>();
                    for (TypeDescriptor subTypeDescriptor : typeDescriptor.getSubs()) {
                        l.add(subTypeDescriptor.getName());
                    }
                    return l;
                }

                public Map<String, Object> getLinks() {
                    HashMap<String, Object> links = new HashMap<String, Object>();
                    for (final LinkDescriptor linkDescriptor : typeDescriptor.getLinks()) {
                        links.put(linkDescriptor.getRel(), new Object(){

                            public String getReturns() {
                                if (linkDescriptor.getReturns() == null) {
                                    return null;
                                }
                                return linkDescriptor.getReturns().getName();
                            }

                            public String getConsumes() {
                                if (linkDescriptor.getConsumes() == null) {
                                    return null;
                                }
                                return linkDescriptor.getConsumes().getName();
                            }

                            public String getDescription() {
                                return linkDescriptor.getDescription();
                            }
                        });
                    }
                    return links;
                }

                public Map<String, Object> getMembers() {
                    HashMap<String, Object> members = new HashMap<String, Object>();
                    for (final TypeMember typeMember : typeDescriptor.getMembers()) {
                        members.put(typeMember.getName(), new Object(){

                            public Boolean getBeanId() {
                                return typeMember.isBeanId();
                            }

                            public Boolean getCollection() {
                                return typeMember.isCollection();
                            }

                            public String getType() {
                                return RootResourceImpl.this.convertTypeMemberToJSType(typeMember.getJavaType());
                            }

                            public Map<String, String> getBindings() {
                                HashMap<String, String> bindings = new HashMap<String, String>();
                                for (TypeBinding typeBinding : typeMember.getBindings()) {
                                    bindings.put(typeBinding.getName(), RootResourceImpl.this.convertTypeMemberToJSType(typeBinding.getType()));
                                }
                                return bindings;
                            }
                        });
                    }
                    return members;
                }
            });
        }
        return result;
    }

    public void setCommunicationDescriptionProviderImpl(CommunicationDescriptionProviderImpl communicationDescriptionProviderImpl) {
        this.communicationDescriptionProviderImpl = communicationDescriptionProviderImpl;
    }

    public void setAtomLinkInjector(AtomLinkInjector atomLinkInjector) {
        this.atomLinkInjector = atomLinkInjector;
    }
}

