/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.rest.security.impl;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.bndly.common.crypto.api.Base64Service;
import org.bndly.rest.api.Context;
import org.bndly.rest.api.HeaderReader;
import org.bndly.rest.api.SecurityHandler;
import org.bndly.rest.api.StatusWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHandlerImpl
implements SecurityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandlerImpl.class);
    private static final String BASIC_HEADER_PREFIX = "Basic ";
    private final String realm;
    private final List<SecurityHandler.AuthorizationProvider> authorizationProviders;
    private final Base64Service base64Service;

    public SecurityHandlerImpl(String realm, List<SecurityHandler.AuthorizationProvider> authorizationProviders, Base64Service base64Service) {
        if (realm == null) {
            throw new IllegalArgumentException("realm is not allowed to be null");
        }
        this.realm = realm;
        if (authorizationProviders == null) {
            throw new IllegalArgumentException("authorizationProviders is not allowed to be null");
        }
        this.authorizationProviders = authorizationProviders;
        if (base64Service == null) {
            throw new IllegalArgumentException("base64Service is not allowed to be null");
        }
        this.base64Service = base64Service;
    }

    public boolean isServableContext(Context context) {
        HeaderReader hr = context.getHeaderReader();
        String authorizationHeader = hr.read("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith(BASIC_HEADER_PREFIX)) {
            for (SecurityHandler.AuthorizationProvider next : this.authorizationProviders) {
                if (!next.isAnonymousAllowed(context)) continue;
                return true;
            }
            context.getHeaderWriter().write("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            context.getStatusWriter().write(StatusWriter.Code.UNAUTHORIZED);
            return false;
        }
        Iterator<SecurityHandler.AuthorizationProvider> iter = this.authorizationProviders.iterator();
        byte[] userAndPw = this.base64Service.base64Decode(authorizationHeader.substring(BASIC_HEADER_PREFIX.length()));
        try {
            String userAndPwString = new String(userAndPw, "UTF-8");
            int border = userAndPwString.indexOf(":");
            if (border >= 0) {
                String user = userAndPwString.substring(0, border);
                String pw = userAndPwString.substring(border + 1);
                while (iter.hasNext()) {
                    SecurityHandler.AuthorizationProvider next = iter.next();
                    if (!next.isAuthorized(context, user, pw)) continue;
                    return true;
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("could not decode user and password from basic auth header: " + ex.getMessage(), (Throwable)ex);
        }
        context.getStatusWriter().write(StatusWriter.Code.FORBIDDEN);
        return false;
    }

    public void invalidateAuthenticationData(Context context) {
    }
}

