/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.rest.security.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.bndly.common.crypto.api.Base64Service;
import org.bndly.common.osgi.util.ServiceRegistrationBuilder;
import org.bndly.rest.api.Context;
import org.bndly.rest.api.Resource;
import org.bndly.rest.api.ResourceInterceptor;
import org.bndly.rest.api.SecurityHandler;
import org.bndly.rest.security.impl.SecurityHandlerImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ResourceInterceptor.class})
@Designate(ocd=Configuration.class)
public class SecurityHandlerResourceInterceptor
implements ResourceInterceptor,
WebConsoleSecurityProvider {
    private ServiceRegistration<WebConsoleSecurityProvider> reg;
    private String realm;
    private boolean disabled;
    private final List<SecurityHandler.AuthorizationProvider> authorizationProviders = new ArrayList<SecurityHandler.AuthorizationProvider>();
    private final ReadWriteLock authorizationProvidersLock = new ReentrantReadWriteLock();
    private List<SecurityHandler.AuthorizationProvider> immutableAuthorizationProviders = Collections.EMPTY_LIST;
    @Reference
    private Base64Service base64Service;

    @Activate
    public void activate(Configuration configuration, BundleContext bundleContext) {
        this.realm = configuration.realm();
        this.disabled = configuration.disabled();
        if (this.disabled) {
            this.addAuthorizationProvider(new SecurityHandler.AuthorizationProvider(){

                public boolean isAnonymousAllowed(Context context) {
                    return true;
                }

                public boolean isAuthorized(Context context, String user, String password) {
                    return true;
                }
            });
        }
        if (configuration.actAsWebConsoleSecurityProvider()) {
            this.reg = ServiceRegistrationBuilder.newInstance(WebConsoleSecurityProvider.class, (Object)this).register(bundleContext);
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    @Reference(bind="addAuthorizationProvider", unbind="removeAuthorizationProvider", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=SecurityHandler.AuthorizationProvider.class)
    public void addAuthorizationProvider(SecurityHandler.AuthorizationProvider provider) {
        if (provider != null) {
            this.authorizationProvidersLock.writeLock().lock();
            try {
                this.authorizationProviders.add(provider);
                this.immutableAuthorizationProviders = Collections.unmodifiableList(this.authorizationProviders);
            }
            finally {
                this.authorizationProvidersLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthorizationProvider(SecurityHandler.AuthorizationProvider provider) {
        if (provider != null) {
            this.authorizationProvidersLock.writeLock().lock();
            try {
                Iterator<SecurityHandler.AuthorizationProvider> iter = this.authorizationProviders.iterator();
                while (iter.hasNext()) {
                    SecurityHandler.AuthorizationProvider next = iter.next();
                    if (next != provider) continue;
                    iter.remove();
                }
                this.immutableAuthorizationProviders = Collections.unmodifiableList(this.authorizationProviders);
            }
            finally {
                this.authorizationProvidersLock.writeLock().unlock();
            }
        }
    }

    public void beforeResourceResolving(Context context) {
        SecurityHandlerImpl securityHandlerImpl = new SecurityHandlerImpl(this.realm, this.immutableAuthorizationProviders, this.base64Service);
        context.setSecurityHandler((SecurityHandler)securityHandlerImpl);
    }

    public Resource intercept(Resource input) {
        return input;
    }

    public void doFinally(Context context) {
    }

    public Object authenticate(String user, String password) {
        for (SecurityHandler.AuthorizationProvider authorizationProvider : this.immutableAuthorizationProviders) {
            if (!authorizationProvider.isAuthorized(null, user, password)) continue;
            return user;
        }
        return null;
    }

    public boolean authorize(Object user, String role) {
        return true;
    }

    @ObjectClassDefinition(name="Security Resource Interceptor")
    public static @interface Configuration {
        @AttributeDefinition(name="Realm", description="The realm to use for the authentication")
        public String realm() default "bndly";

        @AttributeDefinition(name="Disabled", description="If disabled, any resource can be accessed.")
        public boolean disabled() default false;

        @AttributeDefinition(name="Is WebConsole Security Provider", description="If disabled, this component will not manage security of the WebConsole")
        public boolean actAsWebConsoleSecurityProvider() default true;
    }
}

