/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.beans;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.bndly.code.common.CodeGenerationContext;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeElement;
import org.bndly.code.output.JavaCodeElementStringWriter;
import org.bndly.schema.beans.ImportStateHolderImpl;
import org.bndly.schema.definition.parser.api.ParsingException;
import org.bndly.schema.definition.parser.impl.SchemaDefinitionIOImpl;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.SchemaProvider;

public abstract class AbstractSchemaBasedBeanGeneratorMojo
extends AbstractMojo {
    @Parameter
    protected String targetFolder;
    @Parameter
    protected String targetPackage;
    @Parameter
    protected String schemaProviderClass;
    @Parameter
    protected String schemaRoot;
    @Parameter
    protected List<String> schemaExtensions;
    protected ImportStateHolderImpl importStateHolder;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Schema schema;
            if (this.schemaProviderClass != null) {
                Class<?> cls = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.schemaProviderClass);
                SchemaProvider schemaProvider = (SchemaProvider)cls.newInstance();
                schema = schemaProvider.getSchema();
            } else if (this.schemaRoot != null) {
                try {
                    if (this.schemaExtensions != null) {
                        String[] args = new String[this.schemaExtensions.size()];
                        for (int i = 0; i < this.schemaExtensions.size(); ++i) {
                            String extensionPath;
                            args[i] = extensionPath = this.schemaExtensions.get(i);
                        }
                        schema = new SchemaDefinitionIOImpl().parse(this.schemaRoot, args);
                    }
                    schema = new SchemaDefinitionIOImpl().parse(this.schemaRoot, new String[0]);
                }
                catch (ParsingException ex) {
                    throw new MojoExecutionException("failed to parse schema definition: " + ex.getMessage(), (Exception)((Object)ex));
                }
            } else {
                throw new MojoExecutionException("no schema provided");
            }
            CodeGenerationContext ctx = new CodeGenerationContext();
            this.importStateHolder = (ImportStateHolderImpl)ctx.create(ImportStateHolderImpl.class);
            ctx.setBasePackage(this.targetPackage);
            String targetPackageAsPathSegments = this.targetPackage.replaceAll("\\.", "/");
            String folder = this.targetFolder;
            if (!folder.endsWith("/")) {
                folder = folder + "/";
            }
            folder = folder + targetPackageAsPathSegments;
            File path = new File(folder);
            path.mkdirs();
            this.doCodeGenerationWithSchema(schema, ctx, path);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new MojoExecutionException("could not instantiate schema provider class: " + this.schemaProviderClass + ": " + ex.getMessage(), (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not write generated code to file. " + ex.getMessage(), (Exception)ex);
        }
    }

    protected void writeCodeToFile(CodeBlock code, File path, NamedAttributeHolder nah, String prefix, String suffix) throws IOException {
        this.writeCodeToFile(code, path, prefix + nah.getName() + suffix + ".java");
    }

    protected void writeCodeToFile(CodeBlock code, File path, NamedAttributeHolder nah, String suffix) throws IOException {
        this.writeCodeToFile(code, path, nah.getName() + suffix + ".java");
    }

    protected void writeCodeToFile(CodeBlock code, File path, String fileName) throws IOException {
        String codeAsString = JavaCodeElementStringWriter.toString((CodeElement)code);
        File f = new File(path, fileName);
        f.createNewFile();
        FileWriter w = new FileWriter(f);
        w.write(codeAsString);
        w.flush();
        w.close();
    }

    protected abstract void doCodeGenerationWithSchema(Schema var1, CodeGenerationContext var2, File var3) throws IOException, MojoExecutionException, MojoFailureException;
}

