/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.beans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.bndly.code.common.CodeGenerationContext;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeBracket;
import org.bndly.code.model.CodeElement;
import org.bndly.code.model.CodeImport;
import org.bndly.code.model.CodeLine;
import org.bndly.code.model.CodePackage;
import org.bndly.code.output.JavaCodeElementStringWriter;
import org.bndly.code.renderer.ImportResolver;
import org.bndly.schema.beans.AbstractSchemaBasedBeanGeneratorMojo;
import org.bndly.schema.beans.ImportStateHolder;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;
import org.bndly.schema.model.BooleanAttribute;
import org.bndly.schema.model.CryptoAttribute;
import org.bndly.schema.model.DateAttribute;
import org.bndly.schema.model.DecimalAttribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.JSONAttribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.StringAttribute;
import org.bndly.schema.model.Type;

@Mojo(name="generate")
public class SchemaBeanGeneratorMojo
extends AbstractSchemaBasedBeanGeneratorMojo {
    @Override
    protected void doCodeGenerationWithSchema(Schema schema, CodeGenerationContext ctx, File targetPath) throws IOException, MojoExecutionException, MojoFailureException {
        List mixins;
        ctx.setImportResolver(new ImportResolver(){

            public String resolveImport(String simpleName) {
                if (simpleName == null) {
                    throw new IllegalArgumentException("can not resolve import when simpleName is null.");
                }
                return simpleName;
            }
        });
        List types = schema.getTypes();
        if (types != null) {
            for (Type type : types) {
                this.importStateHolder.reset();
                CodeBlock code = this.generateCodeForType(type, ctx);
                this.writeCodeToFile(code, targetPath, (NamedAttributeHolder)type);
            }
        }
        if ((mixins = schema.getMixins()) != null) {
            for (Mixin mixin : mixins) {
                this.importStateHolder.reset();
                CodeBlock code = this.generateCodeForMixin(mixin, ctx);
                this.writeCodeToFile(code, targetPath, (NamedAttributeHolder)mixin);
            }
        }
    }

    private CodeBlock generateCodeForMixin(Mixin mixin, CodeGenerationContext ctx) {
        this.getLog().info((CharSequence)("generating java interface for mixin " + mixin.getName()));
        CodePackage block = (CodePackage)ctx.create(CodePackage.class, new Object[]{ctx.getBasePackage()});
        CodeBlock importBlock = (CodeBlock)block.createContained(CodeBlock.class);
        block.line(SchemaBeanGeneratorMojo.convertToJavaDoc(SchemaBeanGeneratorMojo.generateTypeJavaDoc((NamedAttributeHolder)mixin), 0));
        block.line("public interface ").append(mixin.getName());
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        this.generateGetterAndSetter((NamedAttributeHolder)mixin, bracket, importBlock);
        return block;
    }

    private CodeBlock generateCodeForType(Type type, CodeGenerationContext ctx) {
        this.getLog().info((CharSequence)("generating java interface for type " + type.getName()));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        block.line("package ").append(ctx.getBasePackage()).append(";");
        CodeBlock importBlock = (CodeBlock)block.createContained(CodeBlock.class);
        block.line(SchemaBeanGeneratorMojo.convertToJavaDoc(SchemaBeanGeneratorMojo.generateTypeJavaDoc((NamedAttributeHolder)type), 0));
        CodeLine l = block.line("public interface ").append(type.getName());
        boolean first = true;
        if (type.getMixins() != null) {
            for (Mixin mixin : type.getMixins()) {
                first = this.appendExtendedAttributeHolder(first, l, (NamedAttributeHolder)mixin);
            }
        }
        if (type.getSuperType() != null) {
            this.appendExtendedAttributeHolder(first, l, (NamedAttributeHolder)type.getSuperType());
        }
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        this.generateGetterAndSetter((NamedAttributeHolder)type, bracket, importBlock);
        return block;
    }

    protected static String getJavaTypeNameForAttribute(Attribute attribute, CodeBlock importBlock, ImportStateHolder importStateHolder) {
        return SchemaBeanGeneratorMojo.getJavaTypeNameForAttribute(attribute, importBlock, importStateHolder, false);
    }

    protected static String getJavaTypeNameForAttribute(Attribute attribute, CodeBlock importBlock, ImportStateHolder importStateHolder, boolean importAttributeHolders) {
        if (StringAttribute.class.isInstance(attribute)) {
            return "String";
        }
        if (CryptoAttribute.class.isInstance(attribute)) {
            return "String";
        }
        if (DecimalAttribute.class.isInstance(attribute)) {
            Integer length;
            DecimalAttribute att = (DecimalAttribute)DecimalAttribute.class.cast(attribute);
            Integer dp = att.getDecimalPlaces();
            if (dp == null) {
                dp = 0;
            }
            if ((length = att.getLength()) == null) {
                if (dp == 0) {
                    return "Long";
                }
                return "Double";
            }
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, BigDecimal.class, importStateHolder);
            return "BigDecimal";
        }
        if (BooleanAttribute.class.isInstance(attribute)) {
            return "Boolean";
        }
        if (DateAttribute.class.isInstance(attribute)) {
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, Date.class, importStateHolder);
            return "Date";
        }
        if (NamedAttributeHolderAttribute.class.isInstance(attribute)) {
            NamedAttributeHolderAttribute att = (NamedAttributeHolderAttribute)NamedAttributeHolderAttribute.class.cast(attribute);
            if (importAttributeHolders) {
                SchemaBeanGeneratorMojo.assertIsImported(importBlock, importBlock.getContext().getImportResolver().resolveImport(att.getNamedAttributeHolder().getName()), importStateHolder);
            }
            return att.getNamedAttributeHolder().getName();
        }
        if (InverseAttribute.class.isInstance(attribute)) {
            InverseAttribute att = (InverseAttribute)InverseAttribute.class.cast(attribute);
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, List.class, importStateHolder);
            if (importAttributeHolders) {
                SchemaBeanGeneratorMojo.assertIsImported(importBlock, importBlock.getContext().getImportResolver().resolveImport(att.getReferencedAttributeHolder().getName()), importStateHolder);
            }
            return "List<" + att.getReferencedAttributeHolder().getName() + ">";
        }
        if (JSONAttribute.class.isInstance(attribute)) {
            JSONAttribute att = (JSONAttribute)JSONAttribute.class.cast(attribute);
            if (importAttributeHolders) {
                SchemaBeanGeneratorMojo.assertIsImported(importBlock, importBlock.getContext().getImportResolver().resolveImport(att.getNamedAttributeHolder().getName()), importStateHolder);
            }
            return att.getNamedAttributeHolder().getName();
        }
        if (BinaryAttribute.class.isInstance(attribute)) {
            BinaryAttribute att = (BinaryAttribute)BinaryAttribute.class.cast(attribute);
            if (att.getAsByteArray() != null && att.getAsByteArray().booleanValue()) {
                return "byte[]";
            }
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, InputStream.class, importStateHolder);
            return "InputStream";
        }
        throw new IllegalArgumentException("unsupported attribute type");
    }

    private void generateGetterAndSetter(NamedAttributeHolder nah, CodeBracket bracket, CodeBlock importBlock) {
        if (nah.getAttributes() != null) {
            for (Attribute attribute : nah.getAttributes()) {
                String javaTypeName = SchemaBeanGeneratorMojo.getJavaTypeNameForAttribute(attribute, importBlock, this.importStateHolder);
                String ucAttributeName = SchemaBeanGeneratorMojo.upperCaseFirstLetter(attribute.getName());
                SchemaBeanGeneratorMojo.convertToJavaDoc(SchemaBeanGeneratorMojo.generateGetterJavaDoc(attribute), (CodeBlock)bracket);
                bracket.line(javaTypeName).append(" get").append(ucAttributeName).append("();");
                SchemaBeanGeneratorMojo.convertToJavaDoc(SchemaBeanGeneratorMojo.generateSetterJavaDoc(attribute), (CodeBlock)bracket);
                bracket.line("void set").append(ucAttributeName).append("(").append(javaTypeName).append(" ").append(attribute.getName()).append(");");
            }
        }
    }

    protected static String upperCaseFirstLetter(String string) {
        string = string.length() > 1 ? string.substring(0, 1).toUpperCase() + string.substring(1) : string.toUpperCase();
        return string;
    }

    private boolean appendExtendedAttributeHolder(boolean first, CodeLine l, NamedAttributeHolder nah) {
        if (first) {
            first = false;
            l.append(" extends ");
        } else {
            l.append(", ");
        }
        l.append(nah.getName());
        return first;
    }

    private void writeCodeToFile(CodeBlock code, File path, NamedAttributeHolder nah) throws IOException {
        String codeAsString = JavaCodeElementStringWriter.toString((CodeElement)code);
        File f = new File(path, nah.getName() + ".java");
        f.createNewFile();
        FileWriter w = new FileWriter(f);
        w.write(codeAsString);
        w.flush();
        w.close();
    }

    protected static void assertIsImported(CodeBlock importBlock, String typeToImport, ImportStateHolder importStateHolder) {
        if (!importStateHolder.hasBeenImported(typeToImport)) {
            importBlock.createContained(CodeImport.class, new Object[]{typeToImport});
        }
    }

    protected static void assertIsImported(CodeBlock importBlock, Class<?> typeToImport, ImportStateHolder importStateHolder) {
        SchemaBeanGeneratorMojo.assertIsImported(importBlock, typeToImport.getName(), importStateHolder);
    }

    static String generateSetterJavaDoc(Attribute attribute) {
        StringBuilder sb = new StringBuilder();
        sb.append("Sets the value for the attribute '").append(attribute.getName()).append("'.\n");
        if (attribute.isMandatory()) {
            sb.append("The attribute is declared as mandatory.\n");
        }
        if (attribute.isVirtual()) {
            sb.append("The attribute is declared as virtual. You can not use it in queries!\n");
        }
        if (StringAttribute.class.isInstance(attribute)) {
            StringAttribute sa = (StringAttribute)attribute;
            Integer length = sa.getLength();
            if (length != null) {
                sb.append("The value is allowed to have a maximum of ").append(length).append(" characters.\n");
            }
            if (sa.getIsLong() != null && sa.getIsLong().booleanValue()) {
                sb.append("The value is allowed to be long. This means it can not be used in queries.\n");
            }
        } else if (DecimalAttribute.class.isInstance(attribute)) {
            DecimalAttribute da = (DecimalAttribute)attribute;
            if (da.getLength() != null) {
                sb.append("The value is allowed to have ").append(da.getLength()).append(" digits (precision).\n");
            }
            if (da.getDecimalPlaces() != null) {
                sb.append("The value is allowed to have ").append(da.getDecimalPlaces()).append(" decimal places (scale).\n");
            }
        } else if (JSONAttribute.class.isInstance(attribute)) {
            sb.append("The value is stored as JSON data and can not be queried.\n");
        } else if (BinaryAttribute.class.isInstance(attribute)) {
            sb.append("The value is stored as a blob and can not be queried.\n");
        }
        String docs = (String)attribute.getAnnotations().get("docs");
        if (docs != null) {
            sb.append(docs).append("\n");
        }
        sb.append("@param ").append(attribute.getName()).append(" value of '").append(attribute.getName()).append("'");
        return sb.toString();
    }

    static String generateGetterJavaDoc(Attribute attribute) {
        String docs;
        StringBuilder sb = new StringBuilder();
        sb.append("Returns the value for the attribute '").append(attribute.getName()).append("'.\n");
        if (attribute.isVirtual()) {
            sb.append("The attribute is declared virtual. Therefore your application has to provide logic, that implements the resolving of the attribute values.\n");
        }
        if ((docs = (String)attribute.getAnnotations().get("docs")) != null) {
            sb.append(docs).append("\n");
        }
        sb.append("@return value of '").append(attribute.getName()).append("'");
        return sb.toString();
    }

    static String generateTypeJavaDoc(NamedAttributeHolder namedAttributeHolder) {
        String docs;
        StringBuilder sb = new StringBuilder();
        sb.append("This interface corresponds to the schema ");
        if (Type.class.isInstance(namedAttributeHolder)) {
            sb.append("type");
        } else if (Mixin.class.isInstance(namedAttributeHolder)) {
            sb.append("mixin");
        } else {
            sb.append("element");
        }
        sb.append(" '").append(namedAttributeHolder.getName()).append("' from the schema '").append(namedAttributeHolder.getSchema().getName()).append("' with the namespace '").append(namedAttributeHolder.getSchema().getNamespace()).append("'.\n");
        if (namedAttributeHolder.isVirtual()) {
            sb.append("It is declared virtual and can therefore not be queried.\n");
        }
        if ((docs = (String)namedAttributeHolder.getAnnotations().get("docs")) != null) {
            sb.append(docs).append("\n");
        }
        sb.append("@author ").append(SchemaBeanGeneratorMojo.class.getName());
        return sb.toString();
    }

    static void convertToJavaDoc(String documentation, CodeBlock codeBlock) {
        BufferedReader br = new BufferedReader(new StringReader(documentation));
        try {
            String line;
            codeBlock.line("/**");
            while ((line = br.readLine()) != null) {
                codeBlock.line(" * " + line.replaceAll("\\*", "&#42;"));
            }
            codeBlock.line(" */");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String convertToJavaDoc(String documentation, int indent) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(documentation));
        try {
            String line;
            int i;
            for (i = 0; i < indent; ++i) {
                sb.append('\t');
            }
            sb.append("/**\n");
            while ((line = br.readLine()) != null) {
                for (i = 0; i < indent; ++i) {
                    sb.append('\t');
                }
                sb.append(" * ");
                sb.append(line.replaceAll("\\*", "&#42;"));
                sb.append('\n');
            }
            for (i = 0; i < indent; ++i) {
                sb.append('\t');
            }
            sb.append(" */");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

