/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.beans;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bndly.code.common.CodeGenerationContext;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeBracket;
import org.bndly.code.renderer.ImportResolver;
import org.bndly.schema.beans.AbstractSchemaBasedBeanGeneratorMojo;
import org.bndly.schema.beans.SchemaBeanGeneratorMojo;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.Type;

@Mojo(name="generateServiceImpl")
public class SchemaServiceImplGeneratorMojo
extends AbstractSchemaBasedBeanGeneratorMojo {
    protected static final String GENERIC_RESOURCE_SERVICE_IMPL = "org.bndly.common.service.shared.GenericResourceServiceImpl";
    protected static final String SERVICE_IMPL_SUFFIX = "ServiceImpl";
    @Parameter
    protected String generatedServiceApiPackage;
    @Parameter
    protected String schemaBeanSourcePackage;
    @Parameter
    protected String schemaRestBeanSourcePackage;
    @Parameter
    protected String generatedModelImplPackage;

    @Override
    protected void doCodeGenerationWithSchema(Schema schema, CodeGenerationContext ctx, File path) throws IOException, MojoExecutionException, MojoFailureException {
        ctx.setImportResolver(new ImportResolver(){

            public String resolveImport(String simpleName) {
                if (simpleName == null) {
                    throw new IllegalArgumentException("can not resolve import when simpleName is null.");
                }
                return simpleName;
            }
        });
        List types = schema.getTypes();
        if (types != null) {
            for (Type type : types) {
                if (type.isAbstract() || type.isVirtual()) continue;
                this.importStateHolder.reset();
                CodeBlock code = this.generateCodeForType(type, ctx);
                this.writeCodeToFile(code, path, (NamedAttributeHolder)type, "Default", SERVICE_IMPL_SUFFIX);
            }
        }
    }

    private CodeBlock generateCodeForType(Type type, CodeGenerationContext ctx) {
        String tName = type.getName();
        String genServiceCName = this.getGeneratedServiceClassName(tName);
        this.getLog().info((CharSequence)("generating java service client implementation for type " + tName));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        block.line("package ").append(ctx.getBasePackage()).append(";");
        block.line("");
        block.line("import ").append(this.schemaBeanSourcePackage).append(".").append(tName).append(";");
        block.line("import ").append(this.generatedModelImplPackage).append(".").append(tName).append("Impl;");
        block.line("import ").append(this.schemaRestBeanSourcePackage).append(".").append(tName).append("ListRestBean;");
        block.line("import ").append(this.schemaRestBeanSourcePackage).append(".").append(tName).append("ReferenceRestBean;");
        block.line("import ").append(this.schemaRestBeanSourcePackage).append(".").append(tName).append("RestBean;");
        block.line("import ").append(this.generatedServiceApiPackage).append(".").append(SchemaBeanGeneratorMojo.upperCaseFirstLetter(tName)).append("Service").append(";");
        block.line("import ").append(this.generatedServiceApiPackage).append(".").append(genServiceCName).append(";");
        block.line("import ").append(GENERIC_RESOURCE_SERVICE_IMPL).append(";");
        block.line("");
        block.line("public class ").append(genServiceCName).append("Impl").append(" extends ").append("GenericResourceServiceImpl");
        block.line("\t\t<").append(tName).append(", ").append(tName).append("ListRestBean").append(", ").append(tName).append("ReferenceRestBean").append(", ").append(tName).append("RestBean").append(">");
        block.line("\timplements ").append(genServiceCName);
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        bracket.line("");
        bracket.line("@Override");
        bracket.line("public ").append(tName).append(" instantiateModel() ");
        CodeBracket methodbracket = (CodeBracket)bracket.createContained(CodeBracket.class);
        methodbracket.line("return new ").append(tName).append("Impl();");
        bracket.line("");
        bracket.line("@Override");
        bracket.line("public String ").append("getDefaultServiceName() ");
        methodbracket = (CodeBracket)bracket.createContained(CodeBracket.class);
        methodbracket.line("return ").append(SchemaBeanGeneratorMojo.upperCaseFirstLetter(tName)).append("Service").append(".NAME;");
        return block;
    }

    private String getGeneratedServiceClassName(String typeName) {
        return "Default" + SchemaBeanGeneratorMojo.upperCaseFirstLetter(typeName) + "Service";
    }
}

