/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.beans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bndly.code.common.CodeGenerationContext;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeBracket;
import org.bndly.code.model.CodeLine;
import org.bndly.code.renderer.ImportResolver;
import org.bndly.schema.beans.AbstractSchemaBasedBeanGeneratorMojo;
import org.bndly.schema.beans.ImportStateHolder;
import org.bndly.schema.beans.SchemaBeanGeneratorMojo;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.UniqueConstraint;

@Mojo(name="generateClientModel")
public class ClientModelBeanGeneratorMojo
extends AbstractSchemaBasedBeanGeneratorMojo {
    @Parameter
    protected String schemaBeanSourcePackage;

    @Override
    protected void doCodeGenerationWithSchema(Schema schema, CodeGenerationContext ctx, File path) throws IOException, MojoExecutionException, MojoFailureException {
        List mixins;
        final HashMap<String, Object> mapOfNamedAttributeHolders = new HashMap<String, Object>();
        List types = schema.getTypes();
        if (types != null) {
            for (Type type : types) {
                mapOfNamedAttributeHolders.put(type.getName(), type);
            }
        }
        if ((mixins = schema.getMixins()) != null) {
            for (Mixin mixin : mixins) {
                mapOfNamedAttributeHolders.put(mixin.getName(), mixin);
            }
        }
        List uniqueConstraints = schema.getUniqueConstraints();
        HashMap<String, List<UniqueConstraint>> uniqueConstraintsByAttributeHolderName = Collections.EMPTY_MAP;
        if (uniqueConstraints != null) {
            uniqueConstraintsByAttributeHolderName = new HashMap<String, List<UniqueConstraint>>();
            for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
                ArrayList<UniqueConstraint> list = (ArrayList<UniqueConstraint>)uniqueConstraintsByAttributeHolderName.get(uniqueConstraint.getHolder().getName());
                if (list == null) {
                    list = new ArrayList<UniqueConstraint>();
                    uniqueConstraintsByAttributeHolderName.put(uniqueConstraint.getHolder().getName(), list);
                }
                list.add(uniqueConstraint);
            }
        }
        ctx.setImportResolver(new ImportResolver(){

            public String resolveImport(String simpleName) {
                NamedAttributeHolder ah = (NamedAttributeHolder)mapOfNamedAttributeHolders.get(simpleName);
                if (ah != null) {
                    return ClientModelBeanGeneratorMojo.this.schemaBeanSourcePackage + "." + ah.getName();
                }
                if ("Date".equals(simpleName)) {
                    return Date.class.getName();
                }
                if ("InputStream".equals(simpleName)) {
                    return InputStream.class.getName();
                }
                if ("BigDecimal".equals(simpleName)) {
                    return BigDecimal.class.getName();
                }
                return simpleName;
            }
        });
        if (types != null) {
            for (Type type : types) {
                this.importStateHolder.reset();
                CodeBlock code = this.generatePojoImplementationForSchemaType(type, ctx, uniqueConstraintsByAttributeHolderName);
                this.writeCodeToFile(code, path, (NamedAttributeHolder)type, "Impl");
            }
        }
    }

    private CodeBlock generatePojoImplementationForSchemaType(Type type, CodeGenerationContext ctx, Map<String, List<UniqueConstraint>> uniqueConstraintsByAttributeHolderName) {
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        block.line("package " + this.targetPackage + ";");
        block.line("");
        CodeBlock importBlock = (CodeBlock)block.createContained(CodeBlock.class);
        block.line("");
        boolean hasSubTypes = type.getSubTypes() != null && !type.getSubTypes().isEmpty();
        String resolved = importBlock.getContext().getImportResolver().resolveImport(type.getName());
        if (resolved != null) {
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, resolved, (ImportStateHolder)this.importStateHolder);
        }
        CodeLine line = block.line("public " + (type.isAbstract() ? "abstract " : "") + "class " + type.getName() + "Impl");
        if (hasSubTypes) {
            line.append("<E extends " + type.getName() + ">");
        }
        if (type.getSuperType() != null) {
            line.append(" extends " + type.getSuperType().getName() + "Impl<" + type.getName() + ">");
        } else {
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, "org.bndly.common.service.model.api.AbstractEntity", (ImportStateHolder)this.importStateHolder);
            line.append(" extends AbstractEntity");
            if (hasSubTypes) {
                line.append("<E>");
            } else {
                line.append("<" + type.getName() + ">");
            }
        }
        line.append(" implements " + type.getName());
        CodeBracket classImplementationBlock = (CodeBracket)block.createContained(CodeBracket.class);
        CodeBlock fieldsBlock = (CodeBlock)classImplementationBlock.createContained(CodeBlock.class);
        CodeBlock methodsBlock = (CodeBlock)classImplementationBlock.createContained(CodeBlock.class);
        if (this.typeRequiresIdField(type)) {
            SchemaBeanGeneratorMojo.assertIsImported(importBlock, "org.bndly.common.service.model.api.ReferenceAttribute", (ImportStateHolder)this.importStateHolder);
            fieldsBlock.line("@ReferenceAttribute");
            fieldsBlock.line("private Long id;");
            methodsBlock.line("public Long getId()");
            ((CodeBracket)methodsBlock.createContained(CodeBracket.class)).line("return this.id;");
            methodsBlock.line("public void setId(Long id)");
            ((CodeBracket)methodsBlock.createContained(CodeBracket.class)).line("this.id = id;");
        }
        this.generateCodeForAttributesOfAttributeHolder((NamedAttributeHolder)type, fieldsBlock, methodsBlock, importBlock, uniqueConstraintsByAttributeHolderName);
        return block;
    }

    private boolean typeRequiresIdField(Type type) {
        return type.getSuperType() == null;
    }

    private void generateCodeForAttributesOfAttributeHolder(NamedAttributeHolder attributeHolder, CodeBlock fieldsBlock, CodeBlock methodsBlock, CodeBlock importBlock, Map<String, List<UniqueConstraint>> uniqueConstraintsByAttributeHolderName) {
        Type t;
        List mixins;
        if (attributeHolder == null) {
            return;
        }
        List atts = attributeHolder.getAttributes();
        if (atts != null) {
            List<UniqueConstraint> uniqueConstraints = uniqueConstraintsByAttributeHolderName.get(attributeHolder.getName());
            for (Attribute att : atts) {
                if (uniqueConstraints != null) {
                    for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
                        if (uniqueConstraint.getAttributes().size() != 1 || uniqueConstraint.getAttributes().get(0) != att) continue;
                        SchemaBeanGeneratorMojo.assertIsImported(importBlock, "org.bndly.common.service.model.api.ReferenceAttribute", (ImportStateHolder)this.importStateHolder);
                        fieldsBlock.line("@ReferenceAttribute");
                    }
                }
                String javaTypeName = SchemaBeanGeneratorMojo.getJavaTypeNameForAttribute(att, importBlock, this.importStateHolder, true);
                fieldsBlock.line("private " + javaTypeName + " " + att.getName() + ";");
                String attUpperCased = SchemaBeanGeneratorMojo.upperCaseFirstLetter(att.getName());
                methodsBlock.line("@Override");
                methodsBlock.line("public void set" + attUpperCased + "(" + javaTypeName + " " + att.getName() + ")");
                ((CodeBracket)methodsBlock.createContained(CodeBracket.class)).line("this." + att.getName() + " = " + att.getName() + ";");
                methodsBlock.line("@Override");
                methodsBlock.line("public " + javaTypeName + " get" + attUpperCased + "()");
                ((CodeBracket)methodsBlock.createContained(CodeBracket.class)).line("return this." + att.getName() + ";");
            }
        }
        if (Type.class.isInstance(attributeHolder) && (mixins = (t = (Type)attributeHolder).getMixins()) != null) {
            for (Mixin mixin : mixins) {
                this.generateCodeForAttributesOfAttributeHolder((NamedAttributeHolder)mixin, fieldsBlock, methodsBlock, importBlock, uniqueConstraintsByAttributeHolderName);
            }
        }
    }
}

