/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.beans;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bndly.code.common.CodeGenerationContext;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeBracket;
import org.bndly.code.model.CodeLine;
import org.bndly.code.renderer.ImportResolver;
import org.bndly.schema.beans.AbstractSchemaBasedBeanGeneratorMojo;
import org.bndly.schema.beans.SchemaBeanGeneratorMojo;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.Type;

@Mojo(name="generateServices")
public class SchemaServiceInterfaceGeneratorMojo
extends AbstractSchemaBasedBeanGeneratorMojo {
    private static final String GENERIC_RESOURCE_SERVICE = "org.bndly.common.service.shared.api.GenericResourceService";
    @Parameter
    protected String schemaBeanSourcePackage;
    @Parameter
    public String customServiceInterfacesPath;
    @Parameter
    public String springBeanServiceImplementationPackage;
    @Parameter
    public String springBeanDefinitionPath;
    protected static final String SERVICE_INTERFACE_PREFIX = "Default";
    protected static final String CUSTOM_INTERFACE_PREFIX = "Custom";
    protected static final String SERVICE_INTERFACE_SUFFIX = "Service";
    private final List<String> customApiList = new ArrayList<String>();

    @Override
    protected void doCodeGenerationWithSchema(Schema schema, CodeGenerationContext ctx, File path) throws IOException, MojoExecutionException, MojoFailureException {
        ctx.setImportResolver(new ImportResolver(){

            public String resolveImport(String simpleName) {
                if (simpleName == null) {
                    throw new IllegalArgumentException("can not resolve import when simpleName is null.");
                }
                return simpleName;
            }
        });
        this.loadCustomServiceInterfaceNamesToList(this.customServiceInterfacesPath);
        OutputStream os = null;
        XMLStreamWriter xmlStream = null;
        try {
            List types;
            if (this.springBeanDefinitionPath != null && this.springBeanServiceImplementationPackage != null) {
                Path springBeanDefPath = Paths.get(this.springBeanDefinitionPath, new String[0]);
                Path springBeanFolder = springBeanDefPath.getParent();
                if (Files.notExists(springBeanFolder, new LinkOption[0])) {
                    Files.createDirectories(springBeanFolder, new FileAttribute[0]);
                }
                if (Files.notExists(springBeanDefPath, new LinkOption[0])) {
                    Files.createFile(springBeanDefPath, new FileAttribute[0]);
                }
                os = Files.newOutputStream(springBeanDefPath, StandardOpenOption.WRITE);
                xmlStream = XMLOutputFactory.newInstance().createXMLStreamWriter(os, "UTF-8");
            }
            if (xmlStream != null) {
                xmlStream.setDefaultNamespace("http://www.springframework.org/schema/beans");
                xmlStream.setPrefix("beans", "http://www.springframework.org/schema/beans");
                xmlStream.setPrefix("xmlns", "http://www.w3.org/2001/XMLSchema-instance");
                xmlStream.setPrefix("context", "http://www.springframework.org/schema/context");
                xmlStream.writeStartDocument();
                xmlStream.writeStartElement("beans");
                xmlStream.writeDefaultNamespace("http://www.springframework.org/schema/beans");
                xmlStream.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xmlStream.writeNamespace("context", "http://www.springframework.org/schema/context");
                xmlStream.writeNamespace("util", "http://www.springframework.org/schema/util");
                xmlStream.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context-3.0.xsd http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util-2.5.xsd");
            }
            if ((types = schema.getTypes()) != null) {
                if (xmlStream != null) {
                    xmlStream.writeStartElement("http://www.springframework.org/schema/util", "list");
                    xmlStream.writeAttribute("id", schema.getName() + "ServiceStubs");
                    for (Type type : types) {
                        if (type.isAbstract() || type.isVirtual()) continue;
                        xmlStream.writeEmptyElement("ref");
                        xmlStream.writeAttribute("bean", this.getServiceBeanName(type) + "Stub");
                    }
                    xmlStream.writeEndElement();
                }
                for (Type type : types) {
                    if (type.isAbstract() || type.isVirtual()) continue;
                    this.importStateHolder.reset();
                    CodeBlock defaultServiceCode = this.generateCodeForType(type, ctx);
                    this.writeCodeToFile(defaultServiceCode, path, (NamedAttributeHolder)type, SERVICE_INTERFACE_PREFIX, SERVICE_INTERFACE_SUFFIX);
                    CodeBlock fullAPIServiceCodeOfType = this.generateCodeForFullApiInterface(type, ctx);
                    this.writeCodeToFile(fullAPIServiceCodeOfType, path, (NamedAttributeHolder)type, SERVICE_INTERFACE_SUFFIX);
                    if (xmlStream == null) continue;
                    this.writeSpringBeanDefinition(xmlStream, type, ctx);
                }
            }
            if (xmlStream != null) {
                xmlStream.writeEndDocument();
            }
        }
        catch (XMLStreamException ex) {
            throw new MojoExecutionException("failed to create xml stream", (Exception)ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private CodeBlock generateCodeForType(Type type, CodeGenerationContext ctx) {
        String tName = type.getName();
        this.getLog().info((CharSequence)("generating java service client interface for type " + tName));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        block.line("package ").append(ctx.getBasePackage()).append(";");
        block.line("");
        block.line("import ").append(this.schemaBeanSourcePackage).append(".").append(tName).append(";");
        block.line("import ").append(GENERIC_RESOURCE_SERVICE).append(";");
        block.line("");
        block.line("public interface ").append(SERVICE_INTERFACE_PREFIX).append(SchemaBeanGeneratorMojo.upperCaseFirstLetter(tName)).append(SERVICE_INTERFACE_SUFFIX).append(" extends ").append("GenericResourceService<").append(tName).append(">");
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        bracket.line("");
        return block;
    }

    protected static String lowerCaseFirstLetter(String string) {
        string = string.length() > 1 ? string.substring(0, 1).toLowerCase() + string.substring(1) : string.toLowerCase();
        return string;
    }

    private void loadCustomServiceInterfaceNamesToList(String path) throws MojoExecutionException {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path file) throws IOException {
                if (file != null) {
                    return file.getFileName().toString().startsWith(SchemaServiceInterfaceGeneratorMojo.CUSTOM_INTERFACE_PREFIX) && file.toString().endsWith("Service.java");
                }
                return false;
            }
        };
        try (DirectoryStream<Path> customServiceDir = Files.newDirectoryStream(Paths.get(path, new String[0]), (DirectoryStream.Filter<? super Path>)filter);){
            for (Path p : customServiceDir) {
                int end = p.getFileName().toString().length() - ".java".length();
                String customClazzName = p.getFileName().toString().substring(0, end);
                this.customApiList.add(customClazzName);
            }
        }
        catch (IOException io) {
            throw new MojoExecutionException("No custom interfaces found!", (Exception)io);
        }
    }

    private CodeBlock generateCodeForFullApiInterface(Type type, CodeGenerationContext ctx) {
        String tName = type.getName();
        this.getLog().info((CharSequence)("generating " + tName + "Service FULL API-Interface for default and custom services"));
        CodeBlock block = (CodeBlock)ctx.create(CodeBlock.class);
        block.line("package ").append(ctx.getBasePackage()).append(";");
        block.line("");
        CodeLine line = (CodeLine)block.createContained(CodeLine.class);
        line.append("public interface ").append(SchemaBeanGeneratorMojo.upperCaseFirstLetter(tName)).append(SERVICE_INTERFACE_SUFFIX).append(" extends ").append(SERVICE_INTERFACE_PREFIX).append(SchemaBeanGeneratorMojo.upperCaseFirstLetter(tName)).append(SERVICE_INTERFACE_SUFFIX);
        String customClazzName = this.getCustomServiceInterfaceClassNameForType(type);
        if (customClazzName != null) {
            line.append(", ").append(customClazzName);
        }
        CodeBracket bracket = (CodeBracket)block.createContained(CodeBracket.class);
        bracket.line("String NAME = \"").append(this.getServiceBeanName(type)).append("\";");
        return block;
    }

    private String getServiceBeanName(Type type) {
        return SchemaServiceInterfaceGeneratorMojo.lowerCaseFirstLetter(type.getSchema().getName()) + type.getName() + SERVICE_INTERFACE_SUFFIX;
    }

    private String getFullApiName(Type type, CodeGenerationContext ctx) {
        return ctx.getBasePackage() + "." + this.getSimpleFullApiName(type);
    }

    private String getSimpleFullApiName(Type type) {
        return SchemaBeanGeneratorMojo.upperCaseFirstLetter(type.getName()) + SERVICE_INTERFACE_SUFFIX;
    }

    private String getCustomServiceInterfaceClassNameForType(Type type) {
        for (String customClazzName : this.customApiList) {
            int end = customClazzName.length() - SERVICE_INTERFACE_SUFFIX.length();
            String typeName = customClazzName.substring(CUSTOM_INTERFACE_PREFIX.length(), end);
            if (!type.getName().equals(typeName)) continue;
            return customClazzName;
        }
        return null;
    }

    private void writeSpringBeanDefinition(XMLStreamWriter xmlStream, Type type, CodeGenerationContext ctx) throws XMLStreamException {
        String stubBeanName = this.getServiceBeanName(type) + "Stub";
        String customServiceInterfaceClassNameForType = this.getCustomServiceInterfaceClassNameForType(type);
        xmlStream.writeStartElement("bean");
        xmlStream.writeAttribute("name", stubBeanName);
        xmlStream.writeAttribute("class", "org.bndly.common.service.setup.SchemaServiceStub");
        xmlStream.writeEmptyElement("property");
        xmlStream.writeAttribute("name", "schemaName");
        xmlStream.writeAttribute("value", type.getSchema().getName());
        xmlStream.writeEmptyElement("property");
        xmlStream.writeAttribute("name", "fullApiClassName");
        xmlStream.writeAttribute("value", this.getFullApiName(type, ctx));
        if (customServiceInterfaceClassNameForType != null) {
            xmlStream.writeEmptyElement("property");
            xmlStream.writeAttribute("name", "customServiceClassName");
            xmlStream.writeAttribute("value", this.springBeanServiceImplementationPackage + "." + CUSTOM_INTERFACE_PREFIX + type.getName() + "ServiceImpl");
        }
        xmlStream.writeEmptyElement("property");
        xmlStream.writeAttribute("name", "genericServiceClassName");
        xmlStream.writeAttribute("value", this.springBeanServiceImplementationPackage + "." + SERVICE_INTERFACE_PREFIX + type.getName() + "ServiceImpl");
        xmlStream.writeEndElement();
        xmlStream.writeStartElement("bean");
        xmlStream.writeAttribute("name", this.getServiceBeanName(type));
        xmlStream.writeAttribute("class", this.getFullApiName(type, ctx));
        xmlStream.writeAttribute("factory-bean", stubBeanName);
        xmlStream.writeAttribute("factory-method", "getFullApi");
        xmlStream.writeEndElement();
    }
}

